Extension { #name : 'TransactionBacklog' }

{ #category : 'Signalling' }
TransactionBacklog class >> disableSignalling [

"disable both SignaledAbort and SignaledFinishTransaction"
System _updateSignalErrorStatus: 8 toState: false .


]

{ #category : 'Signalling' }
TransactionBacklog class >> enableSignalling [

"Enables a TransactionBacklog Notification if this session
 should commit or abort.  If you want to only get the should commit or
 should abort Notification ,
 use System class>>enableSignaledFinishTransactionError
 or System class>>enableSignaledAbortError.

 If sent within a handlerBlock which is handling an instance of
 TransactionBacklog, the enable takes effect when execution
 leaves the handlerBlock via a return or resume .
"

"enable both SignaledAbort and SignaledFinishTransaction"
System _updateSignalErrorStatus: 8 toState: true .

]

{ #category : 'Signalling' }
TransactionBacklog class >> signallingEnabled [

"Return true if signaling enabled, return false otherwise.
 See TransactionBacklog(C)>>enableSignalling "

^ System _signalErrorStatus: 4

]

{ #category : 'Instance initialization' }
TransactionBacklog >> _legacyHandlerArgs [
  | arr |
  (arr := { inTransaction } ) addAll: super _legacyHandlerArgs .
  ^ arr

]

{ #category : 'Instance initialization' }
TransactionBacklog >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    inTransaction := anArray atOrNil: 1 .
    (sz := anArray size) > 1 ifTrue:[
      gsArgs := anArray copyFrom: 2 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
TransactionBacklog >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    str := 'inTransaction=', inTransaction asString .
    gsDetails ifNotNil:[:d| str add:', '; add: d  asString ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Handling' }
TransactionBacklog >> defaultAction [

"Return an error to the controlling debugger or GCI client .
 See AbstractException>>defaultAction for documentation."

^ self _signalToDebugger

]

{ #category : 'Instance initialization' }
TransactionBacklog >> initialize [
  gsNumber := ERR_TransactionBacklog.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Accessing' }
TransactionBacklog >> inTransaction [
  ^ inTransaction  "aBoolean"

]
