Extension { #name : 'QuadByteString' }

{ #category : 'Formatting' }
QuadByteString class >> charSize [

"Returns number of bytes that make up a character for this string class."

^ 4

]

{ #category : 'Instance Creation' }
QuadByteString class >> new [

"Returns a new instance of the receiver."

^ self _basicNew

]

{ #category : 'Instance Creation' }
QuadByteString class >> new: aSize [

"Returns a new instance of the receiver, of sufficient size to hold aSize
 Characters of two bytes each."

^ self _basicNew:  aSize * 4

]

{ #category : 'Instance Creation' }
QuadByteString class >> withAll: aString [

"Returns an instance of the receiver containing the elements of the argument."
<primitive: 775>
^ super withAll: aString

]

{ #category : 'Converting' }
QuadByteString >> _asDoubleByteString [

"Returns a DoubleByteString representation of the receiver if all of the
 Characters in the receiver can be represented as two-byte Characters.
 Returns nil if any of the Characters in the receiver cannot be represented as
 two-byte Characters."

<primitive: 702>
^ self _primitiveFailed: #_asDoubleByteString .

]

{ #category : 'Private' }
QuadByteString >> _basicAt: anInteger put: aValue [

"Disallowed, use codePointAt:put:"
self shouldNotImplement: #_basicAt:put:

]

{ #category : 'Private' }
QuadByteString >> _basicSize: anInteger [

"Disallowed"
self shouldNotImplement: #_basicSize:

]

{ #category : 'Concatenating' }
QuadByteString >> , aCharOrCharColl [

"Returns a new instance of the receiver's class that contains the elements of
 the receiver followed by the elements of aCharOrCharColl.  The argument
 must be a String, a DoubleByteString, or a Character.

 The result may not be an instance of the class of the receiver if one of the
 following rules applies:

 1) If the receiver is a  QuadByteSymbol, the result  is a  QuadByteString.

 Warning: Creating a new instance and copying the receiver take time.  If you
 can safely modify the receiver, it can be much faster to use the addAll:
 method.  See the documentation of the Concatenating category of class
 SequenceableCollection for more details."

<primitive: 444 >
^ self copy addAll: aCharOrCharColl; yourself

]

{ #category : 'Adding' }
QuadByteString >> add: aCharOrCharColl [

"Appends all of the elements of aCharOrCharColl to the receiver and returns
 aCharOrCharColl."

<primitive: 776>
aCharOrCharColl class == Character ifTrue:[ | cp |
  cp := aCharOrCharColl codePoint .
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
  ].
  ^ self _primitiveFailed: #add: args: { aCharOrCharColl }
].
aCharOrCharColl _validateClass: CharacterCollection .
^ self add: aCharOrCharColl asQuadByteString

]

{ #category : 'Adding' }
QuadByteString >> addAll: aCharOrCharColl [

"Equivalent to add: aCharOrCharColl."

<primitive: 776>
aCharOrCharColl class == Character ifTrue:[ | cp |
  cp := aCharOrCharColl codePoint .
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
  ].
  ^ self _primitiveFailed: #add: args: { aCharOrCharColl }
].
(aCharOrCharColl isKindOf: CharacterCollection) ifTrue:[
  ^ self add: aCharOrCharColl asQuadByteString.
].
aCharOrCharColl do: [:each | self add: each].
^aCharOrCharColl.

]

{ #category : 'Adding' }
QuadByteString >> addLast: aCharOrCharColl [

"Equivalent to add: aCharOrCharColl."

<primitive: 776>
aCharOrCharColl class == Character ifTrue:[ | cp |
  cp := aCharOrCharColl codePoint .
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
  ].
  ^ self _primitiveFailed: #add: args: { aCharOrCharColl }
].
aCharOrCharColl _validateClass: CharacterCollection .
^ self add: aCharOrCharColl asQuadByteString

]

{ #category : 'Deprecated' }
QuadByteString >> asciiLessThan: aString [

"Returns true if the receiver collates before the argument using the
 ASCII collating table, which collates AB...Z...ab..z."

self deprecated: 'QuadByteString>>asciiLessThan: deprecated in 3.2.'.
^ self lessThan: aString collatingTable: QuadByteAsciiCollatingTable

]

{ #category : 'Converting' }
QuadByteString >> asDoubleByteString [

 "Returns a DoubleByteString (2 bytes per Character) representation of the receiver
 if all of the Characters in the receiver can be represented as two-byte Characters.
 Otherwise, returns the receiver."

| result |
(result := self _asDoubleByteString) ifNil:[ ^ self ].
^ result

]

{ #category : 'Converting' }
QuadByteString >> asQuadByteString [
  ^ self

]

{ #category : 'Accessing' }
QuadByteString >> at: anIndex [

"Returns the Character at anIndex."

<primitive: 655>
(anIndex _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
QuadByteString >> at: anIndex put: aChar [

"Stores aChar at the specified location and returns aChar."

<primitive: 667>
| cp |
aChar _validateClass: Character .
cp := aChar codePoint .
(cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
  ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
].
(anIndex _isSmallInteger) ifTrue: [
  ((anIndex > (self size + 1)) or: [anIndex <= 0]) ifTrue: [
    ^ self _errorIndexOutOfRange: anIndex
    ].
] ifFalse:[
  ^ self _errorNonIntegerIndex: anIndex
] .
self _primitiveFailed: #at:put: args: { anIndex . aChar }

]

{ #category : 'Accessing' }
QuadByteString >> atOrNil: anIndex [

"Returns the Character at anIndex, or nil if anIndex is beyond end of the receiver"

<primitive: 655>
(anIndex _isSmallInteger)
  ifTrue: [ ^ nil ]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #atOrNil: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Formatting' }
QuadByteString >> charSize [

"Returns number of bytes that make up a character for this string class."

^ 4

]

{ #category : 'Accessing' }
QuadByteString >> codePointAt: anIndex [

"Returns the integer value of the Character at anIndex in the receiver."

<primitive: 1073>

(anIndex _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #codePointAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
QuadByteString >> codePointAt: anIndex put: aValue [

"Stores codePoint aValue at the specified location, with autogrow.
 Returns aValue.
"
 self at: anIndex put: (Character withValue: aValue)

]

{ #category : 'Encoding' }
QuadByteString >> encodeAsUTF16 [

"Encode receiver in UTF16 format.  Returns a Utf16 .
 Generates an error if any character value in receiver exceeds
 the maximum utf32 value 16r10FFFF."

<primitive: 1084>
self _primitiveFailed: #encodeAsUTF16

]

{ #category : 'Encoding' }
QuadByteString >> encodeAsUTF8 [

"Encode receiver in UTF8 format.  Returns a Utf8 .
 Generates an error if any character value in receiver exceeds
 the maximum utf32 value 16r10FFFF."

<primitive: 468>
1 to: self size do:[:n | | v |
  v := self wordAt: n .
  v > 16r10FFFF ifTrue:[
    self error:'character at:', n asString , ' exceeds max legal utf 16r10FFFF'
  ].
].
self _primitiveFailed: #encodeAsUTF8

]

{ #category : 'Encoding' }
QuadByteString >> encodeAsUTF8IntoString [
"Encode receiver in UTF8 format.  Returns a String. For Seaside"

<primitive: 994>
1 to: self size do:[:n | | v |
  v := self wordAt: n .
  v > 16r10FFFF ifTrue:[
    self error:'character at:', n asString , ' exceeds max legal utf 16r10FFFF'
  ].
].
self _primitiveFailed: #encodeAsUTF8IntoString

]

{ #category : 'Adding' }
QuadByteString >> insertAll: aCharOrCharColl at: anIndex [

"Inserts aCharOrCharColl at the specified index.  Returns aCharOrCharColl."

<primitive: 447>
anIndex _isSmallInteger ifFalse:[ anIndex _validateClass: Integer ].
((anIndex <= 0) or: [anIndex > (self size + 1)])
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
aCharOrCharColl _validateClasses: { Character . CharacterCollection }.
^self insertAll: aCharOrCharColl asDoubleByteString at: anIndex.

]

{ #category : 'Copying' }
QuadByteString >> replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex [

"Replaces the elements of the receiver between the indexes startIndex and
 stopIndex inclusive with the elements of aSeqCollection starting at repIndex.
 If aSeqCollection is identical to the receiver, the source and
 destination blocks may overlap.

 Returns the receiver."

<primitive: 777>
| recInfo uStr |
startIndex _isSmallInteger ifFalse:[ startIndex _validateClass: SmallInteger ].
stopIndex _isSmallInteger ifFalse:[ stopIndex _validateClass: SmallInteger ].
repIndex _isSmallInteger ifFalse:[ repIndex _validateClass: SmallInteger ].
recInfo := self _stringCharSize .
(recInfo bitAnd: 16r8) ~~ 0 ifTrue:[  "receivier is a Utf string"
  (uStr := aSeqCollection asUnicodeString) ~~ aSeqCollection ifTrue:[
    ^ self replaceFrom: startIndex to: stopIndex with: uStr startingAt: repIndex .
  ].
].
^ super replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex

]

{ #category : 'Accessing' }
QuadByteString >> size [

"Returns the number of Characters in the receiver."

^ self _basicSize // 4 .

]

{ #category : 'Updating' }
QuadByteString >> size: anInteger [

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to
 codePoint zero."

^ super _basicSize: 4 * anInteger

]

{ #category : 'Private' }
QuadByteString >> squeakBasicAt: anInteger put: aValue [

"Disallowed, use codePointAt:put:"
self shouldNotImplement: #squeakBasicAt:put:

]
