Extension { #name : 'OffsetError' }

{ #category : 'Instance initialization' }
OffsetError >> _legacyHandlerArgs [
  | arr |
  arr := { object . maximum . actual } .
  gsArgs ifNotNil:[:a |  arr addAll: a ].
  ^ arr

]

{ #category : 'Instance initialization' }
OffsetError >> args: anArray [
  anArray _isArray ifTrue:[ | sz o |
    object := (o := anArray atOrNil: 1) .
    (actual := anArray atOrNil: 2 ) ifNotNil:[
      maximum := (anArray atOrNil: 3) ifNil:[ o ifNotNil:[ o size ]].
      (sz := anArray size) > 3 ifTrue:[
        gsArgs := anArray copyFrom: 4 to: sz
      ].
    ].
  ]

]

{ #category : 'Formatting' }
OffsetError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    str := String new .
    object ifNotNil:[:o | str add: 'accessing a '; add: o class name ].
    maximum ifNotNil:[:m |
      str := String new .
      str add:'max:'; add: m asString .
      actual ifNotNil:[:a| str add: ' actual:'; add: a asString].
    ].
    gsDetails ifNotNil:[:d| str add:', '; add: d  asString ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
OffsetError >> initialize [
  gsNumber := ERR_OffsetError.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Instance initialization' }
OffsetError >> offset: anOffset maximum: aMax [
  actual := anOffset .
  maximum := aMax

]
