Extension { #name : 'ObjectsCommittedNotification' }

{ #category : 'Signalling' }
ObjectsCommittedNotification class >> disableSignalling [

"Prevent instances of ObjectsCommittedNotification from being signalled by the VM."

 System _updateSignalErrorStatus: 1 toState: false

]

{ #category : 'Signalling' }
ObjectsCommittedNotification class >> enableSignalling [

"Enable instances of ObjectsCommittedNotification to be signalled by the VM .
 must be resent by exception handling code after handling each
 instance of ObjectsCommittedNotification that was signalled by the VM."

 System _updateSignalErrorStatus: 1 toState: true

]

{ #category : 'Signalling' }
ObjectsCommittedNotification class >> signallingEnabled [

"Return true if signaling enabled, return false otherwise  .
 See ObjectsCommittedNotification(C)>>enableSignalling "

^ System _signalErrorStatus: 1

]

{ #category : 'Handling' }
ObjectsCommittedNotification >> defaultAction [

"Return an error to the controlling debugger or GCI client .
 See AbstractException>>defaultAction for documentation."

 ^ self _signalToDebugger
]

{ #category : 'Instance initialization' }
ObjectsCommittedNotification >> initialize [
  gsNumber := ERR_ObjectsCommittedNotification.
  gsResumable := true .
  gsTrappable := true .

]
