Extension { #name : 'Object' }

{ #category : 'Debugging' }
Object class >> _classOf: anObject [

"return    anObject class  "
<primitive: 464>  "equivalent to primitive: 610, needed by ProtoObject"

self _primitiveFailed: #_classOf: args: { anObject }

]

{ #category : 'Encoded OOPs' }
Object class >> _getOopOrObjectFromOldOop: anInt opCode: anOpCode [

"Convert the specified old (Gs64 v1.1 OOP format) OOP to either
 an object or the new (Gs64 v2.0 OOP format) OOP, depending
 on the opCode.  An opCode of zero means return the
 object if it exists or nil if it does not.  A non-zero opCode
 means return a positive Integer representing the new OOP."
<primitive: 539>

self _primitiveFailed: #_getOopOrObjectFromOldOop:opCode:
     args: { anInt . anOpCode }

]

{ #category : 'Encoded OOPs' }
Object class >> _getOopWithOldLow: anInt high: anotherInt opCode: anOpCode [

"Convert the specified Gs64 v1.1 double encoded OOP into either an object
 or an Integer representing the Gs64 v2.0 OOP of the object.
 If the opCode is zero, then the object is returned if it
 exists.  nil is returned if the object does not exist.
 If the opCode is not zero, then a SmallInteger representing the OOP of the object is
 returned.  The object with this OOP is not verified to exist."

<primitive: 537>
anInt _validateClass: SmallInteger.
anotherInt _validateClass: SmallInteger.
anOpCode _validateClass: SmallInteger.
(anInt > 65535) ifTrue:[self _errorIndexOutOfRange: anInt].
(anotherInt > 65535) ifTrue:[self _errorIndexOutOfRange: anotherInt].
self _primitiveFailed: #_getOopWithOldLow:high:opcode:
     args: { anInt . anotherInt . anOpCode }

]

{ #category : 'Private' }
Object class >> _objectForOop: aPositiveInt [

" return the object with the given objectId, or nil if no such
  object exists.  The objectId may specify a special object.

  The argument must be >= 0 and must be either
  a SmallInteger or a LargeInteger, otherwise the primitive
  will fail."

<primitive: 38>
(aPositiveInt isKindOf: Integer)
    ifFalse: [ ^ aPositiveInt _error: #rtErrBadArgKind args: { Integer }].
(aPositiveInt < 0)
    ifTrue: [ ^ aPositiveInt _error: #rtErrArgNotPositive ].
^ self _primitiveFailed: #_objectForOop: args: { aPositiveInt }

]

{ #category : 'Private' }
Object class >> _oop11toOop20: a11oop [

"Given the Integer value of a objectId from Gemstone64 v1.1,
 return the value of the Gemstone v2.0 objectId .  The objectId
 is assumed must be of a Pom object, not a special object."

(a11oop bitAnd: 1) == 0 ifTrue:[ nil error:'argument is not a Pom oop'].
^  ((a11oop bitShift:-1) bitShift:8 ) bitOr: 1

]

{ #category : 'Private' }
Object class >> _oop20toOop11: a20oop [

"Given the Integer value of a objectId from Gemstone64 v2.0,
 return the value of the Gemstone v1.1 objectId .  The objectId
 is assumed must be of a Pom object, not a special object."

(a20oop bitAnd: 1) == 0 ifTrue:[ nil error:'argument is not a Pom oop'].
^  ((a20oop bitShift:-8) bitShift:1 ) bitOr: 1

]

{ #category : 'Encoded OOPs' }
Object class >> getNewOopFromOldOop: anInteger [

"Convert the specified old OOP in Gs64 v1.1 OOP format to
 an OOP in Gs64 v2.0 format.  For OOPs representing objects other
 than SmallIntegers or SmallDoubles the result will always be a SmallInteger;
 otherwise it is possible for the result to be a LargeInteger.
 The argument may be a positive SmallInteger or LargeInteger "

^self _getOopOrObjectFromOldOop: anInteger opCode: 1

]

{ #category : 'Encoded OOPs' }
Object class >> getNewOopWithLow: anInt high: anotherInt [

"Convert the specified double encoded OOP into an Integer representing
 the OOP of the object.  The object with the return OOP is not verified
 to exist."

^self _getOopWithOldLow: anInt high: anotherInt opCode: 1

]

{ #category : 'Encoded OOPs' }
Object class >> getObjectFromOldOop: anInteger [

"Convert the specified old OOP in Gs64 v1.1 OOP format to
 a Gs64 v2.0 object identifier. Return  the object represented by
 the new object identifier , or nil if it does not exist."

^self _getOopOrObjectFromOldOop: anInteger opCode: 0

]

{ #category : 'Encoded OOPs' }
Object class >> getObjectWithOldLow: anInt high: anotherInt [

"Convert the specified Gs64 v1.1 double encoded OOP into the object represented
 by that OOP.  nil is returned if the object does not exist."

^self _getOopWithOldLow: anInt high: anotherInt opCode: 0

]

{ #category : 'Encoded OOPs' }
Object class >> getOldOopWithOldLow: anInt high: anotherInt [

"Returns a SmallInteger representing the Old OOP
value of the specified double encoded OOP.  No checking is done to
ensure the object with OOP returned actually exists.  Answer nil if the
arguments are invalid or are not instances of SmallInteger."

(anInt < 0 or:[ anInt > 65535]) ifTrue:[ ^ nil ].
(anotherInt < 0 or:[ anotherInt > 65535]) ifTrue:[ ^ nil ].
^ (anotherInt bitShift:16)  bitOr: anInt .

]

{ #category : 'Storing and Loading' }
Object class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

| inst |
"create a new instance and fill it full of information contained
 in the passiveObj"
self isVariable ifTrue: [
  inst := self _basicNew: passiveObj readSize.
  ]
ifFalse: [
  inst := self _basicNew
  ].
inst loadFrom: passiveObj.
^inst

]

{ #category : 'Debugging' }
Object class >> objectForOop:  aPositiveInt [

" Return the object with the given oop, or an error if no such object
  exists.  The oop may specify a special object.

  There are risks associated with oop fishing, particularly when using
  oops across transaction boundaries and between sessions. The numeric
  oop is not a reference, and GC of otherwise unreferenced objects means
  that the object previously corresponding to a particular oop may no
  longer exist or be a different object than expected.

  This method is provided for convenience for debugging and for experienced
  users who understand the internal behavior and the risks involved."

 | result |
 result := self _objectForOop: aPositiveInt.
 result ifNil:[
   (aPositiveInt == 20"nil asOop" ) ifTrue: [ ^ nil ].
   ArgumentError signal:'The object with oop ', aPositiveInt asString,' does not exist' .
 ].
 ^ result
]

{ #category : 'Private' }
Object >> __changeClassTo: aClass preserveVarying: aBoolean [

"Redefines the class of the receiver to be aClass.
 Checks 1..5 documented for changeClassTo:  are done in the primitive."

<protected primitive: 270>
aClass _validateClass: Class.  "argument must be a Class"
aBoolean _validateClass: Boolean .
self _error: #rtErrCantChangeClass args: { aClass . ''  }

]

{ #category : 'Reduced Conflict Support' }
Object >> _abortAndReplay: conflictObjects [

  "Abort the receiver and replay operations on the receiver from the redo log."

  | redoLog logEntries systm |
  redoLog := (systm := System) _redoLog.
  redoLog ifNil:[
    systm rcValueCacheAt: #'Rc-Retry-Failure-Reason' put: #'noRedoLog' for: systm ;
          rcValueCacheAt: #'Rc-Retry-Failure-Description' put: 'No redoLog for replay' for: systm .
    ^ false 
  ].
  (logEntries := redoLog getLogEntriesFor: self) ifNil:[
     systm rcValueCacheAt: #'Rc-Retry-Failure-Reason' put: #'noRedoLogForObject' for: systm ;
           rcValueCacheAt: #'Rc-Retry-Failure-Description'
          put: 'No redoLog for object [',  self asOop printString, ']'
          for: systm .
      ^ false 
  ].
  self _hasDependencyList ifTrue: [
    systm rcValueCacheAt: #'Rc-Retry-Failure-Reason' put: #'objHadDependency' for: systm ;
        rcValueCacheAt: #'Rc-Retry-Failure-Description'
        put: 'The object [', self asOop printString, '] has a dependency list. Replay not allowed.'
        for: systm .
    ^ false 
  ].
  self _selectiveAbort .
  ^ redoLog _redoOperationsForEntries: logEntries
]

{ #category : 'Reduced Conflict Support' }
Object >> _addNamedIvsToRcRead [

"Adds a small receiver, or path to the left most leaf of a large receiver
 to the rcReadSet.  Returns self.
 Receiver may not be a kind of IdentityBag nor a special object."

<primitive: 856>
self _primitiveFailed: #_addNamedIvsToRcRead

]

{ #category : 'Accessing' }
Object >> _alias [

"This method returns an alias for the receiver.  The alias is a
 kind of Integer.  It may be a SmallInteger or LargeInteger.
 The alias for any set of objects is unique."

<primitive: 609 >

self _primitiveFailed: #alias .
self _uncontinuableError

]

{ #category : 'Private' }
Object >> _allElements [

"Receiver should be a large oop or byte format Collection.
 Returns nil if receiver has NSC or special format ,
         or if receiver is a Symbol.

 Returns an Array containing all the elements of an oop format
 receiver.  The result will contain all nils that were present
 in leaf nodes, but will omit nils that would have been in
 unpopulated portions of a large object.  Thus the result should
 contain key,value pairs in order for a dictionary .

 Returns a instance of the class of the receiver containing
 all the bytes of a byte format receiver, omitting those portions
 that were never stored into.  It is assumed that Strings being
 enumerated were not sparse, i.e. they were built by normal
 concatenation or insertion and not by code like
   | s | s := String new: 100000 .
   s at: 50000 put: $X .
   'abc' copyFrom:1 to: 3 into: s startingAt: 10000 .

 Provided for use in enumerating objects to repair a repository
 after bug 43141."

<primitive: 962>
^ self _primitiveFailed: #_allElements

]

{ #category : 'Accessing' }
Object >> _at: anIndex [

"This method provides indexed access to indexable objects,
 and provides pseudo-indexed access to non-sequenceable collections,
 and provides logical indexed access to CharacterCollections whose
 Characters are composed of multiple physical bytes.

 May be reimplemented; for examples see Bag, CharacterCollection.

 The methods _at:, _basicAt:, and _basicSize operate on the logically
 indexable contents of the receiver.

 Implemented here as a direct call to a primitive for efficiency.  The
 primitive generates an error if the receiver is not indexable, or if anIndex
 is not a SmallInteger or is out of bounds."

<primitive: 32>

(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
(anIndex _isInteger)
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #_at: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> _at: anIndex put: aValue [

"Signals an error if the receiver is not indexable or variant,
 or if anIndex is not a SmallInteger or is out of bounds.

 May be reimplemented.

 The primitive is equivalent to GciStoreIdxOop or GciStoreByte,
 depending on implementation of the receiver."

<primitive: 268>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(self class isBytes)
ifTrue:
  [ ((aValue class ~~ SmallInteger) or: [ (aValue < 0) | (aValue > 255) ])
    ifTrue: [^ aValue _error: #rtErrExpectedByteValue].
  ].

self _primitiveFailed: #_at:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Accessing' }
Object >> _basicAt: anIndex [

"Signals an error if the receiver is not
 indexable, or if anIndex is not a SmallInteger or is out of bounds.

 This method is for internal use in implementation of the kernel classes.

 The methods _at:, _basicAt:, and _basicSize operate on the logically
 indexable contents of the receiver.

 This method must not be overridden."

<primitive: 32>

(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
(anIndex _isInteger)
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #_basicAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> _basicAt: anIndex put: aValue [

"Signals an error if the receiver is not indexable or variant,
 or if anIndex is not a SmallInteger or is out of bounds.

 This method must not be overridden; contrast with Object|at:put:.

 The primitive is equivalent to GciStoreIdxOop or GciStoreByte,
 depending on implementation of the receiver."

<primitive: 268>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(self class isBytes)
ifTrue:
  [ ((aValue class ~~ SmallInteger) or: [ (aValue < 0) | (aValue > 255) ])
    ifTrue: [^ aValue _error: #rtErrExpectedByteValue].
  ].

self _primitiveFailed: #_basicAt:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Deprecated' }
Object >> _basicCopyWithoutTags [

"Returns a copy of the receiver which shares the receiver's instance
 variables.  Tags, if any, are not copied."
self deprecated: 'Object>>_basicCopyWithoutTags deprecated around v3.0, Should use dynamicInstVars, not tags'.
^self _basicCopyWithoutTagsPrim.

]

{ #category : 'Deprecated' }
Object >> _basicCopyWithoutTagsPrim [

<primitive: 55>
self _primitiveFailed: #_basicCopyWithoutTagsPrim .
self _uncontinuableError

]

{ #category : 'Accessing' }
Object >> _basicSize [

"The returned value reflects the allowable bounds in Object|_basicAt:
 and Object|_basicAt:put:.
 This method must not be overridden; contrast with Object|size.

 The methods _at:, _basicAt:, and _basicSize operate on the logically
 indexable contents of the receiver.

 The primitive is equivalent to GciFetchIdxSize(self) . 
 For byte format objects it returns the size in bytes."

<primitive: 0>

^0 "for non-indexable objects, returns zero for their size"

]

{ #category : 'Updating' }
Object >> _basicSize: anInteger [

"Changes the size of the receiver to anInteger.
 Returns the receiver.

 If anInteger is less than the current size of the receiver, the
 receiver is shrunk accordingly.  If anInteger is greater than the
 current size of the receiver, the receiver is extended and new
 elements are initialized to nil.

 Generates an error if anInteger is not a SmallInteger,
 or if the receiver is not indexable.  This method should not be
 overridden in subclasses."

<primitive: 603 >

(self class isIndexable not) "not an indexable object"
  ifTrue: [ ^ self _errorNotIndexable].
(anInteger _isInteger)
   ifTrue: [ ^ self _errorIndexOutOfRange: anInteger]
   ifFalse: [ ^ self _errorNonIntegerIndex: anInteger].
self _primitiveFailed: #_basicSize: args: { anInteger } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> _becomeDictionary: anObject [

<primitive: 2001>  "enter protected mode"
| prot |
prot := System _protectedMode .
[
  self ~~ anObject ifTrue:[
    self _primitiveBecome: anObject forDict: true .
    self _resetParentRef .
    anObject _resetParentRef .
  ]
] ensure:[
  prot _leaveProtectedMode
].

]

{ #category : 'Updating' }
Object >> _becomeMinimalChecks: anObject [

"Performs the become operation
 (see documentation for Object>>become: for more details)

 Does not check for receiver or anObject being on stack as self.
 Will fail if receiver or anObject participates in an index ,
 or is a kind of object not legal for become: .
 Returns self (which will have swapped identity with anObject) "

<primitive: 2001>  "enter protected mode"
| prot |
prot := System _protectedMode .
[
  self ~~ anObject ifTrue:[
    self _primitiveBecome: anObject forDict: false .
    self _resetParentRef .
    anObject _resetParentRef .
  ]
] ensure:[
  prot _leaveProtectedMode
].

]

{ #category : 'Class Membership' }
Object >> _changeClassTo: aClass preserveVarying: aBoolean [

<primitive: 2001>  "enter protected mode"
| prot |
prot := System _protectedMode .
^ [
    (self _onStackAsSelfBelow: 4) ifTrue:[
      self _error: #rtErrCantBecomeSelfOnStack
    ].
    self __changeClassTo: aClass preserveVarying: aBoolean
  ] ensure:[
    prot _leaveProtectedMode
  ].

]

{ #category : 'Deprecated' }
Object >> _changeToSegment: anObjectSecurityPolicy [

self deprecated: 'Object>>_changeToSegment: deprecated v3.0, use #objectSecurityPolicy:'.
^self objectSecurityPolicy: anObjectSecurityPolicy

]

{ #category : 'Private' }
Object >> _checkLogEntriesForNoSelector: selector [

"This method returns true only if the RcLogEntries for this transaction do
 NOT contain the specified selector.  If the selector is found then we
 take the conservative approach and fail the transaction because we cannot
 guarantee that it can succeed after performing the redo."

| redoLog logEntries |

redoLog := System _redoLog.
redoLog == nil
  ifTrue: [ ^ false ].

logEntries := redoLog getLogEntriesFor: self.
" if no log entries to replay, then we're done "
logEntries == nil
  ifTrue: [ ^ false ].

1 to: logEntries size do: [ :i |
  (logEntries at: i) selector == selector
    ifTrue: [ ^ false ]
].
^ true

]

{ #category : 'Error Handling' }
Object >> _checkReadStream: aStream forClass: aClass [

(aStream collection isKindOf: aClass)
ifFalse:
  [ ^ self _error: #rtErrBadStreamColl args: { aStream . aClass } ]

]

{ #category : 'Class Membership' }
Object >> _class [

"Returns the object that is the receiver's class.
 Provided for compatiblity with previous releases.

 _class was not supported in a Maglev Ruby repository."

<primitive: 610 >
^ self _primitiveFailed: #_class .

]

{ #category : 'Testing' }
Object >> _class: aClass
includesSelector: aSymbol [

"Used in testing only.  Generates an error if the selector aSymbol is not found
 in the method dictionary of the class aClass when the search for the selector
 begins in the class of the receiver."

| actualImplementor |
actualImplementor := self class whichClassIncludesSelector: aSymbol .
actualImplementor ~~ aClass
ifTrue:
   [ ^ self _error: #classErrSelectorLookup
       args: { actualImplementor . aClass . aSymbol }
   ]

]

{ #category : 'Class Membership' }
Object >> _classHistoryIncludesIdentical: aClass [
  self classHistory ifNotNil:[:ch | ^ (ch indexOfIdentical: aClass) ~~ 0 ] .
  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _classSortOrdinal [

^ 100

]

{ #category : 'New Indexing Comparison' }
Object >> _classSortsGreaterThan: anObject [

^self _classSortOrdinal > anObject _classSortOrdinal

]

{ #category : 'New Indexing Comparison' }
Object >> _classSortsLessThan: anObject [

^self _classSortOrdinal < anObject _classSortOrdinal

]

{ #category : 'Modification Tracking' }
Object >> _clearModificationTrackingTo: tracker [

"Remove the given tracker from the receiver's dependency list."

DependencyList removeTracker: tracker for: self.

]

{ #category : 'Compression' }
Object >> _compress [

"If receiver is not a byte format object, or is a Symbol or Number, returns self.
 Otherwise returns a ByteArray with a dynamic instVar #sourceClass containing
 class of the receiver of _compress, and a body that is the receiver compressed
 using zlib.so.
 Use  ByteArray>>_decompress  to decompress the ByteArray."

<primitive: 507>
self _primitiveFailed: #_compress

]

{ #category : 'Copyright' }
Object >> _copyright [

"Copyright notice"

^
'Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.'

]

{ #category : 'Compression' }
Object >> _decompress [

"Returns receiver.  See also ByteArray>>_decompress , Object>>_decompress: "

^ self

]

{ #category : 'Compression' }
Object >> _decompress: inflateFlag [

"Return self or an instance of original class with body decompressed
 using zlib.so.
 From Gs64 v3.3 onwards, receiver should always be a ByteArray.
 If receiver is a ByteArray and contains a dynamic instVar #sourceClass ,
 then the value of that instVar is used as the class of the result.

 inflateFlag:
  0 - raw, no headers (inverse of _compress)
  1 - gzip headers (interim format deprecated , was _decompressZipArchive)

 Signals an error if the inflate call to zlib library fails.
"

<primitive: 508>
(inflateFlag == 0 or:[ inflateFlag == 1]) ifFalse:[
   inflateFlag _error: #rtErrArgOutOfRange args:{ 0 . 1 }
].
self _primitiveFailed: #_decompress: args: { inflateFlag }

]

{ #category : 'Private' }
Object >> _deepCopyNamedIvsWith: copiedObjDict to: copy [

| myClass nFixedIvs |
myClass := self class .
myClass firstPublicInstVar to: (nFixedIvs := self namedSize ) do: [ :i |
  copy instVarAt: i put: ((self instVarAt: i) _deepCopyWith: copiedObjDict).
].
self tagSize ~~ 0 ifTrue:[ |dynIvNames sym |
  dynIvNames := self _instvarNamesAfter: nFixedIvs .
  1 to: dynIvNames size do:[:j |
    sym := dynIvNames at: j .
    copy dynamicInstVarAt: sym
           put: ((self dynamicInstVarAt: sym) _deepCopyWith: copiedObjDict)
  ].
].

]

{ #category : 'Private' }
Object >> _deepCopyWith: copiedObjDict [

"Private.

 Used internally to implement deepCopy."

| copy myClass |

self isSpecial ifTrue: [ ^ self ].

copy := copiedObjDict at: self otherwise: nil.
copy ~~ nil ifTrue: [ ^ copy ].

copy := self copy.
copiedObjDict at: self put: copy.

myClass := self class.
myClass isBytes ifTrue: [ ^ copy ].

"make deep copies of all the instance variables"
self _deepCopyNamedIvsWith: copiedObjDict to: copy .

"make deep copies of all the objects in the indexable part"
(myClass isIndexable) ifTrue: [
    1 to: self _basicSize do: [ :i | | element elementCopy |
      element := self basicAt: i.
      elementCopy := element _deepCopyWith: copiedObjDict.
      (element == elementCopy)
        ifFalse: [ copy basicAt: i put: elementCopy ].
    ].
].
^ copy

]

{ #category : 'Private' }
Object >> _dnuError: aSymbol args: anArray reason: dnuKind [
 "dnuKind constants must agree with  DNU_ constants in om.hf .
  Not using class variables for DNU_* to avoid polluting name space of Object. "
 | err |
 err := InternalError new .
 dnuKind _isSmallInteger ifTrue:[
   dnuKind == 1 ifTrue:[
     err details: 'method needs recompile, receiver a ',
	  self class name , ' , selector #', aSymbol  ;
	   tag: { self . aSymbol }.
   ] ifFalse:[
     dnuKind == 2 ifTrue:[ err details: 'method load error DNU_failure2' ].
     dnuKind == 3 ifTrue:[ err details: 'method load error DNU_failure3' ].
     dnuKind == 4 ifTrue:[ err details: 'method is not invariant' ].
     dnuKind == 5 ifTrue:[ err details: 'method load error DNU_largeLeafMissing'].
     dnuKind == 6 ifTrue:[ err details:'method load error DNU_badExtrasSize' ].
     dnuKind == 7 ifTrue:[ err details:'method load error DNU_methodDoesNotExist' ].
     err tag:{ self . aSymbol . anArray }.
   ].
 ] ifFalse:[
   err details: 'method oop:' , dnuKind asOop asString, ' needs recompile, receiver a ',
	  self class name , ' , selector #', aSymbol  ;
	   tag: { self . aSymbol }.
 ].
 ^ err signal .

]

{ #category : 'Private' }
Object >> _doesNotUnderstand: aSymbol args: anArray envId: aSmallInt reason: dnuKind [
  "This private message is sent by the virtual machine. The implementation must
 be in the persistent method dictionary for Object, since the method is preloaded
 during VM startup.  Reimplementations in a session methods dictionary will not
 be seen."

  dnuKind ~~ 0 ifTrue: [
    "a more severe problem such as method needing recompile"
    self _dnuError: aSymbol args: anArray reason: dnuKind
  ].
  aSmallInt == 0 ifTrue:[
     "this path for compatibility with Gs64 v2.x, and assumes you are using
      only method environment 0  for all of your Smalltalk code."
     aSymbol == #doesNotUnderstand: ifTrue:[
       ^ Error signal:'recursive doesNotUnderstand'.
     ]. 
     ^self doesNotUnderstand: (Message selector: aSymbol arguments: anArray)
  ].
  aSymbol == #doesNotUnderstand:args:envId: ifTrue:[
    ^ Error signal:'recursive doesNotUnderstand' .
  ].
  ^self doesNotUnderstand: aSymbol args: anArray envId: aSmallInt

]

{ #category : 'Error Handling' }
Object >> _errIncorrectFormat: aStreamOrString [

""

^ self _error: #rtErrBadFormat args: { aStreamOrString }

]

{ #category : 'Indexing Support' }
Object >> _errorCouldNotCommitDuringIndexCreation [

"Raises an error because the receiver is currently in use building an index."

'Failed commit during index creation.'
  _error: #rtErrCommitProhibitingError

]

{ #category : 'Error Handling' }
Object >> _errorExpectedClass: aClass [

"Sends an error message indicating that receiver was not a kind of aClass"

self _error: #rtErrBadArgKind args: { aClass } .
self _uncontinuableError

]

{ #category : 'Indexing Support' }
Object >> _errorIndexCreationInProgress [

"Raises an error because the receiver is currently in use building an index."

'Operation could not be performed because index creation is in progress.'
  _error: #rtErrCommitProhibitingError

]

{ #category : 'Error Handling' }
Object >> _errorIndexOutOfRange: anIndex [

"Sends an error message indicating that anIndex was outside legal limits
 for the receiver."

^ self _error: #objErrBadOffsetIncomplete args: { anIndex }

]

{ #category : 'Error Handling' }
Object >> _errorInvalidOffset: ivName [

"The object does not have an instance variable with the given name."

^ self _error: #rtErrObjectInvalidOffset args: { ivName }

]

{ #category : 'Error Handling' }
Object >> _errorNoDependencyList [

"The object does not have a dependency list."

^ self _error: #rtErrObjectNoDependencyList

]

{ #category : 'Error Handling' }
Object >> _errorNoModification [

"Instances of invariant classes are immutable."

^ self _error: #objErrInvariant

]

{ #category : 'Error Handling' }
Object >> _errorNonIntegerIndex: anIndex [

"Sends an error message indicating that anIndex should have been an integer."

^ self _error: #rtErrBadSubscript args: { anIndex }

]

{ #category : 'Error Handling' }
Object >> _errorNotIndexable [

"Sends an error message indicating that the receiver is not indexable."

^ OffsetError new _number: 2012 ; reason:#objErrNotIndexable ;
    object: self ; details: 'object does not have varying instVars'; signal

]

{ #category : 'Error Handling' }
Object >> _errorPathTermNotInDependencyList: aPathTerm [

"An object did not have the path term in its dependency list."

^ self _error: #rtErrObjectPathTermNotInDependencyList args: { aPathTerm name }

]

{ #category : 'Private' }
Object >> _gciInitialize [
  "used by store traversal implementation"

  ^ false "illegal initialization for structural access,
           reimplementations in legal classes return true"

]

{ #category : 'Modification Tracking' }
Object >> _getDepListAndAddTracker: tracker withId: anInteger [
  "Add the given tracker to the receiver's dependency list."

  | depList depListClass dl |
  anInteger ~~ 0
    ifTrue: [
      self
        error:
          'DepList id for modification tracking must be 0 or else you risk index corruption: see bug 42640' ].
  depListClass := DependencyList.
  dl := depListClass for: self.
  dl == nil
    ifTrue: [
      depList := depListClass new: 2.
      depList _basicAt: 1 put: tracker.
      depList _basicAt: 2 put: anInteger ]
    ifFalse: [ depList := dl copyAndAddTracker: tracker withId: anInteger for: self ].
  depListClass set: (SharedDependencyLists at: depList logging: true) for: self

]

{ #category : 'Reduced Conflict Support' }
Object >> _getInternalNodes [
"PRIVATE. For large objects, return array of internal nodes."

<primitive: 639>
self _primitiveFailed: #_getInternalNodes .
self _uncontinuableError

]

{ #category : 'Encoded OOPs' }
Object >> _getOldOop [

"Return a SmallInteger which is the Gs64 v1.1 OOP for the object.
 Return nil if the object is not representable with a 4 byte OOP .
 Special objects will always return nil.
"
<primitive: 544 >
self _primitiveFailed: #_getOldOop

]

{ #category : 'Error Handling' }
Object >> _halt: messageString [

"Raises an error in response to a problem detected by kernel class methods.
 Intended for use to report seldom-occurring errors from kernel class
 methods.   The messageString arguments are not yet installed as individual
 messages in the language-dependent message dictionary."

^ InternalError new _number: 2023 ; details: messageString; signal

]

{ #category : 'Modification Tracking' }
Object >> _hasModificationTracking [

"Returns true if the receiver's dependency list has any tracking objects;
 returns false otherwise."

| result depList |
depList := DependencyList for: self.
depList == nil
  ifTrue: [ result := false ]
  ifFalse: [ result := depList includesIdentical: 0 ].
^ result

]

{ #category : 'Modification Tracking' }
Object >> _hasModificationTrackingTo: aTrackingObject [

"Returns true if the receiver's dependency list has any tracking objects;
 returns false otherwise."

| result depList |
depList := DependencyList for: self.
depList == nil
  ifTrue: [ result := false ]
  ifFalse: [ result := depList includesIdentical: aTrackingObject ].
^ result

]

{ #category : 'Indexing Support' }
Object >> _idxBasicCanCompareWithClass: aClass [
  "Returns true if the receiver may be inserted into a basic BtreeNode whose
   #lastElementClass is <aClass> (see RangeEqualityIndex class>>isBasicClass:)."

  ^ self isKindOfClass: aClass

]

{ #category : 'ObsoleteIDX - Indexing Support' }
Object >> _idxCompareEqualTo: arg [

self deprecated: 'Object>>_idxCompareEqualTo: should no longer be used.
Use the new double dispatching-based protocol in category "New Indexing Comparison".'.

^ self _idxForCompareEqualTo: arg

]

{ #category : 'ObsoleteIDX - Indexing Support' }
Object >> _idxCompareGreaterThan: arg [

self deprecated: 'Object>>_idxCompareGreaterThan: should no longer be used.
Use the new double dispatching-based protocol in category "New Indexing Comparison".'.

^ self _idxForCompareGreaterThan: arg

]

{ #category : 'ObsoleteIDX - Indexing Support' }
Object >> _idxCompareGreaterThanOrEqual: arg [

self deprecated: 'Object>>_idxCompareGreaterThanOrEqual: should no longer be used.
Use the new double dispatching-based protocol in category "New Indexing Comparison".'.

^ self _idxForCompareGreaterThanOrEqualTo: arg

]

{ #category : 'ObsoleteIDX - Indexing Support' }
Object >> _idxCompareLessThan: arg [

self deprecated: 'Object>>_idxCompareLessThan: should no longer be used.
Use the new double dispatching-based protocol in category "New Indexing Comparison".'.
^ self _idxForCompareLessThan: arg

]

{ #category : 'ObsoleteIDX - Indexing Support' }
Object >> _idxCompareLessThanOrEqual: arg [

self deprecated: 'Object>>_idxCompareLessThanOrEqual: should no longer be used.
Use the new double dispatching-based protocol in category "New Indexing Comparison".'.

^ self _idxForCompareLessThanOrEqualTo: arg

]

{ #category : 'ObsoleteIDX - Indexing Support' }
Object >> _idxCompareNotEqualTo: arg [

self deprecated: 'Object>>_idxCompareNotEqualTo: should no longer be used.
Use the new double dispatching-based protocol in category "New Indexing Comparison".'.

^ self _idxForCompareNotEqualTo: arg

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareBooleanGreaterThanOrEqualToSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForCompareGreaterThanOrEqualTo:. Note that aBoolean should be the receiver in any >= comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareBooleanGreaterThanSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForCompareGreaterThan:. Note that aBoolean should be the receiver in any > comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareBooleanLessThanOrEqualToSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForCompareLessThanOrEqualTo:. Note that aBoolean should be the receiver in any <= comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareBooleanLessThanSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForCompareLessThan:. Note that aBoolean should be the receiver in any < comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareCharacterCollectionGreaterThanOrEqualToSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:. Note that aCharacterCollection should be the receiver in any >= comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareCharacterCollectionGreaterThanSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:. Note that aCharacterCollection should be the receiver in any > comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareCharacterCollectionLessThanOrEqualToSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:. Note that aCharacterCollection should be the receiver in any <= comparison"

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareCharacterCollectionLessThanSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:. Note that aCharacterCollection should be the receiver in any < comparison"

^false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareEqualTo: arg [

""

^self _idxForSortEqualTo: arg

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareEqualToDoubleByteSymbol: aSymbol [
  "second half of a double dispatch call from DoubleByteSymbol>>_idxForCompareEqualTo:."

  ^ aSymbol == self

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareEqualToNumber: aNumber [

"second half of a double dispatch call from Number>>_idxForCompareEqualTo:."

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareEqualToQuadByteSymbol: aSymbol [
  "second half of a double dispatch call from QuadByteSymbol>>_idxForCompareEqualTo:."

  ^ aSymbol == self

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareEqualToSymbol: aSymbol [
  "second half of a double dispatch call from Symbol>>_idxForCompareEqualTo:."

  ^ aSymbol == self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareGreaterThan: arg [

""

^arg _idxForCompareObjectGreaterThanSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareGreaterThan: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareGreaterThanOrEqualTo: arg [

""

^arg _idxForCompareObjectGreaterThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareGreaterThanOrEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareLessThan: arg [

""

^arg _idxForCompareObjectLessThanSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareLessThan: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareLessThanOrEqualTo: arg [

""

^arg _idxForCompareObjectLessThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareLessThanOrEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareNotEqualTo: arg [

""

^ arg _idxForCompareNotEqualToObject: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareNotEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ (self _idxForCompareEqualTo: aCharacterCollection collator: anIcuCollator)
    not

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareNotEqualToObject: anObject [

"second half of a double dispatch call from Object>>_idxForCompareNotEqualTo:."

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject ~= self ].
^true

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareObjectGreaterThanOrEqualToSelf: anObject [

"second half of a double dispatch call from Object>>_idxForCompareGreaterThanOrEqualTo:. Note that anObject should be the receiver in any >= comparison"

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject >= self ].
^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareObjectGreaterThanSelf: anObject [

"second half of a double dispatch call from Object>>_idxForCompareGreaterThan:. Note that anObject should be the receiver in any > comparison"

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject > self ].
^false


]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareObjectLessThanOrEqualToSelf: anObject [

""

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject <= self ].
^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareObjectLessThanSelf: anObject [

""

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject < self ].
^false


]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareGreaterThanOrEqualTo:."

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareUndefinedObjectGreaterThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareGreaterThan:."

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareLessThanOrEqualTo:."

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareUndefinedObjectLessThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareLessThan:."

^false

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortBooleanGreaterThanOrEqualToSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForSortGreaterThanOrEqualTo:. Note that aBoolean should be the receiver in any >= comparison"

^aBoolean _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortBooleanGreaterThanSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForSortGreaterThan:. Note that aBoolean should be the receiver in any > comparison"

^aBoolean _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortBooleanLessThanOrEqualToSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForSortLessThanOrEqualTo:. Note that aBoolean should be the receiver in any <= comparison"

^aBoolean _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortBooleanLessThanSelf: aBoolean [

"second half of a double dispatch call from Boolean>>_idxForSortLessThan:. Note that aBoolean
should be the receiver in any < comparison"

^aBoolean _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortCharacterCollectionGreaterThanOrEqualToSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThanOrEqualTo:. Note that aCharacterCollection should be the receiver in any >= comparison"

^aCharacterCollection _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortCharacterCollectionGreaterThanSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThan:. Note that aCharacterCollection should be the receiver in any > comparison"

^aCharacterCollection _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortCharacterCollectionLessThanOrEqualToSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForSortLessThanOrEqualTo:. Note that aCharacterCollection should be the receiver in any <= comparison"

^aCharacterCollection _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortCharacterCollectionLessThanSelf: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForSortLessThan:. Note that aCharacterCollection should be the receiver in any < comparison"

^aCharacterCollection _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortEqualTo: arg [

""

^arg _idxForSortEqualToObject: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortEqualToCharacterCollection: aCharacterCollection [

 "second half of a double dispatch call from CharacterCollection>>_idxForSortEqualTo:."

^ false

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortEqualToNumber: aNumber [

"second half of a double dispatch call from Number>>_idxForSortEqualTo:."

^ false

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortEqualToObject: anObject [

"second half of a double dispatch call from Object>>_idxForSortEqualTo:."

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject = self ].
^false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortGreaterThan: arg [

""

^arg _idxForSortObjectGreaterThanSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortGreaterThan: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortGreaterThanOrEqualTo: arg [

""

^arg _idxForSortObjectGreaterThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortGreaterThanOrEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortLessThan: arg [

""

^arg _idxForSortObjectLessThanSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortLessThan: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortLessThanOrEqualTo: arg [

""

^arg _idxForSortObjectLessThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortLessThanOrEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortNotEqualTo: arg [

""

^arg _idxForSortNotEqualToObject: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortNotEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ (self _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator) not

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNotEqualToCharacterCollection: aCharacterCollection [

"second half of a double dispatch call from CharacterCollection>>_idxForSortNotEqualTo:."

^ true

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNotEqualToNumber: aNumber [

"second half of a double dispatch call from Number>>_idxForSortNotEqualTo:."

^ true

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNotEqualToObject: anObject [

"second half of a double dispatch call from Object>>_idxForSortNotEqualTo:."

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject ~= self ].
^true

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNumberGreaterThanOrEqualToSelf: aNumber [

"second half of a double dispatch call from Number>>_idxForSortGreaterThanOrEqualTo:. Note that aNumber should be the receiver in any >= comparison"

^aNumber _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNumberGreaterThanSelf: aNumber [

"second half of a double dispatch call from Number>>_idxForSortGreaterThan:. Note that aNumber should be the receiver in any > comparison"

^aNumber _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNumberLessThanOrEqualToSelf: aNumber [

"second half of a double dispatch call from Number>>_idxForSortLessThanOrEqualTo:. Note that aNumber should be the receiver in any <= comparison"

^aNumber _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortNumberLessThanSelf: aNumber [

"second half of a double dispatch call from Number>>_idxForSortLessThan:. Note that aNumber should be the receiver in any < comparison"

^aNumber _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortObjectGreaterThanOrEqualToSelf: anObject [

"second half of a double dispatch call from Object>>_idxForSortGreaterThanOrEqualTo:. Note that anObject should be the receiver in any >= comparison"

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject >= self ].
^anObject _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortObjectGreaterThanSelf: anObject [

"second half of a double dispatch call from Object>>_idxForSortGreaterThan:. Note that anObject should be the receiver in any > comparison"

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject > self ].
^anObject _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortObjectLessThanOrEqualToSelf: anObject [

"second half of a double dispatch call from Object>>_idxForSortLessThanOrEqualTo:. Note that anObject should be the receiver in any <= comparison"

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject <= self ].
^anObject _classSortsLessThan: self


]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortObjectLessThanSelf: anObject [

"second half of a double dispatch call from Object>>_idxForSortLessThan:. Note that anObject should be the receiver in any < comparison"

(self _classSortOrdinal = anObject _classSortOrdinal)
  ifTrue: [ ^anObject < self ].
^anObject _classSortsLessThan: self


]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortUndefinedObjectGreaterThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortGreaterThanOrEqualTo:. Note that anUndefinedObject should be the receiver in any >= comparison"

^anUndefinedObject _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortUndefinedObjectGreaterThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortGreaterThan:. Note that anUndefinedObject should be the receiver in any > comparison"

^anUndefinedObject _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortLessThanOrEqualTo:. Note that anUndefinedObject should be the receiver in any <= comparison"

^anUndefinedObject _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison - for Sort' }
Object >> _idxForSortUndefinedObjectLessThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortLessThan:. Note that anUndefinedObject should be the receiver in any < comparison"

^anUndefinedObject _classSortsLessThan: self

]

{ #category : 'Indexing Support' }
Object >> _idxGreaterThanAndLessThanValues: valueArray [

"This comparison operation is by the indexing subsystem to determine if the
 receiver is within the given range of values.  The 'valueArray' argument is a
 four-element Array consisting of { val1. bool1. val2. bool2 } .  val1 is the
 lower bound value and bool1 specifies whether equal values are allowed.  val2
 is the upper value and bool2 specifies whether equal values are allowed.
 Returns true if the receiver satisfies the criteria."

(valueArray at: 2)
    ifTrue: [
        (self _idxForCompareGreaterThanOrEqualTo: (valueArray at: 1))
            ifTrue: [
                (valueArray at: 4)
                    ifTrue: [ ^ self _idxForCompareLessThanOrEqualTo: (valueArray at: 3) ]
                    ifFalse: [ ^ self _idxForCompareLessThan: (valueArray at: 3) ]
            ]
            ifFalse: [ ^ false ]
    ]
    ifFalse: [
          (self _idxForCompareGreaterThan: (valueArray at: 1))
            ifTrue: [
                (valueArray at: 4)
                    ifTrue: [ ^ self _idxForCompareLessThanOrEqualTo: (valueArray at: 3) ]
                    ifFalse: [ ^ self _idxForCompareLessThan: (valueArray at: 3) ]
            ]
            ifFalse: [ ^ false ]
    ]

]

{ #category : 'Dynamic Smalltalk Instance Variables' }
Object >> _instvarNamesAfter: privateSize [
"Returns an Array of Symbols which are names of the
 fixed and dynamic instVars of the receiver excluding
 the first privateSize named instVars.  Naming conventions for
 the instance variables are responsibility of the method compiler and other
 runtime support.  A dynamic instVar whose value is remoteNil will be
 excluded from the result."

<primitive: 770>
privateSize _validateClass: SmallInteger .
self _primitiveFailed: #_instvarNamesAfter:  "possible corrupt dynIvs"
     args: { privateSize }

]

{ #category : 'Private' }
Object >> _intRecur: selectorSymbol args: anArray [
  "For VM testing only.
   Invoke  self perform: selectorSymbol withArguments: anArray via IntRecurFromOm"
  <primitive: 253>
  anArray _validateClass: Array .
  anArray size > 100 ifTrue:[ OutOfRange new name:'array size' max: 100 actual: anArray size ; signal].
  self _primitiveFailed: #_intRecur:args: args: { selectorSymbol . anArray }
]

{ #category : 'Class Membership' }
Object >> _isArray [
"(Optimized selector.)  Returns true if the receiver is an instance of
 Array or a subclass thereof, returns false otherwise."

^ self _isArray

]

{ #category : 'Class Membership' }
Object >> _isExceptionClass [

"(Optimized selector.)  Returns true if the receiver is a subclass of
 Exception , returns false otherwise."

^ self _isExceptionClass

]

{ #category : 'Class Membership' }
Object >> _isExecBlock [
"(Optimized selector.)  Returns true if the receiver is an instance of
 ExecBlock or a subclass thereof, returns false otherwise."

^ self _isExecBlock

]

{ #category : 'Class Membership' }
Object >> _isFloat [

"(Optimized selector.)  Returns true if the receiver is an
  instance of Float or SmallDouble. Returns false otherwise.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self _isFloat

]

{ #category : 'Testing' }
Object >> _isIndexObject [

"Returns true if the receiver is an index object; returns false otherwise."

^ false

]

{ #category : 'Class Membership' }
Object >> _isInteger [

"(Optimized selector.)  Returns true if the receiver is a kind of
 Integer. Returns false otherwise.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self _isInteger

]

{ #category : 'Testing' }
Object >> _isLarge [

"Returns true if the object is implemented as a tree of private smaller objects"

^ ( (self _status: false) bitShift: -8) ~~ 0

]

{ #category : 'Class Membership' }
Object >> _isNumber [

"(Optimized selector.)  Returns true if the receiver is a kind of
 Number. Returns false otherwise.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self _isNumber

]

{ #category : 'Testing' }
Object >> _isObsoletePathTerm [

"Returns true if the receiver is an obsolete path term; returns false
 otherwise."

^ false

]

{ #category : 'Class Membership' }
Object >> _isOneByteString [
"(Optimized selector.)  Returns true if the receiver is an instance of
 String or a subclass thereof, returns false otherwise."

^ self _isOneByteString

]

{ #category : 'Class Membership' }
Object >> _isRange [
"(Optimized selector.)  Returns true if the receiver is an instance of
 Range or a subclass thereof, returns false otherwise."

^ self _isRange

]

{ #category : 'Testing' }
Object >> _isRcIdentityBag [

"Returns true if the receiver is an RcIdentityBag; returns false otherwise."

^ false

]

{ #category : 'Class Membership' }
Object >> _isScaledDecimal [

"(Optimized selector.)  Returns true if the receiver is a kind of
 ScaledDecimal. Returns false otherwise.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self _isScaledDecimal

]

{ #category : 'Class Membership' }
Object >> _isSmallInteger [

"(Optimized selector.)  Returns true if the receiver is an instance of
 SmallInteger. Returns false otherwise.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self _isSmallInteger

]

{ #category : 'Class Membership' }
Object >> _isSymbol [

"(Optimized selector.)  Returns true if the receiver is an instance of
 Symbol, DoubleByteSymbol or QuadByteSymbol. Returns false otherwise.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self _isSymbol

]

{ #category : 'Testing' }
Object >> _levels [

"If the object is implemented as a tree of private smaller objects, returns
 the depth of the tree not including the leaf nodes, otherwise returns 0.

 The result will be a SmallInteger in the range 0..3  inclusive."

^ ((self _status: false) bitShift: -8)

]

{ #category : 'Locking Support' }
Object >> _lockableValues [

"Returns a kind of object usable as an argument to _lockAll: primitives."

^ self

]

{ #category : 'Adding' }
Object >> _nextPut: anObject [
"see PrintStream>>_nextPut:"

^ self nextPut: anObject

]

{ #category : 'Private' }
Object >> _objectSecurityPolicy: anObjectSecurityPolicy [

"Reassigns the receiver to anObjectSecurityPolicy.
 If the receiver's current security policy and anObjectSecurityPolicy are the same,
 this method has no effect, otherwise all of the following apply:

 Generates an error if the user is not authorized to write to both
 the receiver's current security policy and anObjectSecurityPolicy,
 or if the receiver is a special object (SmallInteger, Character,
 Boolean, SmallDouble, or UndefinedObject),
 or if anObjectSecurityPolicy is not a committed object.

 anObjectSecurityPolicy may be nil, in which case the object is given World write
 permission (objectSecurityPolicyId 0).  "

<protected primitive: 594>

(self isSpecial or:[ self isSymbol]) ifTrue:[
   self _error: #segErrCantMoveObj
].
anObjectSecurityPolicy _validateClass: GsObjectSecurityPolicy.

self _primitiveFailed: #_objectSecurityPolicy:
     args: { anObjectSecurityPolicy } .
self _uncontinuableError

]

{ #category : 'Testing' }
Object >> _onStackAsSelfBelow: startLevel [

"Returns true if the receiver exists as self anywhere on the current
 GemStone Smalltalk stack above specified Activation; returns false otherwise.

 startLevel is the Activation on the stack at which to begin searching
 downwards.  1 means top of stack, which will be the Activation of
 the sender of  _onStackAsSelfBelow: .  (Since _onStackAsSelfBelow: is
 a primitive, it has no Activation).

 startLevel < 1 is interpreted as  startLevel == 1.

 See Object|become: for a typical use of this method."

<primitive: 288>
startLevel _validateClass: SmallInteger.
self _primitiveFailed: #_onStackAsSelfBelow: args: { startLevel } .
^ false

]

{ #category : 'Message Handling' }
Object >> _perform: aSelectorSymbol env: environmentId withArguments: anArray [

"Sends the receiver the message indicated by the arguments.
 The argument, aSelectorSymbol, is the keyword selector of the message.
 The arguments of the message are the elements of anArray.  Generates an
 error if the number of arguments expected by aSelectorSymbol is not
 the same as the number of elements in anArray.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment."


<primitive: 2015> "fail if selector not found, or wrong number of arguments"

aSelectorSymbol _isSymbol ifFalse:[ aSelectorSymbol _validateClass: Symbol].
anArray _isArray ifFalse:[ anArray _validateInstanceOf: Array].

"now implement the failure so that forwarders can reimplement the
 failure method and send self doesNotUnderstand: ."

^ self cantPerform: aSelectorSymbol withArguments: anArray env: environmentId

]

{ #category : 'Message Handling' }
Object >> _performNoDebug: aSelectorSymbol env: environmentId [

"Send the receiver the message indicated by the arguments.  The GemStone
 Smalltalk debugger, GemStone Smalltalk breakpoints, soft breaks, and hard
 breaks are all disabled during evaluation of this send.

 If an error occurs during this send, then this session is
 not allowed to commit.  This behavior may be used to ensure consistency
 of indexes, hash dictionaries, etc.

 zero to 10 `with:' keywords are supported by the primitive.
 International selectors are not supported by this method."

<primitive: 305>

aSelectorSymbol _validateClass: String.
self _error: #rtErrCantPerform args: { aSelectorSymbol } .
^ self _primitiveFailed: #_performNoDebug:env:
       args: { aSelectorSymbol . environmentId }

]

{ #category : 'Message Handling' }
Object >> _performNoDebug: aSelectorSymbol env: environmentId with: anArg [

"Send the receiver the message indicated by the arguments.  The GemStone
 Smalltalk debugger, GemStone Smalltalk breakpoints, soft breaks, and hard
 breaks are all disabled during evaluation of this send.

 If an error occurs during this send, then this session is
 not allowed to commit.  This behavior may be used to ensure consistency
 of indexes, hash dictionaries, etc.

 zero to 10 `with:' keywords are supported by the primitive.
 International selectors are not supported by this method."

<primitive: 305>

aSelectorSymbol _validateClass: String.
self _error: #rtErrCantPerform args: { aSelectorSymbol } .
^ self _primitiveFailed: #_performNoDebug:env:with:
       args: { aSelectorSymbol . environmentId . anArg }

]

{ #category : 'Message Handling' }
Object >> _performNoDebug: aSelectorSymbol env: environmentId with: anArg1 with: anArg2 [

"Send the receiver the message indicated by the arguments.  The GemStone
 Smalltalk debugger, GemStone Smalltalk breakpoints, soft breaks, and hard
 breaks are all disabled during evaluation of this send.

 If an error occurs during this send, then this session is
 not allowed to commit.  This behavior may be used to ensure consistency
 of indexes, hash dictionaries, etc.

 zero to 10 `with:' keywords are supported by the primitive.
 International selectors are not supported by this method."

<primitive: 305>

aSelectorSymbol _validateClass: String.
self _error: #rtErrCantPerform args: { aSelectorSymbol } .
^ self _primitiveFailed: #_performNoDebug:env:with:with:
       args: { aSelectorSymbol . environmentId . anArg1 . anArg2 }

]

{ #category : 'Message Handling' }
Object >> _performNoDebug: aSelectorSymbol env: environmentId with: anArg1 with: anArg2 with: anArg3 [

"Sends the receiver the message indicated by the arguments.  The GemStone
 Smalltalk debugger, GemStone Smalltalk breakpoints, soft breaks, and hard
 breaks are all disabled during evaluation of this send.

 If an error occurs during this send, then this session is not allowed to
 commit.  This behavior may be used to ensure consistency of indexes and hash
 dictionaries.

 zero to 10 `with:' keywords are supported by the primitive.
 International selectors are not supported by this method."

<primitive: 305>

aSelectorSymbol _validateClass: String.
self _error: #rtErrCantPerform args: { aSelectorSymbol } .
^ self _primitiveFailed: #_performNoDebug:env:with:with:with:
       args: { aSelectorSymbol . environmentId . anArg1 . anArg2 . anArg3 }

]

{ #category : 'Accessing' }
Object >> _primitiveAt: anIndex [

"Signals an error if the if anIndex is less than 1 or greater than
 the sum of named plus indexed instance variables of the receiver.

 Equivalent to GciFetchOop(self, anIndex) if receiver is a pointer object or
 NSC object.  Equivalent to GciFetchByte(self, anIndex) if receiver is a byte
 object, in which case it returns the small integer value of the byte."

<primitive: 89>

(anIndex _isInteger)
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #_primitiveAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> _primitiveAt: anIndex put: aValue [

"Signals an error if anIndex is less than 1 or greater than the sum
 of 1 plus the number of named plus the number of indexed instance
 variables of the receiver.

 Equivalent to GciStoreOop(self, anIndex, aValue) if receiver is a pointer
 object.  Equivalent to GciStoreByte(self, anIndex, aValue) if receiver is a
 byte object.

 Disallowed in Bag."

<primitive: 281>
| limit |
(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
limit := self _primitiveSize .
self class isIndexable ifTrue:[ limit := limit + 1 ].
( anIndex < 1 or:[ anIndex > limit])
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(self class isBytes)
ifTrue:
  [ ((aValue class ~~ SmallInteger) or: [ (aValue < 0) | (aValue > 255) ])
    ifTrue: [^ aValue _error: #rtErrExpectedByteValue].
  ].

self _primitiveFailed: #_primitiveAt:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Accessing' }
Object >> _primitiveAtNoFault: anIndex otherwise: defaultValue [

"Equivalent to _primitiveAt: except that most object faults from the page cache
 into VM object memory are avoided.

 If receiver is a pointer object and the instVar value is a committed object,
 this method usually returns defaultValue thus avoiding most object faults.
 If instVar value was recently committed by this session, a non-default value
 will be returned if that reference has not yet been stubbed by in-memory GC.
 If instVar value is a committed object in memory but needs to be refreshed due to
 crossing a transaction boundary an object fault may be performed and
 a non-default value returned.

 If receiver is a byte object, it always returns the small
 integer value of the specified byte."

<primitive: 998>
(anIndex _isInteger)
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #_primitiveAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Private' }
Object >> _primitiveBecome: anObject forDict: isDictBool [

"This method should only be invoked by Object/become: , or
 from a method such that neither receiver nor anObject are on stack as self.

 Returns anObject.

 This primitive will signal an error if either receiver or anObject are
   a special object,
   or a kind of one of:
     ExecBlock, Symbol, Behavior, GsNMethod,   SymbolList,
     GsSocket, Regexp, GsCompilerIRNode, CBuffer, CByteArray,
     CFunction, CLibrary, CPointer, CZstream
   or is AllSymbols and session not logged in as SystemUser ,
   or participates in an index.

 If isDictBool == false will signal an error if either receiver or anObject are a
   GsMethodDictionary or  SymbolDictionary .

 If either receiver or anObject is a GsFile with isClient==true,
  signals an error .
 If either receiver or anObject is a RubySocket being polled by the
 ProcessorScheduler, signals an error .
 If receiver or anObject is one of GsFile or RubySocket, then
 anObject must also be a GsFile or RubySocket.

 Primitive fails if one of receiver or anObject are DbTransient
 and the other is not.
"
<protected primitive: 277>
| myCls argCls |
Object _checkKindForBecome: self .
Object _checkKindForBecome: anObject .
(myCls := self class) _instancesNpDbtransient ==
 (argCls := anObject class) _instancesNpDbtransient ifFalse:[
    myCls instancesNonPersistent == argCls instancesNonPersistent ifFalse:[
      self _error: #rtErrCantBecomeGeneric args: {
         'classes of objects differ with respect to instancesNonPersistent' }.
    ].
    myCls instancesDbTransient == argCls instancesDbTransient ifFalse:[
      self _error: #rtErrCantBecomeGeneric args: {
         'classes of objects differ with respect to instancesDbTransient' }.
    ].
].
self _hasDependencyList ifTrue:[
  self _error: #rtErrCantBecomeGeneric args: { 'participates in an index' }.
].
anObject _hasDependencyList ifTrue:[
  anObject _error: #rtErrCantBecomeGeneric args: { 'participates in an index' }.
].
self _primitiveFailed: #_primitiveBecome:forDict:
     args: { anObject . isDictBool } .
self _uncontinuableError

]

{ #category : 'Error Handling' }
Object >> _primitiveFailed: aSelector [

"Methods which are implemented as primitives send _primitiveFailed:
 when a primitive fails and the failure is not attributable to any
 normal error such as bad argument kind, argument out of range, etc."

^ self _primitiveFailed: aSelector args: { }

]

{ #category : 'Error Handling' }
Object >> _primitiveFailed: aSelector args: primArgs [

"Methods which are implemented as primitives send _primitiveFailed:
 when a primitive fails and the failure is not attributable to any
 normal error such as bad argument kind, argument out of range, etc."

| args |
args := { self . aSelector } .
args add: primArgs.
^ ArgumentError new _number: 2258"#rtErrPrimFailed" ; args: args ; signal

]

{ #category : 'Accessing' }
Object >> _primitiveSize [

"Returns the number of named instance variables plus the number of
 indexed instance variables in the receiver.
 Equivalent to GciFetchSize(self)."

<primitive: 88>

self _primitiveFailed: #_primitiveSize .
self _uncontinuableError

]

{ #category : 'Reduced Conflict Support' }
Object >> _rcAt: anIndex [

"Returns the object at the given index (same as _at:, _basicAt:,
 and at:).  If the receiver is not a large object, places the receiver
 in the rcReadSet.  If the receiver is a large object or NSC, places
 the root object and any large object nodes that are accessed in the
 rcReadSet.  Does not place the value that it returns in the rcReadSet."

<primitive: 92>
(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
(anIndex _isInteger)
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #_rcAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Reduced Conflict Support' }
Object >> _refreshAfterCommitFailure [

"Returns whether the receiver should be selectively aborted when there is a
 failed attempt to commit.  Only special Reduced Objects should answer true."

^ false

]

{ #category : 'Private' }
Object >> _resetParentRef [

"Private. After a become:, child objects may need to be adjusted
 to point to the new parent.  Reimplemented in some dictionary classes."

^ self

]

{ #category : 'Reduced Conflict Support' }
Object >> _resolveRcConflictsWith: conflictObjects [

"A logical write-write conflict has occurred on the receiver.  The objects that
 had the actual physical write-write conflicts are in the conflictObjects
 Array.  Selectively abort the receiver and then attempt to replay the
 operations maintained in the System redo log.  Returns true if all the
 operations could be replayed; otherwise returns false."

^ self _abortAndReplay: conflictObjects

]

{ #category : 'Testing' }
Object >> _respondsTo: aSymbol flags: flags [

"Returns true if receiver understands specified selector, false otherwise.
 flags is a Smallinteger with bit masks
    environmentId                  16rFF
    cache successes in code_gen 16r10000
    all other bits ignored
"
<primitive: 688>
aSymbol _isSymbol ifFalse:[
  ArgumentError signal:'argument to responds_to is not a Symbol'
].
self _primitiveFailed:#_respondsTo:flags:
     args: { aSymbol . flags }

]

{ #category : 'Reduced Conflict Support' }
Object >> _selectiveAbort [

"Performs an abort operation on the receiver. That is, if the object is
 committed, it removes any changes made by the current transaction and allows
 access to the committed state of the object.  Has no effect on objects
 that have not been committed in an outer level transaction .
 Signals an Error if within a nested transaction and the operation would change
 the state of the receiver.
 Has no effect if receiver is a special object.

 The error #rtErrSelectiveAbort is thrown if the receiver has depMap entries."

 <primitive: 274>

 self _primitiveFailed: #_selectiveAbort .
 self _uncontinuableError
]

{ #category : 'Modification Tracking' }
Object >> _setModificationTrackingTo: tracker [

"Adds the given tracker to the dependency list of the receiver."

self isSpecial
  ifFalse: [
    self _getDepListAndAddTracker:tracker withId: 0
  ].

]

{ #category : 'Private' }
Object >> _setNoStubbing [

"While the object is in-memory, prevent stubbing of references from
 the receiver to in-memory committed objects.

 Has no effect if receiver is special , or is byte format.
 Otherwise the receiver must be a small object or an error is generated.
 Returns the receiver."

<primitive: 521>

self _primitiveFailed: #_setNoStubbing

]

{ #category : 'Testing' }
Object >> _status: checkClosureBool [

"Returns a SmallInteger with status information about the receiver
 encoded in the bit whose masks are defined below:

 16r01 isSpecial
     Set if the receiver is a Character, Boolean,
     SmallInteger, or nil.
 16r02 isCommitted
     Set if the receiver existed in GemStone at the time the current
     transaction began.
     if checkClosureBool is true, and session's most recent commit
     failed and is not yet aborted, check the closureList to determine actual
     committed state of temporary objects in the closure of the commit.
 16r04 isConnected  (obsolete bit, always 0)
 16r08 isWritten
     Set if the receiver has been written since the last
     commit, abort, or begin transaction command was executed.
 16r10 isWritable
     Set if the receiver canBeWritten by the current user.
 16r20 isTranlogged - true isCommitted and tranlogged, or
     not committed and beTranlogged has been sent .
 16r40 beTranlogged has been sent to the object while in-memory.

 16r700 levels  ( > 0 means a 'large object' implemented as a tree of
		smaller objects which are not visible to Smalltalk)"

<primitive: 39>
self _primitiveFailed: #_status: args: { checkClosureBool } .
self _uncontinuableError

]

{ #category : 'Class Membership' }
Object >> _stringCharSize [
"Optimized selector with following semantics.
  | result |
  result := 0  .
  (receiver's class is subclass of String or ByteArray) ifTrue:[ result := 1].
  ( receiver's class is subclass of   DoubleByteString) ifTrue:[ result := 2 ].
  (receiver's class is subclass of   QuadByteString) ifTrue:[ result := 4 ].
  ( receiver is a kind of Unicode7, Unicode16, or Unicode32 ) ifTrue:[
       result  := result bitOr: 16r8
  ].
  ^ result
"
^ self _stringCharSize

]

{ #category : 'Deprecated' }
Object >> _tagAt: tagNum [

"Deprecated in Gs64 v3.0, use dynamicInstVarAt: instead.

 Returns the receiver's value for the specified tagNum (1 or 2).
 Returns nil if the specified tag has never been stored into. "

self deprecated: 'Object>>_tagAt: deprecated v3.0, use #dynamicInstVarAt:'.
^self _tagAtPrim: tagNum.

]

{ #category : 'Deprecated' }
Object >> _tagAt: tagNum put: tagValue [

"Sets the specified tag word to the specified value .
 Deprecated in Gs64 v3.0:
   Use dynamicInstVarAt:put: instead.
   tagNum may be from   1   to   self tagSize + 1 .
   tagSize + 1 will cause auto grow .
   Number of tags is limited to 512, (2034 - number of named instVars)
   whichever is less.

 new in Gemstone64:
   Tags may not be stored into kind of Behavior
   (i.e.  tags on Classes and  metaclasses are not supported).
   Tags may not be stored into instances of GsMethod or ExecBlock.
 new in Gemstone64 v3.0:
   If you want the old semantics of Object>>copy not copying tags,
   you must use Object>>_basicCopyWithoutTags .

 Tags may not be stored into special objects.
 Generates an error if the receiver does not support tags.
"

self deprecated: 'Object>>_tagAt:put: deprecated v3.0, use #dynamicInstVarAt:put:'.
^self _tagAtPrim: tagNum put: tagValue.

]

{ #category : 'Deprecated' }
Object >> _tagAtPrim: tagNum [

<primitive: 87>
tagNum _isSmallInteger ifFalse:[ ^ tagNum _validateClass: SmallInteger ]
   ifTrue:[ ^ OutOfRange new name:'tagNum' min: 1 max: (2 max: self tagSize) actual: tagNum ;
     _number: 2055; signal] .
^ self _primitiveFailed: #_tagAt: args: { tagNum } .

]

{ #category : 'Deprecated' }
Object >> _tagAtPrim: tagNum put: tagValue [

<primitive: 280>
self isSpecial ifTrue:[
  ImproperOperation new _number: 2054 ; signal:'tag not allowed on special object'
].
tagNum _isSmallInteger ifFalse:[ tagNum _validateClass: SmallInteger ]
   ifTrue:[ ^ OutOfRange new name:'tagNum' min: 1 max: 3 actual: tagNum ; signal ].
^ self _primitiveFailed: #_tagAt:put: args: { tagNum . tagValue } .

]

{ #category : 'Formatting' }
Object >> _topazAsString [
  "Used by topaz for printing of results of executions and printing frame contents"
  ^ [ self asString
    ] onSynchronous: AbstractException do:[:ex |
        '<error during asString>'
    ]

]

{ #category : 'Message Handling' }
Object >> _topazPerform: selStr withArgs: argsArray env: envId [
  "used by topaz SENDENV command."
  | selSym |
  (selSym := Symbol _existingWithAll: selStr ) ifNil:[
     ArgumentError signal:'selector is not an existing Symbol'
  ].
  ^ self perform: selSym env: envId withArguments: argsArray

]

{ #category : 'Error Handling' }
Object >> _uncontinuableError [

"An attempt was made to continue execution past an uncontinuable error."

[true] whileTrue:[ self _error: #rtErrUncontinuable args: { } ]

]

{ #category : 'Private' }
Object >> _unsafeAt: anIndex [
"Low level access to an object, node of a large object , or node of
 an IdentityBag
 Named instance variables are accessed by this method, so 
 unnamed instance variables begin at (self class instSize + 1).

 Returns specified instVar of the object.  If object is byte format,
 returns SmallInteger value of the specified byte.
 If anIndex is < 1 , the primtive fails.
 If anIndex is beyond the end of the object, returns OOP_REMOTE_NIL
 Used in topaz implementation of DUMPOBJ ."

 <primitive: 168>
 (anIndex _isInteger)
   ifFalse: [ self _errorNonIntegerIndex: anIndex .  self _uncontinuableError ].
 self _primitiveFailed: #_unsafeAt: args: { anIndex } .
 self _uncontinuableError
]

{ #category : 'Instance Migration' }
Object >> _unsafeAt: anIndex put: aValue [

"Updates the receiver at the given index.  This is to be
 used for upgrading GemStone releases and for schema migration only.  Named
 instance variables are considered to be indexed by this method, so an
 unnamed part would begin at (self class instSize + 1).

 If anIndex is less than 1 or greater than 1 plus the total number of
 instance variables in the receiver, an error is generated.

 If the receiver is a kind of Bag, then only named instance variables may be
 modified by this method.  Take care not to corrupt the private named instance
 variables defined in class Bag.

 If the receiver is a byte format object, aValue must be a SmallInteger 
 in the range 0..255, which will be stored into the byte specified by anIndex .

 This method does not check invariance.  However, Indexes are updated
 if some index is dependent upon the instance variable that is modified."

<primitive: 273>

(anIndex _isInteger)
  ifFalse: [ self _errorNonIntegerIndex: anIndex .  self _uncontinuableError ].
(self class isBytes)
ifTrue:
  [ ((aValue class ~~ SmallInteger) or: [ (aValue < 0) | (aValue > 255) ])
    ifTrue: [ ^ aValue _error: #rtErrExpectedByteValue].
  ] .
self _primitiveFailed: #_unsafeAt:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Class Membership' }
Object >> _validateByteClass: aClass [

"Returns true if self is a kind of aClass and also has byte format.
 Otherwise generates an error."

(self isKindOf: aClass) ifFalse:[
  self _errorExpectedClass: aClass  .
  ^ false
].
self class isBytes ifFalse:[
  self _error: #objErrNotByteKind .
  ^ false
].
^ true

]

{ #category : 'Testing' }
Object >> _validateCharSizeIs: anInt [

^ self charSize == anInt
     ifTrue:[ true ]
    ifFalse:[ ArgumentError signal: ('Expected an object with char size ',
               anInt asString, ' rather than ', self charSize asString)]

]

{ #category : 'Class Membership' }
Object >> _validateClass: aClass [

"Returns true if self is a kind of aClass.  Otherwise, generates an error."

(self isKindOf: aClass) ifTrue: [ ^ true ].
self _errorExpectedClass: aClass .

]

{ #category : 'Class Membership' }
Object >> _validateClasses: anArray [

"Returns true if self is a kind of a class in anArray.  Otherwise, generates an
 error."

1 to: anArray size do: [:i |
   (self isKindOf: (anArray at: i)) ifTrue:[ ^ true ]
].
self _error: #rtErrInvalidArgClass args: { anArray } .
^ false

]

{ #category : 'Class Membership' }
Object >> _validateInstanceOf: aClass [

"Returns true if self is instance of aClass.  Otherwise, generates an error."

(self class == aClass) ifFalse:[
   self _errorExpectedClass: aClass .
   ^ false
].
^ true

]

{ #category : 'Class Membership' }
Object >> _validateIsBytes [

"Returns true if self has byte format.
 Otherwise generates an error."

self class isBytes ifFalse:[
  self _error: #objErrNotByteKind .
  ^ false
].
^ true

]

{ #category : 'Testing' }
Object >> _validateIsClass [

"Generates an error if the receiver is not a kind of Behavior, with
 error message specific to class modification attempt."

(self isKindOf: Behavior ) ifTrue:[ ^ true ] .
self _error: #rtErrConstrNotAClass .
^ false

]

{ #category : 'Class Membership' }
Object >> _validateKindOfClass: aClass [

"Returns true if self is a kind of aClass, ignoring the classHistory
 of aClass.  Otherwise, generates an error."

(self isKindOfClass: aClass) ifTrue: [ ^ true ].
self _errorExpectedClass: aClass .

]

{ #category : 'Class Membership' }
Object >> _validateKindOfClasses: anArray [

"Returns true if self is a kind of any class in anArray, ignoring the classHistory
 of the class.  Otherwise, generates an error."

anArray detect:[:eachClass| self isKindOfClass: eachClass]
  ifNone:[self _errorExpectedClass: anArray first ].

^ true

]

{ #category : 'Queries' }
Object >> _validateRcConflictsWith: conflictObjects [

"The default validation for Rc conflicts is to return true.
 This satisfies the cases of changes to the root object"

^ true

]

{ #category : 'Converting' }
Object >> -> anObject [

"Returns an Association with the receiver as the key and the given object as
 the value."

^Association newWithKey: self value: anObject

]

{ #category : 'Comparing' }
Object >> = anObject [

"Returns true if the receiver and the argument have the same value.
 This method is defined here for identity, and is commonly
 reimplemented in a subclass to check for equality.

 Ordinarily, a class which reimplements the = method should also
 reimplement hash."

^self == anObject "default is identity check, unless overridden to"
                  "check for equality"

]

{ #category : 'Comparing' }
Object >> == anObject [

"(Optimized selector.)  Returns true if the receiver and the argument are the
 same object.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform will work."

^ self == anObject

]

{ #category : 'Comparing' }
Object >> ~= anObject [

"Returns true if the receiver and the argument do not have the same
 value."

^ (self = anObject) == false

]

{ #category : 'Comparing' }
Object >> ~~ anObject [

"(Optimized selector.)  Returns true if the receiver and the argument are not
 the same object.

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass. This implementation is so that perform will work."

^ self ~~ anObject

]

{ #category : 'Enumerating' }
Object >> accompaniedBy: anObj do: aBlock [

"Evaluate the two argument block aBlock with anObj and each element of
  the receiver.  Return the receiver. "

self do:[ :elem | aBlock value: anObj value: elem ]

]

{ #category : 'Converting' }
Object >> asCanonicalForm [
	"If I am not in my preferred form, answer the equivalent canonical (preferred) form.
	Otherwise, answer self.
	The canonical form is usually more efficient. See subclass overrides of this message
	for specific examples.

	This can be used to convert byte or pointer objects created in an older GemStone version
	to their immediate forms, improving space and time performance.

	Typical usage pattern:

	| val newVal |
	val := anObj anInstVarAccessor .
	(newVal := val asSpecial) ~~ val ifTrue: [ anObj anInstVarSetter: newVal ].

	while iterating over relevant objects in the application .
	and commit periodically to avoid OutOfMemory."

	^ self
]

{ #category : 'Deprecated' }
Object >> asciiLessThan: anObject [

"Deprecated. For objects that are not Characters or CharacterCollections, returns
 the result of an ordinary less-than compare.  This method is reimplemented in
 Character, String and MultiByteString to provide comparison based on the ASCII
 collating order."

self deprecated: 'Object>>asciiLessThan: deprecated in 3.2.'.
^ self < anObject

]

{ #category : 'Converting' }
Object >> asOop [

"Returns the value of the receiver's object-oriented pointer (OOP) as a
 positive Integer .  This is the receiver's unique identifier that
 distinguishes it from all other objects.  For non-special objects
 and for instances of 
   Boolean Character SmallDate SmallDateAndTime 
   SmallFraction SmallScaledDecimal SmallTime UndefinedObject
 the result will always be a SmallInteger.  For instances of SmallInteger
 and SmallDouble the result may be a LargeInteger.

 The result is different from the result obtained in Gemstone64 v1.x"

<primitive: 86>
self _primitiveFailed: #asOop

]

{ #category : 'Encoded OOPs' }
Object >> asOopNumber [

"If the receiver is a non-special object, return the receiver's
 oopNumber as defined under OOP_TAG_POM_OOP in the file
 $GEMSTONE/include/gcioop.ht  , otherwise return nil . "

| oop |
oop := self asOop .
oop _isSmallInteger ifFalse:[ ^ nil ].
(oop bitAnd:7) == 1 ifFalse:[ ^ nil ].
^ oop bitShift: -8

]

{ #category : 'Updating' }
Object >> assignToObjectSecurityPolicyId: anObjectSecurityPolicyId [

"Assign the receiver to objectSecurityPolicy specified by anObjectSecurityPolicyId which should
 be a SmallInteger >= 0.  Does not affect components of the receiver. "

| seg |
anObjectSecurityPolicyId > 0 ifTrue:[ seg := SystemRepository at: anObjectSecurityPolicyId ]
	       ifFalse:[ "assign to nil , world Write" ].
^ self objectSecurityPolicy: seg .

]

{ #category : 'Deprecated' }
Object >> assignToSegment: anObjectSecurityPolicy [

self deprecated: 'Object>>assignToSegment: deprecated v3.0. Use #objectSecurityPolicy: instead.'.
^ self objectSecurityPolicy: anObjectSecurityPolicy

]

{ #category : 'Formatting' }
Object >> asString [

"Returns a String that indicates the class of the receiver; for
 example, if the receiver is an instance of class Monkey, it returns
 a String of the form 'aMonkey'.  This method is often
 overridden in subclasses to provide behavior tailored to the class.

 The result should not contain any formatting information.
 For example the following expression should evaluate to true:

   #abc asString = String withAll: 'abc'

 This method is used by Object | describe.  Thus GemStone error
 handling and Topaz are dependent upon this method being functional.

 Must conform to rules for reimplementation of Object | describe."

^ self class name describeClassName .

]

{ #category : 'Formatting' }
Object >> asUnicodeString [

^ Unicode7 withAll: self asString

]

{ #category : 'Accessing' }
Object >> at: anIndex [

"Returns the value of an indexed variable in the receiver.
 The argument anIndex must not be larger than the size of the
 receiver, and must not be less than 1.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds, or if the receiver is not indexable."

<primitive: 32>

(self class isIndexable) "not an indexable object"
  ifFalse: [^ self _errorNotIndexable].
(anIndex _isInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> at: anIndex put: aValue [

"Stores the argument aValue in the indexed variable of the
 receiver indicated by anIndex.  The argument anIndex must not be
 larger than 1 + the size of the receiver, and must not be less than 1.

 Returns aValue.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds, if the receiver is not indexable, or if the
 receiver is not of the right class to store the given value.

 The primitive is equivalent to GciStoreIdxOop or GciStoreByte,
 depending on implementation of the receiver."

<primitive: 268>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(self class isBytes)
ifTrue: [ ((aValue class ~~ SmallInteger) or: [ (aValue < 0) | (aValue > 255) ])
    ifTrue: [^ aValue _error: #rtErrExpectedByteValue].
  ].

self _primitiveFailed: #at:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Accessing' }
Object >> basicAt: anIndex [

"Returns the object at the given location in the receiver.  Subclasses
 should not reimplement this method."

^self _basicAt: anIndex

]

{ #category : 'Updating' }
Object >> basicAt: anIndex put: aValue [

"Puts the given object into the given location in the receiver.  Subclasses
 should not reimplement this method."

^self _basicAt: anIndex put: aValue

]

{ #category : 'Comparing' }
Object >> basicIdentityHash [

"This method returns some Integer related to the identity of the receiver.  If
 two objects compare identically (==) to each other, the results of sending
 basicIdentityHash to each of those objects is equal."

"Faster than identityHash.  Used in GsMethodDictionary ."


<primitive: 321>

self _primitiveFailed: #basicIdentityHash .
self _uncontinuableError

]

{ #category : 'Storing and Loading' }
Object >> basicLoadFrom: passiveObj [

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into the receiver."

passiveObj hasRead: self.
(passiveObj readNamedIV) ifFalse: [
  "may be an old format, with assumed instance variable positions"
  ^self basicLoadFromOld: passiveObj
  ].
self loadNamedIVsFrom: passiveObj.
self class isVariable ifTrue: [
  self loadVaryingFrom: passiveObj
].

]

{ #category : 'Storing and Loading' }
Object >> basicLoadFrom: passiveObj size: varyingSize [

"Read the structure from the given passiveObj, with named instance variable
 format.  This is similar to basicLoadFrom:, but is used for objects whose size
 can not be preallocated at instantiation time (such as a Set)."

passiveObj hasRead: self.
self basicLoadFromNoRead: passiveObj size: varyingSize

]

{ #category : 'Storing and Loading' }
Object >> basicLoadFromNoRead: passiveObj size: varyingSize [

"Private."

(passiveObj readNamedIV) ifFalse: [
  "may be an old format, with assumed instance variable positions"
  ^self basicLoadFromOld: passiveObj
].
self loadNamedIVsFrom: passiveObj.
self class isVariable ifTrue: [
  self loadVaryingFrom: passiveObj size: varyingSize
].

]

{ #category : 'Storing and Loading' }
Object >> basicLoadFromOld: passiveObj [

"Read my structure from the given passiveObj."

self class firstPublicInstVar to: self namedSize do: [:i |
  self instVarAt: i put: passiveObj readObject
].

self class isVariable ifTrue: [
  self loadVaryingFrom: passiveObj
].

]

{ #category : 'Accessing' }
Object >> basicPhysicalSize [

"Returns the number of bytes required to represent the receiver in memory.  If
 the receiver is in special format (which implies that its representation is the
 same as its OOP), returns zero.

 The basicPhysicalSize method returns the same result as the default
 implementation (in class Object) of the physicalSize method.  It makes that
 default implementation available even when the physicalSize method is
 reimplemented in a subclass.  The basicPhysicalSize method should not itself
 be reimplemented."

<primitive: 364>
self _primitiveFailed: #basicPhysicalSize

]

{ #category : 'Accessing' }
Object >> basicSize [

"Returns the number of named instance variables plus the number of indexed
 instance variables in the receiver.  This result is equivalent to
 GciFetchSize(self).

 This method is implemented as a primitive, for improved performance."

<primitive: 88>

self _primitiveFailed: #basicSize .
self _uncontinuableError

]

{ #category : 'Storing and Loading' }
Object >> basicWriteTo: passiveObj [

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| s variable cls c |
  cls := self class.
  passiveObj writeClass: cls.

  variable := cls isVariable.
  variable ifTrue: [ passiveObj writeSize: (s := self _basicSize) ].

  passiveObj writeNamedIvsFrom: self class: cls .
  passiveObj endNamedInstVars.

  variable ifTrue: [
    c := 0.
    1 to: s do: [:i |
      passiveObj writeObject: (self _at: i).
      c := c + 1.
      c > 99 ifTrue: [
        passiveObj lf.
        c := 0.
      ].
    ]
  ].
  passiveObj cr

]

{ #category : 'Updating' }
Object >> become: anObject [

"Swaps the identities of the receiver and the argument.

 Intended only for experienced GemStone Smalltalk programmers who need to
 migrate instances of one class to another.

 The sender is responsible for checking the consistency of the class histories
 of the argument and the receiver.  This method makes no such checks.

 The argument, the receiver, or both are permitted to be invariant.

 Neither the argument nor the receiver may be special objects (instances of
 classes such as SmallInteger, Character, or Boolean).  Also, neither may be
 instances of a class that is a kind of
   Behavior, BlockClosure, CByteArray, CFunction, CLibrary, CPointer,
   GsCompilerIRNode, GsFile, GsNMethod,, GsProcess, GsSocket, Regexp,
   VariableContext
 Neither the argument nor the receiver may be a kind of Bag that has indexes
 built on it.  If either the receiver or the argument (or both) participate in
 an index, then either both must be in byte format or neither must be in byte
 format.  That is, one cannot be in byte format if the other is not also.  To
 avoid the error conditions triggered by presence of indexes, remove the
 indexes from the relevant NSCs prior to invoking this method.

 Neither the argument nor the receiver may exist as self below the sender of a
 become: message on the active GemStone Smalltalk stack.

 Any clusterIds that belong to an object on disk remain with the object.
 That is, the clusterIds do not follow the identities when they are swapped.

 The ObjectSecurityPolicies of the objects do not follow the identities
 when they are swapped.

 As of Gs64 v3.0 ,  tags are no longer swapped between the objects,
 they are treated same as instance variables. "

<primitive: 2001>  "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | refsToRcvr refsToObj rcvrInIndex objInIndex dlForRcvr dlForObj newSelf
    myCls argCls |
  self == anObject ifTrue: [ ^ self ].

  (self _onStackAsSelfBelow: 5) ifTrue:[ self _error: #rtErrCantBecomeSelfOnStack ].
  (anObject _onStackAsSelfBelow: 5) ifTrue:[ anObject _error: #rtErrCantBecomeSelfOnStack].

  (myCls := self class) _instancesNpDbtransient ==
  (argCls := anObject class) _instancesNpDbtransient ifFalse:[
    myCls instancesNonPersistent == argCls instancesNonPersistent ifFalse:[
      self _error: #rtErrCantBecomeGeneric args: { 'instancesNonPersistent' }.
    ].
    myCls instancesDbTransient == argCls instancesDbTransient ifFalse:[
      self _error: #rtErrCantBecomeGeneric args: { 'instancesDbTransient' }.
    ]
  ].
  " get index participants that reference the receiver "
  refsToRcvr := self _getIndexReferencesInto: { } .

  " get index participants that reference anObject "
  refsToObj := anObject _getIndexReferencesInto: { } .

  (refsToRcvr size + refsToObj size) ~~ 0 ifTrue:[
    refsToRcvr size ~~ 0 ifTrue:[
      rcvrInIndex := (refsToRcvr detect:[ :o | o _isIndexObject ] ifNone: [ nil ])
    ].
    refsToObj size ~~ 0 ifTrue:[
      objInIndex := (refsToObj detect:[ :o | o _isIndexObject ] ifNone: [ nil ])
    ].
    " if both participate in an index, check their formats "
    (rcvrInIndex ~~ nil or: [ objInIndex ~~ nil ]) ifTrue:[
	( myCls isBytes ==  argCls isBytes ) ifFalse:[
          ^ ArgumentError new reason: #rtErrCantBecomeOneIdx ; _number: 2119; details:
'Become not allowed, one object participates in an index and the other has different format';
           signal
	]
    ].
    UnorderedCollection _disableRcIndexLogging.
    self _removeIndexParticipation: refsToRcvr for: anObject.
    anObject _removeIndexParticipation: refsToObj for: self.
    "Make sure Dependency lists are gone or the primitive will fail"
    (dlForObj := DependencyList for: anObject) == nil
	  ifFalse:[DependencyList set: nil for: anObject.].
    (dlForRcvr := DependencyList for: self ) == nil
	  ifFalse:[DependencyList set: nil for: self.].

    self _primitiveBecome: anObject forDict: false .
    self _resetParentRef .
    anObject _resetParentRef .

    " remember, the variable 'anObject' and 'self' have switched identities "

    "Restore the DependencyLists.  Filter out empty ones, which are invalid anyway"
    (dlForObj size ~~ 0)
	  ifTrue:[DependencyList set: dlForObj for: anObject.].
    (dlForRcvr size ~~ 0)
	  ifTrue: [DependencyList set: dlForRcvr for: self.].

    newSelf := self .   "not safe to send to self in this method after the become"
    newSelf _restoreIndexParticipation: refsToRcvr.
    anObject _restoreIndexParticipation: refsToObj.

    UnorderedCollection _enableRcIndexLogging.
  ] ifFalse:[   "no index participation"
    self _primitiveBecome: anObject forDict: false .
    self _resetParentRef .
    anObject _resetParentRef .
  ]
] ensure:[
  prot _leaveProtectedMode
].

]

{ #category : 'Finalization' }
Object >> beEphemeron: aBoolean [

"Sets or clears receiver's isEphemeron bit and returns previous state of the bit.
 If aBoolean is false, clears isEphemeron bit if it was set, otherwise has
 no effect.
 If aBoolean is true, an ArgumentError is signaled and the object is not changed if
 any of the following are true:
   receiver is a byte format object
   receiver is an Nsc format object
   receiver has no instVars  (self basicSize == 0)
   receiver is a large object (self basicSize > 2034)
   receiver is a committed object
   receiver is a kind of VariableContext, GsNMethod, GsProcess, ExecBlock,
	Behavior, or SoftReference .
 If an object has the isEphemeron bit set,
   an error is generated if a size change would convert it to a large object;

   the isEphemeron bit is silently cleared if an attempt is made to
   commit the object, the isEphemeron bit remains cleared if the commit
   fails due to concurrency conflicts.

   the isEphemeron bit will silently have no effect after the basicSize
   of the object is changed to zero .

   the isEphemeron bit will silently have no effect if the first instVar
   references a special or committed object.

 See Object >> mourn  for documentation of finalization behavior. "

<primitive: 827>
aBoolean _validateClass: Boolean .
self _primitiveFailed: #beEphemeron: args: { aBoolean }

]

{ #category : 'Updating' }
Object >> beTranlogged [

"For a temporary object, ensures that if it is first added to the closure
 of an attempted commit by reference from a not-tranlogged object,
 the temporary object will be committed as a tranlogged object.
 Has no effect on special objects, or committed objects which are
 tranlogged.
 Signals an error if the receiver is committed and would answer false to
 isTranlogged , or is part of the closure of a failed commit and
 was made reachable by a not-tranlogged object.
 Returns the receiver."

<primitive: 1020>
^ self _primitiveFailed: #beTranlogged

]

{ #category : 'Testing' }
Object >> canBeWritten [

"Returns true if the current user has write authorization for the
 receiver, false if not."

^ ((self _status: false)  bitAnd: 16r10) ~~ 0

]

{ #category : 'Class Membership' }
Object >> changeClassTo: aClass [

"Redefines the class of the receiver to be aClass.  For this method to execute
 successfully, all of the following conditions must be true:

 1.  The receiver's class must have the same implementation as aClass
     (byte array, pointer array, or non-sequenceable collection).
 2.  If aClass is a kind of IdentitySet, then the class of the receiver
     must also be a kind of IdentitySet.  (This method cannot be used to
     change an IdentityBag to an IdentitySet.)
 3.  The argument aClass must not be a kernel class for which instance creation
     is disallowed.
 4.  The argument aClass must not be a GsMethod, GsMethodDictionary,
     SymbolDictionary, or SymbolList.
 5.  The receiver cannot as self below the sender of a
     changeClassTo: message on the active GemStone Smalltalk stack.
 6.  If the receiver has more instvars than the named instVars defined by
     aClass,  aClass must support varying instvars , and some of the instvars
     in the receiver will become varying instvars .
     If aClass defines more named instvars than the receiver, some of the
     receiver's varying instvars, if any, will become named instvars .
 7.  If aClass defines more named instvars than the total instvars in the
     receiver, extra instvars are initialized to nil .

 Generates an error if any of these conditions is not true."

^ self _changeClassTo: aClass preserveVarying: false

]

{ #category : 'Deprecated' }
Object >> changeToSegment: anObjectSecurityPolicy [

self deprecated: 'Object>>changeToSegment: deprecated v3.0. Use #objectSecurityPolicy: instead.'.
^ self objectSecurityPolicy: anObjectSecurityPolicy

]

{ #category : 'Class Membership' }
Object >> class [

"Returns the object that is the receiver's class."

<primitive: 610 >
^ self _primitiveFailed: #class .

]

{ #category : 'Clustering' }
Object >> cluster [

"This method clusters an object using the current default ClusterBucket.  It
 does not force an object to disk.  Rather an object not yet on disk
 is tagged so that the object remembers what cluster bucket is supposed to be
 used at such time as the object actually goes disk.  If the object is large,
 then all nodes of the object are clustered into the same bucket.

 If the object is a kind of UnorderedCollection with indexes, this method does
 not cluster indexes.  To cluster indexing objects, use the clusterIndexes
 method.  Alternatively, see the UnorderedCollection | clusterDepthFirst method.

 No action is taken to cluster objects referenced by user-defined tags.

 Has no effect and returns true if the receiver was previously clustered
 in the current transaction or if receiver is a GsNMethod loaded for execution; 
 otherwise returns false after clustering the receiver. "

^ self clusterInBucket: System currentClusterId

]

{ #category : 'Clustering' }
Object >> clusterBucket [

"Returns the cluster bucket for the object.  Returns nil if the object is a
 temporary object that is neither on disk nor previously clustered."

<primitive: 90>
self _primitiveFailed: #clusterBucket .
self _uncontinuableError

]

{ #category : 'Clustering' }
Object >> clusterDepthFirst [

"This method clusters the receiver and its instance variables in depth-first
 order.  Clustering is performed on all of the objects that can be reached via a
 transitive traversal starting at the receiver.  If an object is referenced by
 more than one clustering operation during the current transaction (that is,
 since the last commit or abort), it is located nearest the first reference.

 This routine assumes that if we need to cluster inside this object that the
 object contains only named instance variables or indexed instance variables.
 It cannot have unordered instance variables since that would have to be a kind
 of Bag and this method is overridden in Collection.

 Note that this implementation does not include clustering of any user-defined
 tags.

 After clustering, returns true if the receiver is a byte object,
 otherwise returns false.

 Has no effect and returns true if the receiver was previously clustered
 in the current transaction, or if the receiver is a special object."

self cluster
  ifTrue:
    [ ^ true ]
  ifFalse:
    [ 1 to: self namedSize do:
      [ :i | (self instVarAt: i) clusterDepthFirst ].
      1 to: self _basicSize do: [ :i | (self at: i) clusterDepthFirst ].
      ^ false
    ]

]

{ #category : 'Clustering' }
Object >> clusterInBucket: aClusterBucketOrId [

"This method does not force an object to disk.  Rather an object not already on
 disk is tagged so that the object remembers what cluster bucket is supposed to
 be used at such time as the object actually goes disk.

 If the object is large, then all nodes of the object are clustered
 into the same bucket.

 If the object is a kind of UnorderedCollection with indexes, this method does
 not cluster indexes.  To cluster indexing objects, use the clusterIndexes
 method.  Alternatively, see the UnorderedCollection | clusterDepthFirst method.

 No action is taken to cluster objects referenced by user-defined tags.

 If the receiver was previously clustered in the current transaction
 or is a GsNMethod loaded for execution, has no effect and returns true;

 else if the receiver is a special object has no effect and returns true;

 else if current session does not have write authorization to receiver,
 and receiver is in SystemObjectSecurityPolicy or
 DataCuratorObjectSecurityPolicy, has no effect and returns true;

 else if current session does not have write authorization to receiver,
 signals an Error ;

 else if the receiver is a byte object and was not previously clustered
 in the current transaction  , clusters the receiver and returns true ;

 else if the receiver was not previously clustered in the current transaction,
 clusters the receiver and returns false. "

<primitive: 279>
self _primitiveFailed: #clusterInBucket: args: { aClusterBucketOrId } .
self _uncontinuableError

]

{ #category : 'Storing and Loading' }
Object >> containsIdentity [

"Private."

^false

]

{ #category : 'Copying' }
Object >> copy [

"Returns a copy of the receiver which shares the receiver's instance
 variables.

 Gs64 v3.0 change:
   Dynamic instVars (i.e. the Tags) of the receiver ARE copied.
 See primitive 55 for Gs64 v2.x behavior."

^self shallowCopy postCopy

]

{ #category : 'Instance Migration' }
Object >> copyDynamicInstVars: aList from: anObject [
  "For dynamic instVar name/value pairs from anObject,
   if the name of the dynamic instVar is an element of anIdentitySet,
   add that name/value pair to the receiver.
   aList should be an  Array or IdentitySet of Symbols. "
  | pairs |
  pairs := anObject dynamicInstVarPairs .
  1 to: pairs size by: 2 do:[:n | | aName |
    aName := pairs at: n .
    (aList includesIdentical: aName) ifTrue:[
      self dynamicInstVarAt: aName put: (pairs at: n+1)
    ].
  ].

]

{ #category : 'Instance Migration' }
Object >> copyDynamicInstVarsFrom: anObject [
  "Copy all dynamic instVar name/value pairs from anObject to the receiver."
  | pairs |
  pairs := anObject dynamicInstVarPairs .
  1 to: pairs size by: 2 do:[:n |
    self dynamicInstVarAt: (pairs at: n) put: (pairs at: n+1)
  ].

]

{ #category : 'Copying' }
Object >> deepCopy [

"Returns a deep copy of the receiver.  That is, if the receiver is a collection
 or a complex object, the copy has copies of the original's elements and
 any component parts.  Those copies are also deep copies.  In other words,
 deep copying is recursive.

                                 CAUTION:

 Use this method with care.  It makes copies of all objects that can be reached
 from the receiver, which in some cases could be very large."

| copiedObjDict copy |

copiedObjDict := IdentityKeyValueDictionary new.
copy := self _deepCopyWith: copiedObjDict.
^copy.

]

{ #category : 'Deprecated Notification' }
Object >> deprecated [
  "Methods that send this message are considered deprecated. Deprecated methods
   are supported for the current version, but may be removed in a future release."

  self deprecated: nil.

]

{ #category : 'Deprecated Notification' }
Object >> deprecated: aString [
  "Methods that send this message are considered deprecated, with <aString> providing
   details on the deprecation.  <aString> should include the class and method name,
   the version in which the method is deprecated, and what to do instead.
   Deprecated methods are supported for the current version, but may be removed in
   a future release."

  DeprecationEnabled ifNotNil:[ ^ Deprecated signal: aString ].
  ^ self

]

{ #category : 'Deprecated Notification' }
Object >> deprecatedNotification: aString [
  "Methods that send this message are considered deprecated, with <aString> providing
   details on the deprecation.  See Object>>deprecated: for details."

  DeprecationEnabled ifNil:[ ^ self "ignore" ].
  Deprecated signal: aString.

]

{ #category : 'Formatting' }
Object >> describe [

"Returns an instance of a subclass of CharacterCollection describing the
 receiver.  This method is required by Topaz and by GemStone internal error
 handling.  Any reimplementation must conform to the following rules:

 * This method must not return nil.

 * This method must return an instance of a subclass of CharacterCollection."

^ [ self printString ] onException: Error do:[:ex | '<error during Object>>describe>' ]

]

{ #category : 'Formatting' }
Object >> describe1K [

"Returns an instance of a subclass of CharacterCollection describing the
 receiver.   Result has a max size of 1024 elements.
 This method is required by Topaz and by GemStone internal error
 handling.  Any reimplementation must conform to the following rules:

 * This method must not return nil.

 * This method must return an instance of a subclass of CharacterCollection."

^ [ | ws |
    ws := PrintStream printingOn: String new maxSize: 1024 .
    self printOn: ws.
    ws _collection
  ] onException: Error do:[:ex | '<error during Object>>describe1K>' ]

]

{ #category : 'Error Handling - Compatibility' }
Object >> doesNotUnderstand: aMessageDescriptor [

"The method is for compatiblity with Gs64 v2.x, and assumes you are using
   only method environment 0  for all of your Smalltalk code."

| ex sel args |
(ex := MessageNotUnderstood _basicNew)
  receiver: self selector: (sel := aMessageDescriptor at: 1)
		args: (args := aMessageDescriptor at: 2) envId: 0 .
^ex signal .	"fix for #40871"

"Legacy behavior was that you could fall through from an exception handler
without an explicit resume/return. The fix for 40871 will break applications
that rely on the old behavior."

"If we continue from the error, re-try the send of the message that was
 not understood."
"^ self perform: sel env: 0 withArguments: args "

]

{ #category : 'Error Handling' }
Object >> doesNotUnderstand: aSymbol args: anArray envId: envId [

"Generates an error reporting that the receiver cannot respond to a message.
 because no compiled method was found for aSymbol in method environment
 envId.   envId is a SmallInteger, 0 for Smalltalk , 1 for Ruby ,
 2..255 for future use by Smalltalk package managers .
"
| ex |
(ex := MessageNotUnderstood _basicNew)
  receiver: self selector: aSymbol args: anArray envId: envId .
^ex signal .	"fix for #40871"

"Legacy behavior was that you could fall through from an exception handler
without an explicit resume/return. The fix for 40871 will break applications
that rely on the old behavior."

"If we continue from the error, re-try the send of the message that was
 not understood."

"^ self perform: aSymbol env: envId withArguments: anArray "

]

{ #category : 'Dynamic Smalltalk Instance Variables' }
Object >> dynamicInstanceVariables [
  "Returns an Array of Symbols which are names of the
   dynamic instance variables of the receiver."

  ^ self _instvarNamesAfter: self namedSize 

]

{ #category : 'Dynamic Smalltalk Instance Variables' }
Object >> dynamicInstVarAt: aSymbol [
 "Return the value of specified dynamic instance variable, or nil if receiver
  has no such dynamic instance variable.  Does not consider instVars defined
  by the receiver's class."

<primitive: 881>
aSymbol _validateClass: Symbol .
aSymbol size == 0 ifTrue:[ ArgumentError signal:'instVar names cannot be empty symbol'].
self _primitiveFailed: #dynamicInstVarAt: args: { aSymbol }

]

{ #category : 'Dynamic Smalltalk Instance Variables' }
Object >> dynamicInstVarAt: aSymbol put: aValue [
 "Store the value of specified dynamic instance variable,
  If aValue ~~ _remoteNil, creates the dynamic instance variable if needed.
  aValue == _remoteNil effectively removes the instance variable.
  Does not consider instVars defined by the receiver's class.
  Generates an error if receiver is an ExecBlock, Behavior, GsNMethod, or
  special object.
  Returns aValue .

  Do not use this method and also use _tagAt:put: on the same object."

<primitive: 880>
aSymbol _validateClass: Symbol .
aSymbol size == 0 ifTrue:[ ArgumentError signal:'instVar names cannot be empty Symbol'].
self _primitiveFailed: #dynamicInstVarAt:put: args: { aSymbol . aValue }

]

{ #category : 'Dynamic Smalltalk Instance Variables' }
Object >> dynamicInstVarPairs [
"Returns the dynamic instance variarbles of the receiver
 in the form of an Array of name/value pairs.
 If the Array is of size zero, it may be the invariant Array  #() . "

<primitive: 1107>
self _primitiveFailed: #dynamicInstVarPairs .

]

{ #category : 'Comparing' }
Object >> equalsNoCase: aCharCollection [

"Returns true if the receiver and the argument have the same value.
 Returns false otherwise.

 Reimplemented in String and MultiByteString to provide case-insensitive
 comparison.  This implementation is the default for non-string objects."

^ self = aCharCollection

]

{ #category : 'Error Handling' }
Object >> error: messageString [

"Raises an error.  This method is intended for use in raising
 application-defined or user-defined errors. Returns the receiver."

^ UserDefinedError new _number: 2318;
        reason: #halt ; details: messageString ; signal

]

{ #category : 'Listing References' }
Object >> fastAllReferences [
  "Same as Object >> findAllReferences , but uses more threads."

  | argArray tmpArray resultArr |
  System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

  argArray := { self } .
  tmpArray := SystemRepository fastListReferences: argArray .

  resultArr := tmpArray at: 1.
  resultArr removeIdentical: argArray ifAbsent:[ ].
  ^ resultArr
]

{ #category : 'Listing References' }
Object >> fastPrivateReferences [
  "Same as Object >> findAllReferences , but uses more threads and returns
   references from internal nodes of large objects and Nscs."

  | argArray tmpArray resultArr |
  System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

  argArray := { self } .
  tmpArray := SystemRepository fastPrivateReferences: argArray .

  resultArr := tmpArray at: 1.
  resultArr removeIdentical: argArray ifAbsent:[ ].
  ^ resultArr
]

{ #category : 'Listing References' }
Object >> findAllReferences [

 "Returns an Array containing all references to the receiver.
 If an object contains multiple references to the receiver, that object occurs
 only once in the result.

 Large result sets may cause out-of-memory issues. To avoid problems,
 use Repository >> allReferences:, which returns a GsBitmap that does not
 require keeping objects in temporary object space.

 This method aborts the current transaction; if an abort would cause unsaved
 changes to be lost, it signals an error, #rtErrAbortWouldLoseData.

 The result contains both permanent and temporary objects.  The temporary
 objects found may vary from run to run. "

  ^ self findReferencesWithLimit: 0
]

{ #category : 'Listing References' }
Object >> findNonStubbedReferencesInMemory [

"Returns an Array of objects in current sessions temporary object memory
 that reference the receiver by a direct memory reference, i.e.
 those references that have not been stubbed to an objectId if the
 receiver is a committed object.

 The result may contain both permanent and temporary objects and may
 vary from run to run.  Does not abort the current transaction.
"

| argArray tmpArray resultArr |
argArray := { self } .
tmpArray := SystemRepository _listReferencesInMemory: argArray nonStubbedOnly: true .
resultArr := tmpArray at: 1.
resultArr removeIdentical: argArray ifAbsent:[ ].
^ resultArr

]

{ #category : 'Listing References' }
Object >> findReferences [

"Searches GemStone for objects that reference the receiver, and returns an Array
 of any such objects.  The search continues until all such objects have been
 found, or until the result contains 20 elements.  (The method
 findReferencesWithLimit: allows you to specify an arbitrarily large limit for
 the result Array.)

 If an object contains multiple references to the receiver, that object occurs
 only once in the result.

 This method aborts the current transaction; if an abort would cause unsaved
 changes to be lost, it signals an error, #rtErrAbortWouldLoseData.

 The result contains both permanent and temporary objects.  The temporary
 objects found may vary from run to run. 

 Large result sets may cause out-of-memory issues. To avoid problems,
 use Repository >> allReferences:, which returns a GsBitmap that does not
 require keeping objects in temporary object space.
"

^self findReferencesWithLimit: 20

]

{ #category : 'Listing References' }
Object >> findReferencesInMemory [

"Returns an Array of objects in current sessions temporary object memory
 that reference the receiver.  If receiver is a committed object,
 the result includes both direct memory references from temporary or
 modified committed objects, and references by objectId from other
 in-memory committed objects.  See also findNonStubbedReferencesInMemory .

 The search continues until all such objects have been found, or until the
 size of the result reaches the specified maximum aSmallInt.

 The result may contain both permanent and temporary objects and may
 vary from run to run.  Does not abort the current transaction.
"

| argArray tmpArray resultArr |
argArray := { self } .
tmpArray := SystemRepository listReferencesInMemory: argArray .
resultArr := tmpArray at: 1.
resultArr removeIdentical: argArray ifAbsent:[ ].
^ resultArr

]

{ #category : 'Listing References' }
Object >> findReferencesWithLimit: aSmallInt [

"Returns an Array of objects in GemStone that reference the receiver.
 The search continues until all such objects have been found, or until the
 size of the result reaches the specified maximum aSmallInt.

 Large result sets may cause out-of-memory issues. To avoid problems,
 use Repository >> allReferences:, which returns a GsBitmap that does not
 require keeping objects in temporary object space.

 If aSmallInt is <=  0, the result size is unlimited.

 The result contains both permanent and temporary objects.  The temporary
 objects found may vary from run to run.

 This method aborts the current transaction; if an abort would cause unsaved
 changes to be lost, it signals an error, #rtErrAbortWouldLoseData.

 Note that this method may take a considerable length of time to
 execute, and the result may occupy a large amount of disk space.
 (Compare with findReferences, which limits the result to 20 elements.). "

| argArray tmpArray resultArr limit |

System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

argArray := { self } .
limit :=  aSmallInt > 0 ifTrue:[ aSmallInt + 1] ifFalse:[ 0 ] .
tmpArray := SystemRepository listReferences: argArray withLimit: limit.

resultArr := tmpArray at: 1.
resultArr removeIdentical: argArray ifAbsent:[ ].
aSmallInt > 0 ifTrue:[
  resultArr size > aSmallInt ifTrue:[ resultArr size: aSmallInt ].
].
^ resultArr

]

{ #category : 'Repository Conversion' }
Object >> fixIndexableRefsAfterConversion [

"Default method for fixing references to ObsLargePositiveInteger and
 ObsLargeNegativeInteger instances that can now be represented as
 SmallInteger and Floats and SmallFloats which can now be represented as
 a SmallDouble."

|myClass|

myClass := self class.

myClass isIndexable
  ifTrue:[
    1 to: self _basicSize do:[:n| |iv |
      iv := self _basicAt: n.
	iv needsFixingAfterConversion
		ifTrue:[self _basicAt: n put: (iv + 0)].
  ].
].
^true

]

{ #category : 'Repository Conversion' }
Object >> fixInstVarRefsAfterConversion [

"Default method for fixing references to ObsLargePositiveInteger and
 ObsLargeNegativeInteger instances that can now be represented as
 a SmallInteger and Floats and SmallFloats which can now be
 represented as a SmallDouble."

|myClass|
myClass := self class.
"Check the named inst vars first..."
1 to: myClass allInstVarNames size do:[:n|
  |iv |
  iv := self instVarAt: n.
  iv needsFixingAfterConversion
	ifTrue:[self instVarAt: n put: (iv + 0)].
].
^true

]

{ #category : 'Repository Conversion' }
Object >> fixReferencesInFirstPass [

"Return whether this object should have references to Float,
 SmallFloat, ObsLargePositiveInteger and ObsLargeNegativeInteger
 fixed in the first pass.  false means fix them in the 2nd pass."

^true

]

{ #category : 'Encoded OOPs' }
Object >> getOldHighEncodedOop [

"Return a SmallInteger which is the high 16 bits of the Gs64 v1.1 OOP for the object.
 Return nil if the object is not representable with a 4 byte OOP .
 Special objects will always return nil.
"
| n |
n := self _getOldOop .
n ifNil:[ ^ nil ].
^ n bitShift: 16

]

{ #category : 'Encoded OOPs' }
Object >> getOldLowEncodedOop [

"Return a SmallInteger which is the low 16 bits of the Gs64 v1.1 OOP for the object.
 Return nil if the object is not representable with a 4 byte OOP .
 Special objects will always return nil.
"

| n |
n := self _getOldOop .
n == nil ifTrue:[ ^ nil ].
^ n bitAnd: 16rFFFF

]

{ #category : 'Encoded OOPs' }
Object >> getOopFromInstVar: anOffset [

"Return the oop for the object referenced by this one at the given
offset without reading the referenced object.  Note that in the case of
collections, the offset could reference either a named instance variable
or an indexable instance variable.  Named inst vars start at offset 1
and run up to the number of named inst vars.  Indexable inst vars follow
named inst vars in the sequence.

The receiver must be a format-oop
object;  kinds of IdentityBag , CharacterCollection, ByteArray are not allowed.

For example, to access the first element of an Array subclass with 3
named inst vars, an offset of 4 would be used."

<primitive: 637>
anOffset _validateClass: Integer .
(anOffset < 1 or:[anOffset > self _primitiveSize]) ifTrue:[
  self _errorIndexOutOfRange: anOffset .
].
self _primitiveFailed: #getOopFromInstVar: args: { anOffset } .

]

{ #category : 'Error Handling' }
Object >> halt [

"Signals a Halt exception. Returns the receiver."

  Halt signal

]

{ #category : 'Error Handling' }
Object >> halt: messageString [

"Raises an error.  This method is intended for use in raising
 application-defined or user-defined errors. Returns the receiver."

  Halt signal: messageString

]

{ #category : 'Comparing' }
Object >> hash [

"This method returns some Integer related to the contents of the
 receiver.  If two objects compare equal (=) to each other, the results
 of sending hash to each of those objects must also be equal.
 Ordinarily, a class which reimplements the = method should also reimplement
 hash.  Notice that an instance of class Object actually bases equality on
 identity, since it has no contents.  Therefore, this implementation of
 hash actually returns an Integer related to the identity of the
 receiver."

<primitive: 609 >

self _primitiveFailed: #hash .
self _uncontinuableError

]

{ #category : 'Comparing' }
Object >> identityHash [

"This method returns some Integer related to the identity of the receiver.  If
 two objects compare identically (==) to each other, the results of sending
identityHash to each of those objects will be equal."

<primitive: 609 >

self _primitiveFailed: #identityHash .
self _uncontinuableError

]

{ #category : 'Flow of Control' }
Object >> ifNil: aBlock [

"(Reserved selector.)  Returns the value of the zero-argument block aBlock
 if the receiver is == nil, otherwise, returns the receiver.

 This implementation is used by sends for which the argument is not
 a literal block.
 The following is an optimized control structure, not a recursive send."

^ self ifNil:[ aBlock value ] ifNotNil:[ self ]

]

{ #category : 'Flow of Control' }
Object >> ifNil: nilBlock ifNotNil: notNilBlock [

"(Reserved selector.)  Returns the value of the zero-argument block nilBlock
 if the receiver is == nil.  Otherwise, returns the value of the notNilBlock
 without evaluating nilBlock.
 The notNilBlock may be a zero or one arg block.  For a one arg block
 the receiver is assigned to the block argument if the notNilBlock is executed.

 This implementation is used by sends for which the arguments are not
 literal blocks.
 The following is an optimized control structure, not a recursive send."

  self ifNil:[^ nilBlock value].
  notNilBlock numArgs == 0 ifTrue:[ ^ notNilBlock value].
  ^ notNilBlock value: self

]

{ #category : 'Flow of Control' }
Object >> ifNotNil: aBlock [

"(Reserved selector.)  Returns the value of the block aBlock
 if the receiver is ~~ nil, otherwise, returns the receiver.
 aBlock may be a zero or one arg block.  For a one arg block
 the receiver is assigned to the block argument if aBlock is executed.

 This implementation is used by sends for which the argument is not
 a literal block.
 The following is an optimized control structure, not a recursive send."

 self ifNotNil:[
    aBlock numArgs == 0 ifTrue:[ ^ aBlock value].
    ^ aBlock value: self
 ].
  ^ self

]

{ #category : 'Flow of Control' }
Object >> ifNotNil: notNilBlock ifNil: nilBlock [

"(Reserved selector.)  Returns the value of the zero-argument block notNilBlock
 if the receiver is ~~ nil.  Otherwise, returns the value of the zero-argument
 block nilBlock without evaluating notNilBlock.
 The notNilBlock may be a zero or one arg block.  For a one arg block
 the receiver is assigned to the block argument if the notNilBlock is executed.

 This implementation is used by sends for which the arguments are not
 literal blocks.
 The following is an optimized control structure, not a recursive send."

 self ifNotNil:[
    notNilBlock numArgs == 0 ifTrue:[ ^ notNilBlock value].
    ^ notNilBlock value: self
 ].
 ^ nilBlock value

]

{ #category : 'Invariance' }
Object >> immediateInvariant [

"Makes the receiver immediately invariant.  (By comparison, when
 invariance is specified during subclass creation, instances become
 invariant when they are first committed.)  Returns receiver.

 There is no protocol to reverse the effect of this method.  If the
 receiver is a temporary object , there is no way to undo the effect
 of this method.  If the receiver was committed before the start
 of the current transaction, the effect of this method can be undone
 by aborting the transaction."

<primitive: 269>
self _primitiveFailed: #immediateInvariant .
self _uncontinuableError

]

{ #category : 'Deprecated' }
Object >> in: aCollection [

"If there is an element of aCollection identical to the receiver,
 returns true.  Otherwise, returns false."

self deprecated: 'Object>>in: deprecated before v3.0, use #includesIdentical: in collection'.
^ aCollection includesIdentical: self "this means identity, not equality"

]

{ #category : 'Initialization' }
Object >> initialize [
  "Default implementation"  
  ^ self
]

{ #category : 'Accessing' }
Object >> instVarAt: anIndex [

"If the receiver has an instance variable at anIndex, returns
 its value.  Generates an error if anIndex is not a SmallInteger or
 is out of bounds, or if the receiver has no instance variables."

<primitive: 611 >

| numInstVars |
(anIndex _isInteger) ifTrue: [
   numInstVars:= self namedSize .
   (numInstVars == 0) ifTrue:[ ^ self _error: #rtErrNoInstVars].
   ((anIndex >= 1) and:[anIndex <= numInstVars]) ifFalse:[
        ^ self _errorIndexOutOfRange: anIndex "out of bounds"
   ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anIndex
].
self _primitiveFailed: #instVarAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> instVarAt: anIndex put: aValue [

"Stores the argument aValue in the instance variable indicated by anIndex.
 Generates an error if anIndex is not a SmallInteger or is out of bounds,
 or if the receiver has no instance variables,
 or if  (self class _structuralUpdatesDisallowed == true) .
 Returns aValue .

 This primitive is equivalent to GciStoreNamedOop."

<primitive: 604 >
| numIvs |
numIvs := self namedSize .
numIvs == 0 ifTrue: [ ^ self _error: #rtErrNoInstVars].
(anIndex _isSmallInteger)
  ifTrue: [((anIndex < 1) | (anIndex > numIvs ))
        ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]] "out of bounds"
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #instVarAt:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Testing' }
Object >> isAssociation [
  ^ false

]

{ #category : 'Testing' }
Object >> isBehavior [

"Returns true if the receiver is a kind of Behavior (that is, a Class or
 metaclass object).  Returns false otherwise."

^false

]

{ #category : 'Class Membership' }
Object >> isByteKindOf: aClass [

"Returns true if the class of the receiver is a kind of aClass,
 and if the receiver has byte format."

(self isKindOf: aClass) ifFalse:[ ^ false ] .

^ self class isBytes

]

{ #category : 'Testing' }
Object >> isClass [

"Returns true if the receiver is a kind of Behavior (that is, a Class or
 metaclass object).  Returns false otherwise."

^ self isBehavior.

]

{ #category : 'Clustering' }
Object >> isClustered [

" Returns true if the object has been clustered in the current
  transaction, false otherwise"

<primitive: 278>
self _primitiveFailed: #isClustered

]

{ #category : 'Testing' }
Object >> isCommitted [

"Returns true if the receiver was a committed object at the time the current
 transaction began.  Returns false otherwise."

^((self _status: true) bitAnd: 2) ~~ 0

]

{ #category : 'Deprecated' }
Object >> isConnected [

"Always returns false.  this method is obsolete"
self deprecated: 'Object>>isConnected is deprecated before v3.0; will always returns false'.
^ false

]

{ #category : 'Finalization' }
Object >> isEphemeron [

"Returns true if receiver's isEphemeron bit is set, false otherwise"

<primitive: 828>
self _primitiveFailed: #isEphemeron

]

{ #category : 'Testing' }
Object >> isEquivalent: anObject [

"Returns true if the receiver is equivalent to anObject.  This
 is used to test the equivalence of Characters and Strings.  At
 this level, two objects are equivalent if they are identical."

^self == anObject

]

{ #category : 'Formatting' }
Object >> isInPrintingRecursionSet: anIdentitySet [
	"Answer whether we are recursing through the receiver.
	 In general, the identity test is sufficient."

	^anIdentitySet includes: self

]

{ #category : 'Repository Conversion' }
Object >> isInternalObject [
"Deterine if the receiver is an instance of one of a special internal class.
 See also PrivateObject>>isInternalObject . "

  ^ false

]

{ #category : 'Invariance' }
Object >> isInvariant [

"Returns true if the receiver is currently invariant, false otherwise."

<primitive: 36>
self _primitiveFailed: #isInvariant .
self _uncontinuableError

]

{ #category : 'Class Membership' }
Object >> isKindOf: aClassHistoryOrClass [

"(Optimized selector.)  Returns true if the class of the receiver is identical
 to, or is a subclass of any class in aClassHistoryOrClass; otherwise, returns
 false.

 If the aClassHistoryOrClass argument is actually a class rather than a class
 history, then this method uses the class history of the argument, instead of
 the class itself.

 For compatiblity with legacy code,
   String >> isKindOf:
 behaves as if String has the classHistory  { String . MultiByteString }.
 and
   Symbol >> isKindOf:
   DoubleByteSymbol >> isKindOf:
   QuadByteSymbol >> isKindOf:
 all behave as if the class of the receiver
 has classHistory { Symbol . DoubleByteSymbol . QuadByteSymbol } .

 This selector is optimized by the compiler and may not be reimplemented
 in any subclass.  This implementation is so that perform: will work."

^ self isKindOf: aClassHistoryOrClass

]

{ #category : 'Class Membership' }
Object >> isKindOfClass: aClass [

"Returns true if aClass is identical to the class of the receiver
 or aClass is a superclass of the class of the receiver."

<primitive: 34>

aClass _errorExpectedClass: Class.
"just assume the class was wrong; we can't ask if it isKindOf: Class"
self _primitiveFailed: #isKindOfClass: args: { aClass } .
self _uncontinuableError

]

{ #category : 'Class Membership' }
Object >> isMemberOf: aClass [

"Returns true if the receiver is an instance of aClass, or if aClass is
 contained in the class history of the receiver's class; otherwise, returns
 false."

| rcvrClass |
rcvrClass := self class .
rcvrClass == aClass ifTrue:[ ^ true ] .
(rcvrClass _classHistoryIncludesIdentical: aClass) ifTrue:[ ^ true] .
^ false

]

{ #category : 'Class Membership' }
Object >> isMemberOfClass: aClass [

"Returns true if the receiver is an instance of aClass."

^self class == aClass

]

{ #category : 'Queries' }
Object >> isMeta [

"Returns false.  This method is reimplemented in metaclasses to return true."

^ false.

]

{ #category : 'Testing' }
Object >> isNil [

"Configurable optimized selector, see GsNMethod class >> configurableOptimizedSelectors.
 This implementation is only used by #perform. 

 Returns true if the receiver is nil, false otherwise.
 If isNil is not reimplemented in the application, then
   == nil
 is faster than
   isNil
 "

^ self == nil

]

{ #category : 'Testing' }
Object >> isNumber [
	"Unlike _isNumber, isNumber can be overridden in subclasses,
	to aid anyone implementing a numeric class that does not
	inherit from Number."

	^ self _isNumber
]

{ #category : 'Testing' }
Object >> isSpecial [

"Returns true if the receiver is a special object (for example, Character,
 Boolean, SmallInteger, or nil).  Returns false otherwise."

^ false

]

{ #category : 'Testing' }
Object >> isSymbol [

"Returns true if the receiver is a Symbol, DoubleByteSymbol, or QuadByteSymbol.
 false otherwise."

^ self _isSymbol

]

{ #category : 'Testing' }
Object >> isTranlogged [

"Returns true if the receiver was a committed object at the time the current
 transaction began and is not a notTranlogged object, or was part of the
 closure of a failed commit and did not become reachable by reference
 from a not tranlogged object."

^ ((self _status: true) bitAnd: 16r20) ~~ 0

]

{ #category : 'Class Membership' }
Object >> isUnicodeString [
  "Returns true if receiver is a kind of Unicode7, Unicode16, or Unicode32"
^ (self _stringCharSize bitAnd: 16r8) ~~ 0

]

{ #category : 'Deprecated' }
Object >> isUtfString [
  "Returns true if receiver is a kind of Unicode7, Unicode16, or Unicode32"
self deprecated: 'Object>>isUtfString deprecated v3.1.0.1, use isUnicodeString'.
^ (self _stringCharSize bitAnd: 16r8) ~~ 0

]

{ #category : 'Testing' }
Object >> isWritten [

"Returns true if the receiver was a committed object at the start of the
 current transaction and as been written by the current transaction.
 Returns false otherwise."

^((self _status: true) bitAnd: 16rA ) == 16rA

]

{ #category : 'Class Membership' }
Object >> legacyChangeClassTo: aClass [

"Same as changeClassTo: except condition 7 is not enforced.
 If aClass defines more named instvars than the receiver,
 and the receiver has varying instvars, the additional named
 instvars are inserted before the varying instvars , rather
 than some of the varying instvars becoming named instvars."


^ self _changeClassTo: aClass preserveVarying: true

]

{ #category : 'Storing and Loading' }
Object >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into the receiver."

^self basicLoadFrom: passiveObj

]

{ #category : 'Storing and Loading' }
Object >> loadNamedIVsFrom: passiveObj [

"Reads named instance variables from the given passive object.  The
 first instance variable should already have been parsed and be
 available in the passiveObj argument."

| name offset nameSym |

[ name := passiveObj ivName.
  name ifNotNil:[
    nameSym := Symbol _existingWithAll: name .
    nameSym ifNotNil:[
      offset := self class _ivOffsetOf: nameSym.
      offset ifNotNil:[ self instVarAt: offset put: passiveObj ivValue ]
                ifNil:[ self dynamicInstVarAt: nameSym put: passiveObj ivValue].
    ] ifNil:[
      self dynamicInstVarAt: name asSymbol put: passiveObj ivValue
    ].
    passiveObj readNamedIV
  ] ifNil:[
    false
  ]
] untilFalse.

passiveObj skipNamedInstVars.

]

{ #category : 'Storing and Loading' }
Object >> loadVaryingFrom: passiveObj [

"Reads the varying part of the receiver from the given passive object.
 Does not record the receiver as having been read.  Does not read the
 receiver's named instance variables, if any."

1 to: self _basicSize do: [:i |
  self _basicAt: i put: passiveObj readObject
].

]

{ #category : 'Storing and Loading' }
Object >> loadVaryingFrom: passiveObj size: varyingSize [

"Reads the varying part of the receiver from the given passive object.
 Does not record the receiver as having been read.  Does not read the
 receiver's named instance variables, if any."

1 to: varyingSize do: [:i |
  self _basicAt: i put: passiveObj readObject
].

]

{ #category : 'Instance Migration' }
Object >> migrate [

"Migrate the instance from its current class to its class's target class.
 If its class has no target class, do nothing."

| targetClass newInstance invar |

targetClass := self class migrationDestination.
targetClass ~~ nil ifTrue: [
  invar := self isInvariant .
  newInstance := targetClass migrateNew.
  newInstance objectSecurityPolicy: self objectSecurityPolicy .
  newInstance migrateFrom: self.
  invar ifTrue:[ newInstance immediateInvariant ].
  newInstance become: self.
  " remember, self and newInstance have changed identities (thus, we are
    really returning the newly created instance of targetClass) "
  ^ self
]

]

{ #category : 'Instance Migration' }
Object >> migrateFrom: anotherObject instVarMap: aMap [

"Takes information from the given object and puts it in the receiver.
 This message is sent to an object when its class is being migrated to
 another class to account for changes in a schema.

 aMap may be an Array or an InstVarMappingArray .
 the varying portion of aMap is a precalculated indirection table
 associating the receiver's instance variables with instance variables
 in the other object.  If a table entry is 0, the other object is assumed to not have that
 instance variable.

 If aMap is an InstVarMappingArray, it contains a boolean controlling whether
 dynamic instance variables are copied from old to new object.

 This method should be reimplemented if it is desired to copy some dynamic
 instVar values to named instVars, or copy some named instVars to dynamic,
 or to handle renaming of instVars , or otherwise customize the migration."

| cls |
cls := self class.
cls firstPublicInstVar to: aMap size do:[:i | | idx |
  "copy the named instVars per aMap"
  idx := aMap at: i.
  idx == 0 ifFalse:[ self _unsafeAt: i put: (anotherObject instVarAt: idx)].
].
aMap class == Array ifTrue:[
  self copyDynamicInstVarsFrom: anotherObject
] ifFalse:[
  "aMap is an InstVarMappingArray"
  aMap preserveDynamic ifTrue:[
    self copyDynamicInstVarsFrom: anotherObject
  ].
].
self migrateIndexable: anotherObject myClass: cls otherClass: anotherObject class.

]

{ #category : 'Instance Migration' }
Object >> migrateIndexable: anotherObject myClass: cls otherClass: othercls [

"Handle migrating the indexable component of an object."

| instSize |

instSize := cls instSize.
(cls isIndexable and: [ othercls isIndexable])
  ifTrue:[ " both classes are indexable "
    cls isBytes
      ifTrue:[
        ( (cls isKindOf: CharacterCollection) and:
        [ othercls isKindOf: CharacterCollection ] )
          ifTrue:[ " both are CharacterCollections "
            "anotherObject copyFrom:1 to: anotherObject size into: self startingAt: 1."
             self replaceFrom: 1 to: anotherObject size with: anotherObject startingAt: 1
          ]
         ifFalse:[
           instSize := cls instSize.
           self _basicSize: anotherObject _basicSize.
           1 to: anotherObject _basicSize do: [:j |
             self _unsafeAt: j+instSize put: (anotherObject _basicAt: j).
           ].
         ].
      ]
      ifFalse: [
        instSize := cls instSize.
        self _basicSize: anotherObject _basicSize.
        1 to: anotherObject _basicSize do: [:j |
            self _unsafeAt: j+instSize put: (anotherObject _at: j).
        ].
      ].
  ].

]

{ #category : 'Finalization' }
Object >> mourn [

 "Default implementation which does nothing.

  An ephemeron (any object with the isEphemeron bit set) is treated
  specially during garbage collection. An ephemeron is typically used
  to provide finalization for some 'key' object. The ephemeron's first
  instVar is a reference to the key, and any other instVars refer to
  'values'. Values often contain indirect references to the key.
  When in-memory mark-sweep determines that an object is only reachable
  through ephemerons for which it is the key, the ephemerons 'fire.'
  Equivalently, an ephemeron fires when in-memory mark-sweep finds that
  *if* all instVars of all ephemerons with its key were set to nil, the
  key would be unreferenced and therefore subject to garbage collection.

  When GC 'fires' an ephemeron, it synchronously changes the ephemeron's
  isEphemeron bit from true to false. It also arranges for the object to
  be sent #mourn later in a high-priority finalization GsProcess.

  Subclasses that are designed to be ephemerons should implement #mourn
  to do whatever makes sense for their specific function. Typically,
  #mourn performs some finalization action then sets all instvars of the
  ephemeron to nil so that the key will be collected on the next
  in-memory mark-sweep. Exceptions signaled during the execution of
  #mourn that are not handled within that implementation of #mourn are,
  by default, logged to stdout, finalization of that ephemeron is
  abandoned, and the finalization GsProcess continues to send #mourn to
  other ephemerons on the finalization queue. It will be possible to
  insert other actions, such as stack dumping, for debugging failures
  during #mourn.

  Note: Since #mourn is executed asynchronously after the GC, it is
  possible to send 'beEphemeron: false' to an object and for that
  object to subsequently be sent #mourn. This will happen if GC has
  decided to fire the ephemeron and put it on the finalization queue
  before 'beEphemeron: false' is sent. Checking the return value of
  'beEphemeron: false' could help you determine whether a #mourn
  message might yet be received, since GC resets the bit when it puts
  the ephemeron on the finalization queue. However, sending
  'beEphemeron: false' and getting a return value of true does not
  completely guarantee that no #mourn will be sent, since the
  ephemeron could conceivably have been already on the finalization queue,
  then sent 'beEphemeron: true', then sent 'beEphemeron: false'.
 "
 ^ self

]

{ #category : 'Clustering' }
Object >> moveToDisk [

" Has no effect , Returns the receiver"

^ self

]

{ #category : 'Clustering' }
Object >> moveToDiskInBucket: aClusterBucketOrId [

" Has no effect , Returns the receiver"

 ^ self

]

{ #category : 'Accessing' }
Object >> namedSize [
  "Returns a SmallInteger, the number of named instanceVariables in the receiver."
  ^ self _primitiveSize - self _basicSize
]

{ #category : 'Repository Conversion' }
Object >> needsFixingAfterConversion [
^false

]

{ #category : 'Updating' }
Object >> nilFields [

"Sets the instance variables of the receiver to nil.  This is sometimes useful
 as an aid to quicker garbage collection."

self class firstPublicInstVar to: self namedSize do: [:i |
  self instVarAt: i put: nil
].

(self class isNsc) ifTrue: [
  self removeAll: self
]
ifFalse: [
  (self class isIndexable and: [self class isPointers]) ifTrue: [
    self size: 0
  ].
].

]

{ #category : 'Formatting' }
Object >> nonRecursivePrintString [
	"Answer a String containing a displayable representation of the receiver."

	| ws str |
	str := String new.
	ws := PrintStream printingOn: str.
	self printNonRecursiveOn: ws.
	^ ws _collection "contents might have been converted to an EUCString."

]

{ #category : 'Testing' }
Object >> notNil [

"Configurable optimized selector, see GsNMethod class >> configurableOptimizedSelectors.
 This implementation is only used by #perform. 

 Returns true if the receiver is not nil, false otherwise.
 If notNil is not reimplemented in the application, then
   ~~ nil
 is faster than
   notNil
"

^ self ~~ nil

]

{ #category : 'Accessing' }
Object >> objectSecurityPolicy [

"Returns the GsObjectSecurityPolicy where the receiver is located.
 If the result is nil, the object has World write permission (objectSecurityPolicyId 0)."

<primitive: 592>
self _primitiveFailed: #objectSecurityPolicy .
^ nil

]

{ #category : 'Updating' }
Object >> objectSecurityPolicy: anObjectSecurityPolicy [

"Assign the receiver to the given security policy.  Override this method
 to include component objects.

 If the receiver's current security policy and anObjectSecurityPolicy are the same,
 this method has no effect, otherwise all of the following apply:

 Generates an error if the user is not authorized to write to both
 the receiver's current security policy and anObjectSecurityPolicy,
 or if the receiver is a special object (SmallInteger, Character,
 Boolean, SmallDouble, or UndefinedObject),
 or if anObjectSecurityPolicy is not a committed object.

 anObjectSecurityPolicy may be nil, in which case the object is given World write
 permission (objectSecurityPolicyId 0).  "

<primitive: 2001>  "enter protected mode"
| prot |
prot := System _protectedMode .
^ [
    self _objectSecurityPolicy: anObjectSecurityPolicy
  ] ensure:[
    prot _leaveProtectedMode
  ].

]

{ #category : 'Accessing' }
Object >> objectSecurityPolicyId [

"Returns the objectSecurityPolicyId of the GsObjectSecurityPolicy where the receiver is located.
 If the result is 0, the object has World write permission."
| seg |
seg := self objectSecurityPolicy .
seg ifNotNil:[ ^ seg objectSecurityPolicyId ].
^ 0

]

{ #category : 'Storing and Loading Obsolete' }
Object >> obsoleteInstVar: instVarName value: instVarValue [

"This is a placeholder method with no default behavior.  (It simply returns the
 receiver.)  It can be reimplemented in subclasses to permit user-specified
 operations.

 This message is sent when an instance of a class with the same name as the
 receiver's class is activated and it specifies a named instance variable that
 the receiver does not have.  The instance variable name and value are sent as
 arguments to this method so that the instance may do something with them if it
 desires (such as transform old values into a new format in other instance
 variables)."

]

{ #category : 'Clustering' }
Object >> page [

"This method returns an Integer identifying the disk page on which an object is
 stored.  You can use this method to check your clustering methods for
 correctness.

 The page on which an object is stored may change for any of the following
 reasons:

 1.  A clustering message is sent to the object or to another object on the
     same page, and the current transaction is committed.
 2.  The current transaction is aborted.
 3.  The object is modified, and the current transaction is committed.
 4.  Another object on the page with the object is modified,
     and the current transaction is committed.

 For self-defining objects (SmallIntegers, Characters, Booleans,
 UndefinedObjects), this method returns zero.

 Note that this method may return nil if the receiver has not been committed to
 GemStone, regardless whether the receiver is referenced by a committed object.

 If the receiver is a recently created Symbol, this method may return zero
"

<primitive: 84>

self _primitiveFailed: #page .
self _uncontinuableError

]

{ #category : 'Clustering' }
Object >> pageCreationTime [

"Returns a DateTime that is the approximate beginning of the life of the page
 containing the receiver.

 The result represents the time that the receiver was last modified, clustered,
 moved to a new page by the Garbage Collector Gem, regenerated from a
 transaction log or full backup file during recovery or restore, whichever
 happened last.

 When an object is modified by a session, the resulting pageCreationTime is an
 approximate time of the object creation or modification, and may precede the
 time at which the modification was committed.

 If the receiver is not yet committed and has not yet been assigned to a page,
 returns the current time.

 If the receiver is special, returns the value of the class instance variable
 timeStamp of the receiver's class."

<primitive: 400>
^ self _primitiveFailed: #pageCreationTime

]

{ #category : 'Storing and Loading' }
Object >> passivate [

"Creates a passive description of the receiver that can be activated with an
 activate message to create a new object with the same value as the receiver.

 For large objects or large graphs of objects, consider using this form:

 PassiveObject passivate: anObject toStream: (GsFile openWriteOnServer: aFileName)"

^PassiveObject passivate: self

]

{ #category : 'Error Handling' }
Object >> pause [

"Signals a Halt to the current debugger .
 If execution continued , returns receiver. 
 To signal a Halt to the GCI use 
    Halt signalToGci    "

 Halt new _signalToDebugger 

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol [

"Sends the receiver the unary message indicated by the argument.
 The argument is the selector of the message.  Generates an error if
 the selector is not unary.

 The perform is done in the environment in which this method is compiled."
<primitive: 2004>
^self _perform: aSelectorSymbol asSymbol env: 0 withArguments:  #()

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol env: environmentId [

"Sends the receiver the unary message indicated by the argument.
 The argument is the selector of the message.  Generates an error if
 the selector is not unary.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment.
"

<primitive: 2014>
^self _perform: aSelectorSymbol asSymbol env: environmentId withArguments:  #()

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol env: environmentId withArguments: anArray [

"Sends the receiver the message indicated by the arguments.
 The argument, aSelectorSymbol, is the keyword selector of the message.
 The arguments of the message are the elements of anArray.  Generates an
 error if the number of arguments expected by aSelectorSymbol is not
 the same as the number of elements in anArray.

 anArray must be an instance of Array.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment."

<primitive: 2015>
anArray _validateClass: Array.

"Now just try the primitive again, but send asSymbol to the selector to convert
 it to a Symbol."
^ self _perform: aSelectorSymbol asSymbol env: environmentId
	withArguments: anArray

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol with: anObject [

"Sends the receiver the message indicated by the arguments.  The
 first argument is the keyword or binary selector of the message.  The
 second argument is the argument of the message to be sent.  Generates
 an error if the number of arguments expected by the selector is not 1.

 The perform is done in the environment in which this method is compiled."
<primitive: 2004>

^self _perform: aSelectorSymbol asSymbol env: 0 withArguments: { anObject }

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol with: firstObject with: secondObject [

"Sends the receiver the message indicated by the arguments.  The first
 argument is the keyword selector of the message.  The other arguments
 are the arguments of the message to be sent.  Generates an error if the
 number of arguments expected by the selector is not 2.

 The perform is done in the environment in which this method is compiled."
<primitive: 2004>

^self _perform: aSelectorSymbol asSymbol env: 0
      withArguments: { firstObject . secondObject }

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol with: firstObject with: secondObject with: thirdObject [

"Sends the receiver the message indicated by the arguments.  The first
 argument is the keyword selector of the message.  The other arguments
 are the arguments of the message to be sent.  Generates an error if the
 number of arguments expected by the selector is not 3.

 The perform is done in the environment in which this method is compiled."
<primitive: 2004>

^self _perform: aSelectorSymbol asSymbol env: 0
      withArguments: { firstObject . secondObject . thirdObject }

]

{ #category : 'Message Handling' }
Object >> perform: aSelectorSymbol withArguments: anArray [

"Sends the receiver the message indicated by the arguments.
 The argument, aSelectorSymbol, is the keyword selector of the message.
 The arguments of the message are the elements of anArray.  Generates an
 error if the number of arguments expected by aSelectorSymbol is not
 the same as the number of elements in anArray.

 anArray must be an instance of Array.
 The perform is done in the environment in which this method is compiled."

<primitive: 2005>
anArray _validateClass: Array.

"Now just try the primitive again, but send asSymbol to the selector to convert
 it to a Symbol."
^ self _perform: aSelectorSymbol asSymbol env: 0 withArguments: anArray

]

{ #category : 'Message Handling' }
Object >> performMethod: aGsNMethod [

"Executes the argument as it would be executed by a zero arg send to
 the receiver."

<primitive: 2027>
aGsNMethod _validateClass: GsNMethod .
self _primitiveFailed: #performMethod: args: { aGsNMethod }

]

{ #category : 'Accessing' }
Object >> physicalSize [

"Returns the number of bytes required to represent the receiver in memory.  If
 the receiver is in special format (which implies that its representation is the
 same as its OOP), returns zero.

 This method should be reimplemented for subclasses whose instances are (or may
 be) a composite of component parts which are objects themselves (such as B-tree
 nodes).  Since the composite object cannot be represented independently of its
 components, its physical size should include that of its components.

 However, the component objects of collection (such as an NSC) should not be
 confused with its contents or elements.  Elements or contained objects are in a
 logical relationship with the collection, whereas its components are in a
 physical relationship.  Logically related objects can be represented and stored
 independently."

<primitive: 364>
self _primitiveFailed: #physicalSize

]

{ #category : 'Accessing' }
Object >> physicalSizeOnDisk [

"Returns the number of bytes required to represent the receiver on disk.  If
 the receiver is in special format (which implies that its representation is the
 same as its OOP), returns zero.

 See also Object >> physicalSize"

<primitive: 579>
self _primitiveFailed: #physicalSizeOnDisk

]

{ #category : 'Copying' }
Object >> postCopy [

"Override to do cleanup in new copy"

^self

]

{ #category : 'Formatting' }
Object >> printNonRecursiveOn: aStream [
	"Put a displayable representation of the receiver on the given stream
	 while avoiding recursion from object reference loops."

	self printOn: aStream recursionSet: IdentitySet new.

]

{ #category : 'Formatting' }
Object >> printNonRecursiveRepresentationOn: aStream recursionSet: anIdentitySet [
	"Put a displayable representation of the receiver on the given stream
	 while avoiding recursion from object reference loops.

	 Subclasses should override this method with their own specific printing
	 implementation, analogous to what would be in a #printOn: implementation,
	 but with the exception of differences for preventing recursion.

	 Subclass implementations should call #printNonRecursiveOn:recursionSet:
	 for constituent objects in addition to whatever basic, non-recursive
	 representation they include in this method."

	self printOn: aStream

]

{ #category : 'Formatting' }
Object >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream."

"For classes whose instances can be literals, the result should contain
 formatting information.  For example, the following expression should
 evaluate to true:

 #abc asString = String withAll: '#abc'."

aStream nextPutAll: self asString

]

{ #category : 'Formatting' }
Object >> printOn: aStream recursionSet: anIdentitySet [
	"Put a displayable representation of the receiver on the given stream
	 avoiding recursion from object reference loops."

	(self isInPrintingRecursionSet: anIdentitySet)
		ifTrue: [^self printRecursiveRepresentationOn: aStream].
	anIdentitySet add: self.
	self printNonRecursiveRepresentationOn: aStream recursionSet: anIdentitySet.
	anIdentitySet remove: self

]

{ #category : 'Formatting' }
Object >> printRecursiveRepresentationOn: aStream [
	"Put a displayable representation of the receiver on the given stream.
	 The representation must not recurse. We are here because we already recursing."

	aStream nextPutAll: self class name describeClassName

]

{ #category : 'Formatting' }
Object >> printString [

"Returns a CharacterCollection whose contents are a displayable representation of the
 receiver."

"This method uses the printOn: method to create the String."

| ws str |

str := String new.

ws := PrintStream printingOn: str.

self printOn: ws.
 "contents might have been converted to another subclass of CharacterCollection."
^ ws _collection

]

{ #category : 'Dynamic Smalltalk Instance Variables' }
Object >> removeDynamicInstVar: aSymbol [

  ^ self dynamicInstVarAt: aSymbol put: _remoteNil

]

{ #category : 'GBS support' }
Object >> replicationSpecGbsClampCallback [

  ^ #()   "default spec is an empty array"

]

{ #category : 'Testing' }
Object >> respondsTo: aSelector [

"Returns true if the receiver's class has a method with the given selector
 and false if not."

| sym |
sym := Symbol _existingWithAll: aSelector .
sym ifNil:[ ^ false ].
^ self _respondsTo: sym flags: 16r10000"cache result"

]

{ #category : 'Deprecated' }
Object >> segment [

self deprecated: 'Object>>segment deprecated v3.0. Use #objectSecurityPolicy instead.'.
^self objectSecurityPolicy.

]

{ #category : 'Accessing' }
Object >> segmentId [

self deprecated: 'Object>>segmentId deprecated v3.0. Use #objectSecurityPolicyId instead.'.
^self objectSecurityPolicyId.

]

{ #category : 'Copying' }
Object >> shallowCopy [

"Returns a copy of the receiver with none of its components copied."

<primitive: 885>
self _primitiveFailed: #shallowCopy .
self _uncontinuableError

]

{ #category : 'Error Handling' }
Object >> shouldNotImplement: aSelector [

"Generates an error reporting that the receiver cannot respond to
 aSelector.  This is useful because sometimes a subclass should not
 respond to messages for which it has inherited methods from its
 superclass.  For instance, class Set should not respond to Object | at:.
 Defining Set | at: with a shouldNotImplement error hides
 the ordering information of Set from users of instances of Set."

^ self _error: #rtErrShouldNotImplement args: { aSelector }

]

{ #category : 'Storing and Loading' }
Object >> shouldWriteDynamicInstVar: instVarName [

"Returns whether the given dynamic instance variable should be written out.  The
 default is to write out all dynamic instance variables."
^true

]

{ #category : 'Storing and Loading' }
Object >> shouldWriteInstVar: instVarName [

"Returns whether the given instance variable should be written out.  The
 default is to write out all instance variables."
^true

]

{ #category : 'Accessing' }
Object >> size [

"Returns the number of unnamed instance variables in the receiver."

<primitive: 0>
self _primitiveFailed: #size .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> size: anInteger [

"Changes the varying size of the receiver to anInteger.
 Returns the receiver.

 If anInteger is less than the current size of the receiver, the
 receiver is shrunk accordingly.  If anInteger is greater than the
 current size of the receiver, the receiver is extended and new
 elements are initialized to nil.

 Generates an error if anInteger is not a SmallInteger,
 or if the receiver is not indexable."

<primitive: 603 >

(self class isIndexable not) "not an indexable object"
  ifTrue: [ ^ self _errorNotIndexable].
(anInteger _isInteger)
   ifTrue: [ ^ self _errorIndexOutOfRange: anInteger]
   ifFalse: [ ^ self _errorNonIntegerIndex: anInteger].
self _primitiveFailed: #size: args: { anInteger } .
self _uncontinuableError

]

{ #category : 'Class Membership' }
Object >> species [

"Returns a class similar to, or the same as, the receiver's class which
 can be used for containing derived copies of the receiver."

^self class

]

{ #category : 'Class Membership' }
Object >> speciesForCollect [

"Returns a class, an instance of which should be used as the result of
 collect: or other projections applied to the receiver."

^ self species

]

{ #category : 'Class Membership' }
Object >> speciesForPrint [

"Returns a class similar to, or the same as, the receiver's class which
 can be used for containing printing the receiver."

^ String

]

{ #category : 'Class Membership' }
Object >> speciesForSelect [

"Returns a class similar to, or the same as, the receiver's class which
 can be used for containing derived copies of the receiver for select:
 and reject: queries."

^ self species

]

{ #category : 'Accessing' }
Object >> squeakBasicAt: anIndex [

"Returns the specified varying instVar of an oop format receiver .
 For a byte format receiver, returns the unsigned Integer value of
 the word specified by anIndex,
 using (self class _bytesPerWord) as the size of a word .

 Signals an error if the receiver is not indexable or
 if anIndex is not a SmallInteger or is out of bounds."

<primitive: 1079>

(self class isIndexable) "not an indexable object"
  ifFalse: [ ^ self _errorNotIndexable].
(anIndex _isInteger)
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #squeakBasicAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
Object >> squeakBasicAt: anIndex put: aValue [

"Stores aValue into the specified varying instVar of an oop format receiver .
 For a byte format receiver, aValue must be within range
 consistent with both  self class _bytesPerWord
 and                   self class _signedWords.

 Signals an error if the receiver is not indexable or variant,
 or if anIndex is out of bounds."

<primitive: 1080>
| cls |
(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
cls := self class .
(cls isIndexable) ifFalse: [ ^ self _errorNotIndexable].
((anIndex < 1) | (anIndex > (self size + 1)))
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

(cls isBytes) ifTrue:[  | maxV |
  aValue _validateClass: Integer .
  maxV := (1 bitShift: 8 * cls _bytesPerWord ) - 1 .
  cls _signedWords ifTrue:[
    maxV := maxV bitShift: -1 .
    (aValue < (0 - maxV - 1) or:[ aValue > maxV]) ifTrue:[
       aValue _error: #rtErrArgOutOfRange args:{ 0 . maxV}
    ].
  ] ifFalse:[
    (aValue < 0 or:[ aValue > maxV]) ifTrue:[
       aValue _error: #rtErrArgOutOfRange args:{ 0 . maxV}
    ].
  ].
].
self _primitiveFailed: #squeakBasicAt:put: args: { anIndex . aValue } .
self _uncontinuableError

]

{ #category : 'Accessing' }
Object >> squeakBasicSize [

"Returns the total number of instVars in an oop format receiver .
 For a byte format receiver, returns the size in words
 using (self class _bytesPerWord) as the size of a word ."

<primitive: 1081>

self _primitiveFailed: #basicSize .
self _uncontinuableError

]

{ #category : 'Storing and Loading' }
Object >> storeOn: stream [

"Writes a string that, when evaluated, recreates a copy of the receiver to
 the given stream.  The default is to use PassiveObjects to create the
 description."

| p lf col extra litSize c appendStr idx needVariant |

p := (self passivate) contents.
lf := Character lf.
needVariant := false.

"Format the passive description so it can be filed in properly.
 This has to take into account the max literal size restriction in
 GemStone's compiler.  It still may fail if the content string is
 too large or has too many syntactically significant characters in it."
col := litSize := extra := 0.
1 to: p size do: [:i |
  idx := i+extra.
  c := p at: idx.
  (c == $% and: [col == 0]) ifTrue: [
    p insertAll: ' ' at: idx.
    extra := extra + 1.
    litSize := litSize + 1.
    col := col + 1.
  ]
  ifFalse: [
    (c == $') ifTrue: [
      p insertAll: '''' at: idx.
      extra := extra + 1.
      litSize := litSize + 1.
      col := col + 1.
    ]
    ifFalse: [
      (c == lf) ifTrue: [col := -1]
    ]
  ].
  litSize := litSize + 1.
  col := col + 1.
  litSize > 9999 ifTrue: [
    appendStr := '''; addAll: '''.
    p insertAll: appendStr at: idx.
    extra := extra + appendStr size.
    litSize := 0.
    needVariant := true.
  ].
].

stream nextPutAll: '(PassiveObject newWithContents: '.
needVariant ifTrue: [
  stream nextPutAll: '(String new addAll: '
].
stream nextPutAll: '''';
  nextPutAll: p;
  nextPutAll: ''''.
needVariant ifTrue: [
  stream nextPutAll: '; yourself )' .
].
stream nextPutAll: ') activate'

]

{ #category : 'Class Membership' }
Object >> stringCharSize [
" Returns 1 if receiver's class is subclass of String or ByteArray,
          2 if receiver's class is subclass of   DoubleByteString,
          4 if receiver's class is subclass of   QuadByteString,
          0 otherwise"
  ^ self _stringCharSize bitAnd: 16r7

]

{ #category : 'Error Handling' }
Object >> subclassResponsibility [
	"This provides compatibility with other Smalltalks
	but preserves the GemStone/S approach"

	| meth |
  meth := GsProcess methodAt: 2 .
	self subclassResponsibility: meth selector
]

{ #category : 'Error Handling' }
Object >> subclassResponsibility: aSelector [
"This is used in an abstract superclass to detect a protocol error.
 It generates an error indicating that a concrete subclass should have implemented this method."
| cls |
cls := self class .
^ Error new _number: 2008; reason: #rtErrSubclassResponsibility ;
  messageText: 'A method has been invoked in the abstract superclass ', cls name ,
    ' that was designed to have been overridden in a concrete subclass.  Selector: ',
    aSelector printString ;
  args: { cls . aSelector };
  signal

]

{ #category : 'Tag Management' }
Object >> tagSize [
"Returns the total number of words of dynamic instVars allocated in the
 receiver."

<primitive: 779>
self _primitiveFailed: #tagSize .
self _uncontinuableError

]

{ #category : 'Flow of Control' }
Object >> to: aNumber by: stepValue do: aBlock [

"(Reserved selector.)  Iteratively evaluates the one-argument block aBlock,
 using the block's single argument as the iteration control variable.
 Initially, that control variable is set to the receiver.
 The argument stepValue must be a Number not equal to zero .
 If stepValue is equal to zero, an ArgumentError is signalled.
 aNumber must be a kind of Number.

 The block is evaluated while the control variable is less than or equal to
 aNumber, if stepValue is positive, or greater than or equal to aNumber if
 stepValue is negative  After each evaluation, the control variable is
 modified by stepValue. If the receiver is greater than aNumber and stepValue
 is positive, or less than aNumber when stepValue is negative, the block is
 not evaluated at all. Returns the receiver.

 A method which sends to:by:do: will have a step point generated for the send of
 the to:by:do: and a step point for the loop index increment and test.

 This implementation is used when the method compiler cannot in-line aBlock,
 and is used by perform."

self to: aNumber
     by: stepValue
     do: [:i | aBlock value: i]

]

{ #category : 'Flow of Control' }
Object >> to: aNumber do: aBlock [

"(Reserved selector.)  Iteratively evaluates the one-argument block aBlock,
 using the block's single argument as the iteration control variable.
 Initially, that control variable is set to the receiver.  The block is
 evaluated while the control variable is less than or equal to aNumber (which
 must be a kind of Number).  After each evaluation, the control variable is
 incremented by 1.  If the receiver is greater than aNumber, the block is not
 evaluated at all.  Returns the receiver.

 A method which sends to:do: will have a step point generated for the send of
 the to:do: and a step point for the loop index increment and test.

 This implementation is used when the method compiler cannot in-line aBlock,
 and is used by perform."

self to: aNumber do: [:i | aBlock value: i]


]

{ #category : 'Accessing' }
Object >> trackRead [
  "If receiver is not a special object, and (System objectReadTrackingEnabled == true)
   add the receiver to the sessions read tracking buffer.
   This addition to the read tracking buffer is independent of whether 
     (self objectSecurityPolicy trackReads == true)
   and is independent of whether this method has already been sent to the receiver.
  
   Returns true if the object was added to the read tracking buffer, false otherwise.
  "
  <primitive: 809>
  ^ self _primitiveFailed: #trackRead
]

{ #category : 'Testing' }
Object >> validateIsClass [

"Generates an error if the receiver is not a kind of Class."

(self isKindOf: Class ) ifTrue:[^ self ] .
^ self _error: #rtErrExpectedClass

]

{ #category : 'Testing' }
Object >> validateIsIdentifier [

"Generates an error if the receiver is not a kind of Symbol, or contains
 Characters that are not allowed in a GemStone Smalltalk identifier."

 self _isSymbol ifTrue:[
   self isValidIdentifier ifTrue:[ ^ true ].
 ].
 ( Exception _new: 2149 args: { self } ) signal . "ArgumentError"
]

{ #category : 'Testing' }
Object >> validateIsVariant [

"Generates an error if the receiver is not variant."

self isInvariant ifTrue:[ ^ self _error: #rtErrObjInvariant ] .
^ self

]

{ #category : 'Message Handling' }
Object >> with: anObject perform: aSelectorSymbol env: environmentId [

"Sends the receiver the message indicated by the arguments.  The
 first argument is the keyword or binary selector of the message.  The
 second argument is the argument of the message to be sent.  Generates
 an error if the number of arguments expected by the selector is not 1.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment."

<primitive: 2014>
| sel |
sel := aSelectorSymbol asSymbol .
^self _perform: sel env: environmentId withArguments: { anObject }

]

{ #category : 'Message Handling' }
Object >> with: argOne performMethod: aGsNMethod [

"Executes the aGsNMethod as it would be executed by a one arg send to
 the receiver."

<primitive: 2027>
aGsNMethod _validateClass: GsNMethod .
self _primitiveFailed: #with:performMethod: args: { argOne . aGsNMethod }

]

{ #category : 'Message Handling' }
Object >> with: firstObject with: secondObject perform: aSelectorSymbol env: environmentId [

"Sends the receiver the message indicated by the arguments.  The first
 argument is the keyword selector of the message.  The other arguments
 are the arguments of the message to be sent.  Generates an error if the
 number of arguments expected by the selector is not 2.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment."

<primitive: 2014>

^self _perform: aSelectorSymbol asSymbol env: environmentId
      withArguments: { firstObject . secondObject }

]

{ #category : 'Message Handling' }
Object >> with: firstObject with: secondObject with: thirdObject
  perform: aSelectorSymbol env: environmentId [

"Sends the receiver the message indicated by the arguments.  The first
 argument is the keyword selector of the message.  The other arguments
 are the arguments of the message to be sent.  Generates an error if the
 number of arguments expected by the selector is not 3.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment."

<primitive: 2014>

^self _perform: aSelectorSymbol asSymbol env: environmentId
      withArguments: { firstObject . secondObject . thirdObject }

]

{ #category : 'Message Handling' }
Object >> with: firstObject with: secondObject with: thirdObject with: fourthObject
  perform: aSelectorSymbol env: environmentId [

"Sends the receiver the message indicated by the arguments.  The first
 argument is the keyword selector of the message.  The other arguments
 are the arguments of the message to be sent.  Generates an error if the
 number of arguments expected by the selector is not 4.

 environmentId must be a SmallInteger >= 0 and <= 255,
 specifying a method lookup environment."

<primitive: 2014>

^self _perform: aSelectorSymbol asSymbol env: environmentId
      withArguments: { firstObject . secondObject . thirdObject . fourthObject }

]

{ #category : 'Storing and Loading' }
Object >> writeTo: passiveObj [

"Converts the receiver to its passive form and writes that information on
 passiveObj.  The argument must an instance of PassiveObject."

^self basicWriteTo: passiveObj

]

{ #category : 'Accessing' }
Object >> yourself [

"Configurable optimized selector, see GsNMethod class >> configurableOptimizedSelectors.
 This implementation is only used by #perform. 

 Returns the receiver.  Often useful as the last message in a series of
 cascaded message sends to ensure that the expression returns a known value.
 It is provide for the convenience of sloppy programmers.

 Smalltalk code  code that is written to run as fast as possible
 should never yourself.  A message send and return is at least 25 machine
 instructions ; assigning to or fetching from a method temp is only
 2 machine instructions per assign/fetch in native code.

 Instead of
    ^ String new add:'abc'; yourself
 this will be faster:
    | res |
    (res := String new) add:'abc'.
    ^ res
 "

^self

]
