Extension { #name : 'Notification' }

{ #category : 'Signalling' }
Notification class >> disableSignalling [
  "revert to the default behavior of Notification which is to ignore them."
  System __sessionStateAt: 22 put:  nil

]

{ #category : 'Signalling' }
Notification class >> enableSignalling [
  "enable signalling of Notifications to the GCI client."
  System __sessionStateAt: 22 put: true .

]

{ #category : 'Signalling' }
Notification class >> signallingEnabled [

  "returns true if Notifications will be signalled to the GCI client,
   false otherwise. "
  ^ (System __sessionStateAt: 22) ~~ nil

]

{ #category : 'Private' }
Notification >> _errNumPrefix [

^ '(notification '

]

{ #category : 'Handling' }
Notification >> defaultAction [

  (System __sessionStateAt: 22) ifNotNil:[
    ^ self _signalToDebugger  
  ].
  ^ nil "take no action,  the value 'nil' is returned as the value
      of the message that signaled the exception."

]

{ #category : 'Instance initialization' }
Notification >> initialize [
  gsNumber := ERR_Notification.
  gsResumable := true .
  gsTrappable := true .

]
