Extension { #name : 'MessageNotUnderstood' }

{ #category : 'Accessing - failedMessage' }
MessageNotUnderstood >> arguments [

  ^ gsArgs ifNil:[ #() ].

]

{ #category : 'Accessing - failedMessage' }
MessageNotUnderstood >> arguments: anArray [

  gsArgs := anArray

]

{ #category : 'Instance initialization' }
MessageNotUnderstood >> buildMessageText [
^ self buildMessageText:(
  [
   | str |
    (str := String withAll:'a ') add: receiver class name ;
       add: ' does not understand  ' ; add: selector printString .
    envId ~~ 0 ifTrue:[ str add:' (env ' ; add: envId asString; add: $) ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
 )
]

{ #category : 'Accessing - failedMessage' }
MessageNotUnderstood >> defaultAction [
  "inline AbstractException>>_signalToDebugger for different logic after continue"
  | res |
  gsTrappable ~~ 0 ifTrue:[
    GsProcess _current debugActionBlock ifNotNil:[:blk | ^ blk cull: self ].
  ].
  res := self _signalGciError .
  res == self ifFalse:[ ^ res ].

  ^ receiver perform: selector env: envId withArguments: gsArgs
]

{ #category : 'Accessing - failedMessage' }
MessageNotUnderstood >> environmentId [
  ^ envId

]

{ #category : 'Accessing - compatibility' }
MessageNotUnderstood >> gsArguments [
  | arr |
  arr :=  { receiver . selector }  .
  gsArgs ifNotNil:[:a | arr add: a ] ifNil:[ arr add: #() ].
  ^ arr

]

{ #category : 'Instance initialization' }
MessageNotUnderstood >> initialize [
  gsNumber := ERR_MessageNotUnderstood.
  gsResumable := true .
  gsTrappable := true .
  envId := 0 .

]

{ #category : 'Accessing' }
MessageNotUnderstood >> message: aFailedMessage [

   gsArgs := aFailedMessage arguments .
   selector :=  aFailedMessage selector .

]

{ #category : 'Accessing' }
MessageNotUnderstood >> receiver [
  "Answer the object that was the receiver of the message that failed."

  ^ receiver

]

{ #category : 'Accessing' }
MessageNotUnderstood >> receiver: anObject [
  "Set the object which did not understand the message to be anObject"

  receiver := anObject

]

{ #category : 'Instance initialization' }
MessageNotUnderstood >> receiver: anObject selector: aSymbol args: anArray envId: envIdArg [

  "inline super initialize"
  gsNumber := ERR_MessageNotUnderstood.
  gsResumable := true .
  gsTrappable := true .

  selector := aSymbol .
  envId := envIdArg ifNil:[ 0 ].
  receiver := anObject .
  gsArgs:= anArray .

]
