Extension { #name : 'LanguageDictionary' }

{ #category : 'Accessing' }
LanguageDictionary >> value [

"Returns the value associated with the user's native language Symbol.  That
 Symbol is taken from the user's UserProfile object.  If there is no entry for
 the given language, an error is generated."

|myLanguage "the Symbol representing the user's native language"|

myLanguage := System myUserProfile nativeLanguage.
^ self at: myLanguage
       ifAbsent: [^ self _errorKeyNotFound: myLanguage]

]
