Extension { #name : 'InvariantString' }

{ #category : 'Formatting' }
InvariantString >> _quoted [

"Returns a copy of the receiver enclosed in single-quote marks, with contained
 single-quote Characters doubled.  The copy will be of class String.  This is
 usually done to prepare a storable version of the receiver."

| result c rs sz |

sz := self size.
result := String new: sz + 2.
result at: 1 put: $'.
rs := 1.
1 to: sz do: [:i |
  (c := self at: i) == $' ifTrue: [
    rs := rs + 1.
    result at: rs put: $'.
  ].
  rs := rs + 1.
  result at: rs put: c.
].
rs := rs + 1.
result at: rs put: $'.
^result

]

{ #category : 'Concatenating' }
InvariantString >> , aCharOrCharCollection [
  ^ (String withAll: self) addAll: aCharOrCharCollection; yourself

]

{ #category : 'Formatting' }
InvariantString >> asString [

"Returns a copy of the receiver as an instance of class String."

^ String withAll: self

]

{ #category : 'Formatting' }
InvariantString >> species [
  "(R) Returns a class similar to, or the same as, the receiver's class which
   can be used for containing derived copies of the receiver."

  ^ String

]
