Extension { #name : 'ExecBlock' }

{ #category : 'Accessing' }
ExecBlock class >> _cost [

"cost is not define at the class level, each instance
 has its own cost ."

self shouldNotImplement: #_cost

]

{ #category : 'Storing and Loading' }
ExecBlock class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| src result marker meth o symbolList |

"Returns a new instance of the receiver read from the given PassiveObject"

marker := passiveObj objectPositionMarker.
src := passiveObj readObject.
symbolList := GsCurrentSession currentSession symbolList .
meth := src _compileInContext: (o := Object new) symbolList: symbolList.
result := meth _executeInContext: o.
(result == nil or: [(result _isExecBlock) not]) ifTrue: [
  "error in compiling"
  self _halt: 'Error in recreating a ' , name.
  ^nil
  ]
ifFalse: [
  passiveObj hasRead: result marker: marker.
  ^result
  ]

]

{ #category : 'Decompiling without Sources' }
ExecBlock >> _asSource [

"return a stripped source representation of the block."

"not implemented yet"
self shouldNotImplement: #_asSource

]

{ #category : 'Updating' }
ExecBlock >> _basicSize: anInteger [
  "Disallowed"
  self shouldNotImplement: #_basicSize:

]

{ #category : 'Accessing' }
ExecBlock >> _cost [

"return 1 for simple, 2 for complex , 3 for complex with return to home"

^ (iFields1 bitShift: -44) bitAnd: 16rF

]

{ #category : 'Accessing' }
ExecBlock >> _debugSourceForBlock [
  | str meth |
  "used by topaz  LIST @<blockObjId>"

  meth := self method .
  str := meth _sourceStringForBlock .
  ^ str

]

{ #category : 'Private' }
ExecBlock >> _deepCopyWith: copiedObjDict [

"Private.  Used internally to implement deepCopy."

^ self.

]

{ #category : 'Accessing' }
ExecBlock >> _fileAndLine [
  "Return an Array, { fileName . lineNumber } ,
   or nil if method  does not have that information.
   Smalltalk methods return nil."

  | mth fl |
  mth := self method .
  (fl := mth homeMethod _fileAndLine) ifNotNil:[
    ^ { (fl at: 1) . (fl at: 2) + mth _lineDeltaForBlock }
  ].
  ^ nil

]

{ #category : 'Private' }
ExecBlock >> _gbsTraversalCallback [

"Private.  When GemBuilder Smalltalk traverses an ExecutableBlock, this method
 is called to place the block's source string in the traversal buffer."

^self _sourceString

]

{ #category : 'Repository Conversion' }
ExecBlock >> _iFields1 [

"Private"

^ iFields1

]

{ #category : 'Accessing' }
ExecBlock >> _isCopyingBlock [

^ ((iFields1 bitShift: -46) bitAnd: 1) ~~ 0

]

{ #category : 'Accessing' }
ExecBlock >> _isRubyLambda [

^ iFields1 < 0

]

{ #category : 'Private' }
ExecBlock >> _recursiveSize: arr [
 | terminationSet |
  ((terminationSet := arr at: 1) includes: self) ifTrue:[ ^ self ].
  terminationSet add: self .
 arr at: 2 put:(arr at:2) + self physicalSizeOnDisk .

]

{ #category : 'Private' }
ExecBlock >> _recursiveSizeInMemory: arr [
 | terminationSet |
  self isCommitted ifTrue:[ ^ self ] .
  ((terminationSet := arr at: 1) includes: self) ifTrue:[ ^ self ].
  terminationSet add: self .
 arr at: 2 put:(arr at:2) + self physicalSizeOnDisk .

]

{ #category : 'Private' }
ExecBlock >> _removeEnsure [

"The sender's frame is changed from  ensure:[] to  ensure: nil .
 Returns nil or a terminationBlock that has not been started."
<primitive: 1004>

self _primitiveFailed: #_removeEnsureAtFP:

]

{ #category : 'Accessing' }
ExecBlock >> _selfOffsetInSelf [

"result is zero or a positive zero-based absolute offset"

^ (iFields1 bitShift: -48) bitAnd: 16rF

]

{ #category : 'Modification Tracking' }
ExecBlock >> _setModificationTrackingTo: tracker [

"Private.

 No modification tracking is required for blocks,
 even if they are not invariant."

^self

]

{ #category : 'Accessing' }
ExecBlock >> _sourceString [

"Returns a String that will create a block similar to the receiver when
 the string is compiled.  References to variables in other contexts or
 to the pseudovariable 'self' will not recompile properly if the source
 string is used to create a new block similar to the receiver."

| result |
result := String new.
result addAll: '"This is source for a block.  "
' .

result addAll:' ^ ' ;
       addAll: self method _sourceStringForBlock .
^result

]

{ #category : 'Private' }
ExecBlock >> _sourceStringForExecute [

"Returns a String that will create a block similar to the receiver when
 the string is compiled.  References to variables in other contexts or
 to the pseudovariable 'self' will not recompile properly if the source
 string is used to create a new block similar to the receiver.

 Used by GsExternalSession which further formats the string
"

^ self method _sourceStringForBlock .

]

{ #category : 'Private' }
ExecBlock >> _terminationBlockValue [
  "For use only in the implementation of ensure: "

 <primitive: 2006>  "marks frame with terminationBlockValue_Mark_NIL, always fails"
 | dbgSemaphore |   "installed by GsProcess terminate methods , or nil"
 self value .  
 dbgSemaphore ifNotNil:[:s | s signal ].
 "return value ignored by sender"
]

{ #category : 'Private' }
ExecBlock >> _terminationBlockValue: aSemaphore [
  "For use only in the implementation of GsProcess >> terminate* "

 self value .  
 aSemaphore signal .  
 "If we reach here, the process that was terminating current process 
   was probably itself terminated."
 GsProcess current _finishTermination: TerminateProcess new .  "fix 50754"
 self _uncontinuableError "should not reach here"
]

{ #category : 'Private' }
ExecBlock >> _valueOnUnwind [

"This method should be invoked only from within the virtual machine. Other
 use from a Smalltalk program will corrupt the Smalltalk execution
 stack."

"Used to execute the terminationBlock of an  ensure:"

self value .  "execute the block"
self _gsReturnNoResult "exit from method with no result,
			special selector optimized by compiler"

]

{ #category : 'Debugging Support' }
ExecBlock >> argsAndTemps [

"Returns an Array of Symbols which are the names of arguments and
 temporaries for this block,  not including inner blocks"

^ self method argsAndTemps

]

{ #category : 'Accessing' }
ExecBlock >> argumentCount [

  "Returns a SmallInteger, the number of arguments to the receiver.
   argumentCount is provided to conform to ANSI Smalltalk."
  <primitive: 458>
  self _primitiveFailed: #argumentCount.
  ^0.

]

{ #category : 'Updating' }
ExecBlock >> at: anIndex put: anObj [
  "Disallowed"
  self shouldNotImplement: #at:put:

]

{ #category : 'Clustering' }
ExecBlock >> clusterDepthFirst [

 self cluster ifTrue:[ ^ true ].
 self method cluster .   "cannot use instVarAt to access"
        "other instVars are specials or transient"
 ^ false

]

{ #category : 'Block Evaluation' }
ExecBlock >> cull: anArg [
  "Return the value of the receiver evaluated with 0 or 1 arguments. If the block
   expects 1 argument pass anArg as the value of the argument"

  ^ self argumentCount == 0
    ifTrue: [ self value ]
    ifFalse: [ self value: anArg ]

]

{ #category : 'Block Evaluation' }
ExecBlock >> cull: firstArg cull: secondArg [
  "Return the value of the receiver evaluated with between 0 and 2 arguments,
   discarding arguments not needed by the receiver."

  | nargs |
  (nargs := self argumentCount) < 2 ifTrue:[
     nargs == 1 ifTrue:[ ^ self value: firstArg ].
     ^ self value .
  ].
  ^ self value: firstArg value: secondArg

]

{ #category : 'Block Evaluation' }
ExecBlock >> cull: firstArg cull: secondArg cull: thirdArg [
  "Return the value of the receiver evaluated with between 0 and 3 arguments,
   discarding arguments not needed by the receiver."

  | nargs |
  (nargs := self argumentCount) < 3 ifTrue:[
     nargs == 2 ifTrue:[ ^ self value: firstArg value: secondArg ].
     nargs == 1 ifTrue:[ ^ self value: firstArg ].
     ^ self value .
  ].
  ^ self value: firstArg value: secondArg value: thirdArg

]

{ #category : 'Block Evaluation' }
ExecBlock >> cull: firstArg cull: secondArg cull: thirdArg cull: fourthArg [
  "Return the value of the receiver evaluate with between 0 and 4 arguments,
   discarding arguments not needed by the receiver."

  | nargs |
  (nargs := self argumentCount) <= 2 ifTrue:[
     nargs == 2 ifTrue:[ ^ self value: firstArg value: secondArg ].
     nargs == 1 ifTrue:[ ^ self value: firstArg ].
     ^ self value .
  ].
  nargs == 3 ifTrue:[
     ^ self value: firstArg value: secondArg value: thirdArg .
  ].
  ^ self value: firstArg value: secondArg value: thirdArg value: fourthArg.

]

{ #category : 'Flow of Control' }
ExecBlock >> doWhileFalse: conditionBlock [
  "Evaluate the receiver once, then again as long the value of conditionBlock is false."
  | result |
  [ result := self value.
    conditionBlock value
  ] whileFalse.
  ^ result
]

{ #category : 'Block Evaluation' }
ExecBlock >> ensure: terminationBlock [
"Evaluate the receiver.
 Evaluate terminationBlock after evaluating the receiver,
 or before any return from a block that would return to the sender.
 Returns result of evaluating the receiver.

 terminationBlock must be a zero-arg instance of ExecBlock, otherwise an
 error is generated. "

<primitive: 2017>  "marks frame with ENSURE_Mark_NIL, always fails"
| result |
result := self value .  "execute the receiver"
   "_removeEnsure returns nil if the terminationBlock has already been executed."
self _removeEnsure ifNotNil:[:b | b _terminationBlockValue ].
^ result

]

{ #category : 'Processes - Blue Book' }
ExecBlock >> fork [
  "forks the receiver as a new process at the current scheduling priority"

  ^ GsProcess _forkBlock: self with: #() env: 0 prio: nil

]

{ #category : 'Processes - Blue Book' }
ExecBlock >> forkAt: priority [
  "forks the receiver as a new process at the given priority"

  | proc m |
  priority > (m := ProcessorScheduler highestPriority) ifTrue:[
    OutOfRange new name:'priority' max: m actual: priority ; signal.
  ].
  proc := GsProcess _forkBlock: self with: #() env: 0 prio: priority .
  ^ proc

]

{ #category : 'Processes' }
ExecBlock >> forkAt: priority with: blockArgs [
  "forks the receiver as a new process at the given priority"

  | proc m |
  priority > (m := ProcessorScheduler highestPriority) ifTrue:[
    OutOfRange new name:'priority' max: m actual: priority ; signal.
  ].
  proc := GsProcess _forkBlock: self with: blockArgs env: 0 prio: priority.
  ^ proc

]

{ #category : 'Processes' }
ExecBlock >> forkWith: blockArgs [
  "forks the receiver as a new process at the current scheduling priority"

  ^ GsProcess _forkBlock: self with: blockArgs env: 0 prio: nil

]

{ #category : 'Accessing' }
ExecBlock >> instVarAt: anIndex [

  anIndex == 1 ifTrue:[
    "translate GsNativeCode to GsNMethod if needed"
    ^ self method
  ].
  ^ super instVarAt: anIndex

]

{ #category : 'Accessing' }
ExecBlock >> isSimple [

^ self _cost = 1

]

{ #category : 'Accessing' }
ExecBlock >> lastRubyArgIsStar [
  ^ (iFields1 bitAnd: 16r100) ~~ 0

]

{ #category : 'Accessing' }
ExecBlock >> method [
  "Returns the GsNMethod containing the code for this block.

   A primitive is needed here because the value of the _method instVar
   can be an instance of GsNativeCode for an in-memory block."

<primitive: 492>
self _primitiveFailed: #method .

]

{ #category : 'Repository Conversion' }
ExecBlock >> needsRecompile [

"Returns true if the receiver's block needs recompilation, false otherwise."

^  self method needsRecompile

]

{ #category : 'Processes - Blue Book' }
ExecBlock >> newProcess [
  "creates a new suspended process holding the receiver"

  ^ GsProcess _newForBlock: self with: #() env: 0

]

{ #category : 'Processes - Blue Book' }
ExecBlock >> newProcessWith: argArray [
  "creates a new suspended process holding the receiver to be evaluated
   with the given arguments"

  ^GsProcess _newForBlock: self with: argArray env: 0

]

{ #category : 'Accessing' }
ExecBlock >> noRubyDeclaredArgs [
  ^ (iFields1 bitAnd: 16r200) ~~ 0

]

{ #category : 'Accessing' }
ExecBlock >> numArgs [

  "Returns a SmallInteger, the number of arguments to the receiver.
   numArgs is GemStone legacy API. "
  <primitive: 458>
  self _primitiveFailed: #numArgs .
  ^ 0

]

{ #category : 'Accessing' }
ExecBlock >> numberArgs [

  "Returns a SmallInteger, the number of arguments to the receiver."
  self deprecated: 'ExecBlock>>numberArgs deprecated v3.2; use #argumentCount'.
  ^ self argumentCount

]

{ #category : 'Accessing' }
ExecBlock >> numberTemps [

^ (iFields1 bitShift: -12) bitAnd: 16rFFFF

]

{ #category : 'Updating' }
ExecBlock >> objectSecurityPolicy: anObjectSecurityPolicy [

"Assign the receiver to the given security policy.
 For complex blocks, also changes the security policy for variable contexts."

| vc |
super objectSecurityPolicy: anObjectSecurityPolicy .
(vc := staticLink) ifNotNil:[ vc objectSecurityPolicy: anObjectSecurityPolicy ].

]

{ #category : 'Block Evaluation' }
ExecBlock >> on: exceptionSelector do: handlerBlock [
 "Try to evaluate the receiver, which should be a zero-argument block.
  If an exception occurs and the expression
      exceptionSelector handles: theExceptionInstance
  returns true, then evaluate the one argument block handlerBlock ,
  passing it the exception instance as its argument.

  Two forms are supported directly by the VM, and the 'fast path code'
  below is used.
    (1) on: anException do: handlerBlock
    (2) on: anExceptionSet do: handlerBlock
  A third form is handled by Smalltalk code in the body of this method,
  and for this form only, #handles is sent to anObject to determine
  whether an exception should be handled .
    (3) on: anObject     do: handlerBlock

  anException must be the class Exception  or a subclass thereof ;
  anExceptionSet must be a kind of ExceptionSet;
  handlerBlock must be an instance of ExecBloc otherwise an error is generated.

  For forms 1,2,3 if handlerBlock expects more than 1 argument,
  an error is generated if exception handling attempts to
  invoke that handlerBlock.

  If handlerBlock is invoked to handle an Exception which occurs during
  execution of the receiver and handlerBlock completes normally , then
  the result of handlerBlock (value of last expression in handlerBlock)
  will be the result of the on:do: send .  Other-than-normal
  completion of handlerBlock is available by use of
  Exception's instance methods such as
    #return  #return:  #retry #retryUsing: #resume #resume: #pass #outer
  within handlerBlock

  For forms 1 and 2, when searching for a handlerBlock to handle a signaled Exception,
  the VM uses Behavior>>_subclassOf: semantics . classHistories of the
  class of the signaled Exception and of anException or elements of anExceptionSet
  are ignored.
"

<primitive: 2030> "always fails"
| fastPath | "fastPath := true by primitive if form 1 or 2 detected"
             "fastPath := nil  by primitive if form 3 detected."
fastPath ifNotNil:[ "fast path code"
 ^ self value
].
"Any changes to this method's code before this line may also
 require changes to code in comgen.c conditional on BcPrim_ENTER_onDo .
"
^ self onException: AbstractException do:[:ex |
    (exceptionSelector handles: ex) ifTrue:[
      handlerBlock argumentCount == 0
         ifTrue:[ handlerBlock value ]
        ifFalse:[ handlerBlock value: ex ]
    ] ifFalse:[
      ex pass
    ]
  ]

]

{ #category : 'Block Evaluation - Private' }
ExecBlock >> onException: anException do: handlerBlock [
 "An optimized form of on:do: .  anException may not be any
  object which responds to  handles:

  Private.

  Try to evaluate the receiver, which should be a zero-argument block.
  If an exception occurs which is matched by anExceptionClass,
  evaluate the one argument block handlerBlock , passing it the exception
  instance as its argument.

  These forms are supported:
    (1) on: anException do: handlerBlock
    (2) on: anArray     do: handlerBlock
    (3) on: anExceptionSet do: handlerBlock
    (4) on: anArray     do: anArrayOfBlocks

   This form is not supported
    (5) on: anObject     do: handlerBlock

  anException must be the class Exception  or a subclass thereof ;
  anExceptionSet must be a kind of ExceptionSet;
  anArray must be a kind of Array ;
  handlerBlock must be an instance of ExecBloc ; if any of these
  is violated, the send of on:do: will fail with an error.

  anArrayOfBlocks must be an Array containing instances of ExecBloc ,
  the elements are not checked during the on:do: send , and are only
  checked if they are attempted to be evaluated during exception handling.

  In forms 2,3,4 elements of anArray or anExceptionSet which
  are not a kind of Exception, or an Array containing kinds of Exception,
  will silently have no effect on catching exceptions.

  In form 4, elements of anArray may in turn be Arrays of Exceptions.
  In form 4, the offset of the first element of anArray containing a
  match to a signaled exception defines the offset in anArrayOfBlocks
  at which to find the handlerBlock to invoke.

  For forms 1,2,3 if handlerBlock expects more than 1 argument,
  an error is generated if exception handling attempts to
  invoke that handlerBlock.

  For form 4, elements of anArrayOfBlocks must be instances of ExecBlock,
  otherwise the corresponding entry in anArray will silently have no effect
  on catching exceptions.  If an element of anArrayOfBlocks is an ExecBlock
  taking more than 1 argument, an error is generated if exception
  handling attempts to invoke that block.

  If handlerBlock is invoked to handle an Exception which occurs during
  execution of the receiver and handlerBlock completes normally , then
  the result of handlerBlock (value of last expression in handlerBlock)
  will be the result of the on:do: send .  Other-than-normal
  completion of handlerBlock is available by use of
  Exception's instance methods such as
    #return  #return:  #retry #retryUsing: #resume #resume: #pass #outer
  within handlerBlock

  When searching for a handlerBlock to handle a signaled Exception, the VM
  uses Behavior>>_subclassOf: semantics . classHistories of the
  class of the signaled Exception and of anException or elements of anExceptionSet
  are ignored.
"

<primitive: 2018> "marks frame with Exception_Mark_NIL, always fails"
^ self value

]

{ #category : 'Block Evaluation - Private' }
ExecBlock >> onSynchronous: anExceptionClass do: handlerBlock [

"Same as onException:do: , except that asynchronous Exceptions
 (those exceptions which have trappable==1) will never be handled
 by handlerBlock .

 Allows asynchronous Exceptions to be handled by a higher
 level handler, even if the async Exception would match anExceptionClass.

 Private.
"

<primitive: 2029>
^ self value

]

{ #category : 'Repository Conversion' }
ExecBlock >> recompile [
  "Attempts to recompile the receiver's method assuming it is a simple block
   without references to self."

| src newBlk doitMeth litVars mask |
self needsRecompile ifFalse:[ ^ self "recompile not needed"].
staticLink ifNotNil:[
  Error signal:'cannot recompile a complex block with reference to home VariableContext'.
].
ccallin ifNotNil:[
  Error signal:'cannot recompile a block for a CCallin'.
].
src := self _sourceString .
litVars := self method _literalVariablesForRecompile .
doitMeth := src _compileInContext: nil
       symbolList: GsSession currentSession symbolList
       oldLitVars: litVars environmentId: 0 flags: 4"GCI_COMPILE_evaluateWithoutSelf".
newBlk := doitMeth _executeInContext: nil .
mask := 16r40000ffff0ff . "nTemps, nArgs, isCopying"
(newBlk _iFields1 bitAnd: mask) = (iFields1 bitAnd: mask) ifFalse:[
  Error signal:'in recompile: iFields1 differs, newBlock 16r',
     newBlk _iFields1 asHexString , ' old 16r', iFields1 asHexString .
].
self _unsafeAt: 1 put: newBlk method .  "_method := newBlk method"

]

{ #category : 'Flow of Control' }
ExecBlock >> repeat [
"(Reserved selector.)  Evaluate the receiver repeatedly, ending only if the
 block forces some stopping condition.

 The following is a control structure optimization, not a recursive send."

 [ self value] repeat

]

{ #category : 'Accessing' }
ExecBlock >> selfOffsetInVC [

" Return a one-based offset to self for use as arg to primitiveAt:
  If there is no reference to self in the receiver,
  returns  1 , otherwise returns a value > VAR_CONTEXT_NAMED_SIZE"

^ ((iFields1 bitShift: -28) bitAnd: 16rFFFF) + 1


]

{ #category : 'Accessing' }
ExecBlock >> selfValue [

"return self in an active copy , or nil if self is not referenced."
| aVc ofs |
aVc := staticLink .
aVc ifNotNil:[ | vcOfs |
  vcOfs := self selfOffsetInVC .
  vcOfs > 2"VAR_CONTEXT_NAMED_SIZE" ifTrue:[
    [ aVc parent ~~ nil ] whileTrue:[ aVc := aVc parent ].
    vcOfs > aVc basicSize ifTrue:[ ^ nil ].
    ^ aVc _primitiveAt: vcOfs
  ].
].
ofs := self _selfOffsetInSelf .
ofs ~~ 0 ifTrue:[
  ofs := ofs - 1 .
  ^ self _primitiveAt: ofs .
].
^ nil

]

{ #category : 'Updating' }
ExecBlock >> size: anInteger [
  "Disallowed"
  self shouldNotImplement: #size:

]

{ #category : 'Accessing' }
ExecBlock >> staticLink [

^ staticLink

]

{ #category : 'Flow of Control' }
ExecBlock >> untilFalse [

"(Reserved selector.)  Evaluates the receiver repeatedly until the evaluation's
 result is false.  Return nil.  Generates an error if the receiver is not a
 zero-argument block."

"The following is a control structure optimization, not a recursive send."

^ [self value] untilFalse

]

{ #category : 'Flow of Control' }
ExecBlock >> untilFalse: aBlock [

"(Reserved selector.)  Evaluates the receiver once ,
 and then repeats the evaluation while aBlock returns true .
 Returns nil.  Generates an error if the receiver is not a
 zero-argument block."

"The following is a control structure optimization, not a recursive send."

^ [self value] untilFalse:[ aBlock value]

]

{ #category : 'Flow of Control' }
ExecBlock >> untilTrue [

"(Reserved selector.)  Evaluates the receiver repeatedly until the evaluation's
 result is true.  Return nil.  Generates an error if the receiver is not a
 zero-argument block."

"The following is a control structure optimization, not a recursive send."

^ [self value] untilTrue

]

{ #category : 'Flow of Control' }
ExecBlock >> untilTrue: aBlock [

"(Reserved selector.)  Evaluates the receiver once ,
 and then repeats the evaluation while aBlock returns false .
 Returns nil.  Generates an error if the receiver is not a
 zero-argument block."

"The following is a control structure optimization, not a recursive send."

^ [self value] untilTrue:[ aBlock value]

]

{ #category : 'Block Evaluation' }
ExecBlock >> value [

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated.

 #value is optimized by the compiler.
 This method is in the image for use by perform: and for
 failure paths from the optimized bytecode "

^ self valueWithArguments: #()

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: anObject [

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated.

 #value: is optimized by the compiler.
 This method is in the image for use by perform: and for
 failure paths from the optimized bytecode "


^ self valueWithArguments: { anObject }

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: anArg on: anExceptionClass do: handlerBlock [
  "Evaluate the one-argument receiver with the specified on:do: .
   Useful for avoiding complex blocks in the sender of value:on:do: "

  ^ [ self value: anArg ] onException: anExceptionClass do: handlerBlock

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: anArg onSynchronous: anExceptionClass do: handlerBlock [
  "Evaluate the one-argument receiver with the specified onSynchronous:do: .
   Useful for avoiding complex blocks in the sender of value:onSynchronous:do: "

  ^ [ self value: anArg ] onSynchronous: anExceptionClass do: handlerBlock

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: firstObject value: secondObject [

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated.

 #value:value: is optimized by the compiler.
 This method is in the image for use by perform: and for
 failure paths from the optimized bytecode "

^ self valueWithArguments: {  firstObject . secondObject }

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: firstObject value: secondObject value: thirdObject [

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated.

 #value:value:value: is optimized by the compiler.
 This method is in the image for use by perform: and for
 failure paths from the optimized bytecode "

^ self valueWithArguments: {  firstObject . secondObject . thirdObject }

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: first value: second value: third value: fourth [

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated.

 #value:value:value:value: is optimized by the compiler.
 This method is in the image for use by perform: and for
 failure paths from the optimized bytecode "

^ self valueWithArguments: {  first . second . third . fourth }

]

{ #category : 'Block Evaluation' }
ExecBlock >> value: first value: second value: third value: fourth value: fifth [

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated.

 #value:value:value:value:value: is optimized by the compiler.
 This method is in the image for use by perform: and for
 failure paths from the optimized bytecode "

^ self valueWithArguments: {  first . second . third . fourth . fifth }

]

{ #category : 'Block Evaluation' }
ExecBlock >> valueWithArguments: argList [

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

<primitive: 2003>  "compiler emits special bytecode"
^ self _primitiveFailed: #valueWithArguments: args: { argList }

]

{ #category : 'Debugging Support' }
ExecBlock >> vcTempNames [

"Returns an Array of Symbols which are the names for the temps
 defined in the receiver's VariableContext.  The ordering of names
 in the result matches ordering of temps in the varying instVars
 of the receiver."

| vc allNames allOfs res vcNamedSize myMeth lastTmpOfs |
vc := staticLink .
vc == nil ifTrue:[ ^ #() ].
vcNamedSize := vc class instSize .
allNames := self argsAndTemps .
myMeth := self method .
allOfs := myMeth _argsAndTempsOffsets .
res := Array new: vc size .
lastTmpOfs := allOfs size - myMeth _numCopyingBlockArgs .
self argumentCount + 1 to: lastTmpOfs do:[:j| | anOfs ofs |
  anOfs := allOfs at: j .
  anOfs > 0 ifTrue:[
    (anOfs bitAnd: 16rFF) == 0 ifTrue:[ "lexLevel == 0"
      ofs := anOfs bitShift: -8 .
      res at: (ofs + 1 - vcNamedSize) put:( allNames at: j) .
    ] "else temp is defined in a parent block"
  ] "else temp is on stack"
].
^ res

]

{ #category : 'Flow of Control' }
ExecBlock >> whileFalse [
"(Reserved selector.)  Evaluate the receiver once and then repeatedly as long
 as the value returned by the evaluation is false.

 The following is a control structure optimization, not a recursive send."

^ [ self value] whileFalse

]

{ #category : 'Flow of Control' }
ExecBlock >> whileFalse: aBlock [

"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
 while the receiver evaluates to false.  Return nil.  Generates an error if the
 receiver is not a zero-argument block."

"The following is a control structure optimization, not a recursive send."

^ [self value] whileFalse:[
    aBlock _isExecBlock ifFalse:[ ArgumentError signal:'expected a block'].
    aBlock value
  ]

]

{ #category : 'Flow of Control' }
ExecBlock >> whileTrue [
"(Reserved selector.)  Evaluate the receiver once and then repeatedly as long
 as the value returned by the evaluation is true.

 The following is a control structure optimization, not a recursive send."

^ [ self value] whileTrue

]

{ #category : 'Flow of Control' }
ExecBlock >> whileTrue: aBlock [

"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
 while the receiver evaluates to true.  Return nil.  Generates an error if the
 receiver is not a zero-argument block."

"The following is a control structure optimization, not a recursive send."

^ [self value] whileTrue: [
    aBlock _isExecBlock ifFalse:[ ArgumentError signal:'expected a block'].
    aBlock value
  ]

]

{ #category : 'Storing and Loading' }
ExecBlock >> writeTo: aPassiveObject [

"Converts the receiver to its passive form and writes that information on
 aPassiveObject.

 Simple blocks can usually be passivated and then reactivated.  Complex blocks
 can be passivated but may have to be massaged to be reactivated.  References
 to 'self' in complex blocks will resolve to an instance of Object when the
 block is activated, and any arguments or temporaries from enclosing scopes
 will be nil."

aPassiveObject writeClass: self class.
aPassiveObject writeObject: self _sourceString; cr

]
