Extension { #name : 'CompileWarning' }

{ #category : 'Instance creation' }
CompileWarning class >> signal: aString method: aMethod [
  | ex |
  (ex := self new) args: { aString . aMethod } ;
     signal

]

{ #category : 'Instance initialization' }
CompileWarning >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    str := String new .
    gsArgs ifNotNil:[:d| | meth |
      meth := d at: 2 .
      str add:( d at: 1) ; add: ' in ' ;
          add: meth inClass name ;
          add: ' >> ' ; 
          add: meth selector .
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
CompileWarning >> initialize [
  gsNumber := ERR_CompileWarning .
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Accessing' }
CompileWarning >> method [
  ^ gsArgs at: 2

]

{ #category : 'Accessing' }
CompileWarning >> warningString [
  ^ gsArgs at: 1

]
