Extension { #name : 'ClientForwarderSend' }

{ #category : 'Handling' }
ClientForwarderSend >> defaultAction [

"Return an error to the controlling debugger or GCI client. 
 If to GCI, stack is saved and available as an argument to the GCI error struct.

 instVars of the receiver go into the GCI error struct as follows
 self.receiver -->  GciErrSType.args[0]
 self.clientObj --> GciErrSType.args[1]
 self.selector -->  GciErrSType.args[2]
 self.gsArgs -->    GciErrSType.args[3]   (instVar defined in AbstractException)
"

^ self _signalToDebugger 

]

{ #category : 'Instance initialization' }
ClientForwarderSend >> initialize [
  gsNumber := ERR_ClientForwarderSend.
  gsResumable := true .
  gsTrappable := false . "goes to the controlling debugger or GCI client"

]

{ #category : 'Instance initialization' }
ClientForwarderSend >> receiver: aSelf clientObj: aClientObj selector: aSymbol args: anArray [
  receiver := aSelf .
  clientObj := aClientObj .
  selector := aSymbol .
  gsArgs := anArray

]
