Extension { #name : 'Character' }

{ #category : 'Deprecated Character Data Table' }
Character class >> _dispatch: dispatchTable index: indexTable category: categoryTable
    main: mainTable titleCase: titleCaseTable [

" Copy byte array tables to internal C tables for String comparisions

  dispatchTable , indexTable
     are ByteArrays containing big-endian 16 bit values

  mainTable, titleCaseTable
     are ByteArrays containing pairs of big-endian 16 bit values

  categoryTable is a ByteArrays containing 8 bit values .

  if dispatchTable == nil,  then other arguments are ignored, and
  the C tables are reset to the hardcoded defaults defined when
  the VM executable/shared library was built .
"

<primitive: 643>
self _primitiveFailed: #_dispatch:index:category:main:titleCase:
     args: { dispatchTable . indexTable .
             categoryTable . mainTable . titleCaseTable }

]

{ #category : 'Deprecated Character Data Table' }
Character class >> _dumpCharTables [

" Dump contents of character tables to stdout  "

   <primitive: 645>
self _primitiveFailed: #_dumpCharTables

]

{ #category : 'Deprecated Character Data Table' }
Character class >> _fetchCharTables [

" Fetch contents of character tables "

<primitive: 644>
self _primitiveFailed: #_fetchCharTables

]

{ #category : 'Deprecated Character Data Table' }
Character class >> _loadCharTables [

"Load the character data tables recorded in
( Globals at: #CharacterDataTables ) into the session's internal memory.

This data should be in the form of an Array containing 5 ByteArrays.

See Character>>installCharTables for information on how to configure this. "

| table dispatchBA indexBA categoryBA mainBA titleCaseBA |
self deprecated:  'Character class>>_loadCharTables Deprecated as of GS/64 3.1, use Unicode classes' .

table :=  Globals at: #CharacterDataTables otherwise: nil .
table ifNil:[ ^ false ].

dispatchBA := table at: 1.
indexBA := table at: 2.
categoryBA := table at: 3.
mainBA := table at: 4.
titleCaseBA := table at: 5.

self _dispatch: dispatchBA index: indexBA category: categoryBA
      main: mainBA titleCase: titleCaseBA.

^ table

]

{ #category : 'Deprecated Character Data Table' }
Character class >> _resetCharTablesToCDefaults [

" Resets the character data tables in the VM to the hardcoded defaults
  defined when the VM executable/shared library was built .
  This defaults are the same as those used at session initialization if
   (Globals at: #CharacterDataTables otherwise: nil) == nil
"

self deprecated:  'Character class>>_resetCharTablesToCDefaults  Deprecated as of GS/64 3.1, use Unicode classes' .

self _dispatch: nil index: nil category: nil main: nil titleCase: nil

]

{ #category : 'Deprecated Character Data Table' }
Character class >> activateCharTablesFromFile: file [

"Install #CharacterDataTables from the passivated contents of a file.

Don't forget to commit to make the change permanent.

You must be SystemUser to execute this method.

See passivateCharTablesToFile: for the other side of this mechanism.

Use $GEMSTONE/goodies/CharacterTableUnicode.dat
to enable full 16-bit Unicode support.

See $GEMSTONE/goodies/UnicodeData.gs for
more info on Unicode Standards support.
"
self deprecated:  'Character class>>activateCharTablesFromFile: Deprecated as of GS/64 3.1, use Unicode classes' .

" Check that we're SystemUser "
System myUserProfile userId = 'SystemUser' ifFalse: [
   self _halt: 'Only SystemUser may execute this method' ].

(Globals at: #CharacterDataTables ifAbsent: [
    Globals at: #CharacterDataTables put: nil ] ).
Globals at: #CharacterDataTables put:
    ( PassiveObject fromServerTextFile: file ) activate.
^ self _loadCharTables

]

{ #category : 'Unicode' }
Character class >> allUnicodeCodePointsDo: aBlock [
  "Executes the one argument block aBlock for each legal Unicode codepoint."
  0 to: 16rD7FF do:[:n | aBlock value: n ].
  16rE000 to: 16r10FFFF do:[:n| aBlock value: n].

]

{ #category : 'Deprecated Character Data Table' }
Character class >> categoryId: aSymbol [

"Given a character category symbol, return the numeric id.  Note the
 indexes are not the same as used in ICU.

See Character>>categorySymbol: for symbol meanings. "
self deprecated:  'Charater class>>categoryId: Deprecated as of GS/64 3.1, use Unicode classes' .

^ #( #Lu #Ll #Lt #Lm #Lo #Mn #Mc #Me #Nd #Nl #No #Pc #Pd #Ps
   #Pe #Pi #Pf #Po #Sm #Sc #Sk #So #Zs #Zl #Zp #Cc #Cf #Cs #Co #Cn)
   indexOf: aSymbol

]

{ #category : 'Deprecated Character Data Table' }
Character class >> categorySymbol: id [

"Given a character category id, return the category symbol. Note the ids are
 not the same as used in ICU.

Category symbols are taken from the Unicode Standard:

#Lu  - Letter, Uppercase
#Ll - Letter, Lowercase
#Lt  - Letter, Titlecase
#Lm - Letter, Modifier
#Lo - Letter, Other
#Mn - Mark, Nonspacing
#Mc - Mark, Spacing Combining
#Me - Mark, Enclosing
#Nd - Number, Decimal Digit
#Nl - Number, Letter
#No - Number, Other
#Pc - Punctuation, Connector
#Pd - Punctuation, Dash
#Ps - Punctuation, Open/Start
#Pe - Punctuation, Close/End
#Pi - Punctuation, Initial Quote
#Pf - Punctuation, Final Quote
#Po - Punctuation, Other
#Sm - Symbol, Math
#Sc - Symbol, Currency
#Sk - Symbol, Modifier
#So - Symbol, Other
#Zs - Separator, Space
#Zl - Separator, Line
#Zp - Separator, Paragraph
#Cc - Other, Control
#Cf - Other, Format
#Cs - Other, Surrogate
#Co - Other, Private Use
#Cn - Other, Not Assigned
"
self deprecated:  'Character class>>categorySymbol: Deprecated as of GS/64 3.1, use Unicode classes' .

^ #( #Lu #Ll #Lt #Lm #Lo #Mn #Mc #Me #Nd #Nl #No #Pc #Pd #Ps
   #Pe #Pi #Pf #Po #Sm #Sc #Sk #So #Zs #Zl #Zp #Cc #Cf #Cs #Co #Cn)
   at: id

]

{ #category : 'Deprecated Character Data Table' }
Character class >> charTables [

" Reconstruct structured character data tables from the raw byte arrays
  stored in Globals at: #CharacterDataTables

Returns:

An Array of elements, arranged according to collate order,
each element an Array of 4 or 5 entries:

1.  The character for this entry.
2.  The symbolic character category code.
3.  Uppercase character ( if a letter ) / Numerator ( if numeric ).
4.  Lowercase character ( if a letter ) / Denominator ( if numeric/fraction ).
5.  (Optional)  Titlecase character ( if a letter )

"

| tables result dispatchBA indexBA categoryBA mainBA titleCaseBA
  titleCaseData titleCaseEntry size entry category id  chCls |
self deprecated:  'Character class>>charTables Deprecated as of GS/64 3.1, use Unicode classes' .

result := Array new.
tables := Globals at: #CharacterDataTables otherwise: nil .
tables ifNil:[ tables := Character _fetchCharTables ].

dispatchBA := tables at: 1.
indexBA := tables at: 2.
categoryBA := tables at: 3.
mainBA := tables at: 4.
titleCaseBA := tables at: 5.

" Construct TitleCase Data for later use.. "
titleCaseData := { } .
0 to: ( titleCaseBA size / 8 - 1 ) do: [ :i |
   entry := { } .
   entry add: ( titleCaseBA unsigned32At: ( i * 8 + 1 )).
   entry add: ( titleCaseBA unsigned32At: ( i * 8 + 5 )).
   titleCaseData add: entry ].

" Now reconstruct character data table "
size := mainBA size / 8.
chCls := Character .
0 to: size - 1 do: [ :i |
   entry := { } .
   id :=  ( indexBA unsigned32At: ( i * 4 + 1 )).
   entry add: ( chCls withValue: id ).
   category := self categorySymbol: ( categoryBA unsigned8At: ( i + 1 )).
   entry add: category.
   ( #( #Lu #Ll #Lt ) includes: category )
      ifTrue: [
         entry add:
            ( chCls withValue: ( mainBA unsigned32At: ( i * 8 + 1 ))).
         entry add:
            ( chCls withValue: ( mainBA unsigned32At: ( i * 8 + 5 ))).
         titleCaseEntry :=
            titleCaseData detect: [ :x | ( x at: 1 ) = id ] ifNone: [ nil ].
         ( titleCaseEntry == nil ) ifFalse: [
            entry add: ( chCls withValue: ( titleCaseEntry at: 2 )) ] ]
      ifFalse: [
         entry add: ( mainBA unsigned32At: ( i * 8 + 1 )).
         entry add: ( mainBA unsigned32At: ( i * 8 + 5 )) ].
   result add: entry ].
^ result

]

{ #category : 'Instance Creation' }
Character class >> codePoint: anInteger [

"Returns the Character with the specified value.
 Allowable range is 0 <= anInteger <= 16r10FFFF "

<primitive: 72>

anInteger _validateClass: SmallInteger.
OutOfRange new name:'anInteger' min: 0 max: 16r10FFFF actual: anInteger ; signal

]

{ #category : 'Printable Characters' }
Character class >> digits [

"Returns an InvariantArray containing Characters representing
 digits 0 through 9."

^#($0 $1 $2 $3 $4 $5 $6 $7 $8 $9)

]

{ #category : 'Instance Creation' }
Character class >> fromStream: aStream [

"Returns the next Character in the stream aStream."

self _checkReadStream: aStream forClass: String.
^ aStream next.

]

{ #category : 'Instance Creation' }
Character class >> fromString: aString [

"If aString is a one-Character String, returns the Character in aString.
 Otherwise, generates an error."

aString _validateClass: String.
(aString size == 1)
  ifTrue: [ ^ aString at: 1 ]
  ifFalse: [ self _errIncorrectFormat: aString ]

]

{ #category : 'Deprecated Character Data Table' }
Character class >> installCharTables: table [

"Converts a structured character data table into appropriately formated
byte arrays and then places them into Globals at: #CharacterDataTables
for use in this and subsequent sessions.  This operation *does not*
do a commit -- follow up with a commit if you wish to make this change
valid for subsequent sessions.

WARNINGS:

Installing incorrectly formatted character table data will break
character/string operations, including command line processing to a point
where the system will be impossible to use.  In this case, clear the
installation by doing the following:

1.  From the OS, set the host machine environmental parameter
    GS_DISABLE_CHARACTER_TABLE_LOAD to some value
    (it's the presence of this parameter that enables the mechanism).

2.  Login a new topaz session

3.  Execute Globals at: #CharacterDataTables put: nil.

4.  Commit

Note that changing the collation order of characters in new
CharacterDataTables will break any indexes that are keyed off of
Strings/DoubleByteStrings.  Before changing the tables, remove all such
indexes, install the new tables, and then reconstruct the indexes.

You must be SystemUser to execute this method.

Table Format:

An Array of elements, arranged according to character collate order,
each element an Array of 4 or 5 entries:

1.  The character for this entry.
2.  The symbolic character category code.
    See Character>>categorySymbol: for a list.
3.  Uppercase character ( if a letter ) / Numerator ( if numeric ).
4.  Lowercase character ( if a letter ) / Denominator ( if numeric/fraction ).
5.  (Optional)  Titlecase character

"

| tables dispatchBA indexBA categoryBA mainBA titleCaseBA
  mainSize dispatchSize titleCaseSize titleCaseIndex entry item id  |
self deprecated:  'Character class>>installCharTables:  Deprecated as of GS/64 3.1, use Unicode classes' .

" Check that we're SystemUser "
System myUserProfile userId = 'SystemUser' ifFalse: [
   self _halt:'Only SystemUser may execute this method' ].

" Generate the ByteArrays "
mainSize := table size.
dispatchSize := 0.
titleCaseSize := 0.
indexBA := ByteArray new: ( mainSize * 4 ).
categoryBA := ByteArray new: mainSize.
mainBA := ByteArray new: ( mainSize * 8 ).
" First pass: do most of the work,
  get info on sizes for dispatch and titleCase tables "
0 to: mainSize - 1 do: [ :i |
   entry := table at: i + 1.
   id := ( entry at: 1 ) codePoint.
   ( id > dispatchSize ) ifTrue: [ dispatchSize := id ].
   ( entry size > 4 ) ifTrue: [ titleCaseSize := titleCaseSize + 1 ].
   indexBA unsigned32At: ( i * 4 + 1 ) put: id.
   categoryBA unsigned8At: ( i + 1 ) put:
      ( Character categoryId: ( entry at: 2 ) ).
   ((item := entry at: 3) == nil) ifFalse: [
      ( item isKindOf: Character )
         ifTrue: [ mainBA unsigned32At: ( i * 8 + 1 ) put: item codePoint ]
         ifFalse: [ mainBA signed32At: ( i * 8 + 1 ) put: item ] ].
   ((item := entry at: 4) == nil) ifFalse: [
      ( item isKindOf: Character )
         ifTrue: [ mainBA unsigned32At: ( i * 8 + 5 ) put: item codePoint ]
         ifFalse: [ mainBA signed32At: ( i * 8 + 5 ) put: item ] ] ].

" Second pass: fill in dispatch and titleCase tables "
dispatchSize := dispatchSize + 1.
dispatchBA := ByteArray new: ( dispatchSize * 4 ).
titleCaseBA := ByteArray new: ( titleCaseSize * 8 ).
titleCaseIndex := 0.
1 to: mainSize do: [ :i |
   entry := table at: i.
   id := ( entry at: 1 ) codePoint.
   dispatchBA unsigned32At: ( id * 4 + 1 ) put: ( i - 1 ).
   ( entry size > 4 ) ifTrue: [
      titleCaseBA unsigned32At:
         ( titleCaseIndex * 8 + 1 ) put:  id.
      titleCaseBA unsigned32At:
         ( titleCaseIndex * 8 + 5 ) put: ( entry at: 5 ) codePoint.
      titleCaseIndex := titleCaseIndex + 1 ] ].

" Setup the table array "
tables := Array new: 5.
tables at: 1 put: dispatchBA.
tables at: 2 put: indexBA.
tables at: 3 put: categoryBA.
tables at: 4 put: mainBA.
tables at: 5 put: titleCaseBA.

" Install on #CharacterDataTables "
(Globals at: #CharacterDataTables ifAbsent: [
   Globals at: #CharacterDataTables put: nil ] ).
Globals at: #CharacterDataTables put: tables.

" Now install in this session's internal tables "
self _dispatch: dispatchBA index: indexBA category: categoryBA
   main: mainBA titleCase: titleCaseBA.

^ tables

]

{ #category : 'Non-Printable Characters' }
Character class >> lfValue [

"Returns value of the ASCII line-feed Character."

^  10

]

{ #category : 'Printable Characters' }
Character class >> lowercaseRoman [

"Returns an InvariantArray containing all lower-case Roman ASCII
 characters in alphabetic order."

^#($a $b $c $d $e $f $g $h $i $j $k $l $m $n $o $p $q $r $s $t $u
   $v $w $x $y $z)

]

{ #category : 'Instance Creation' }
Character class >> maximumCodePoint [
  "Returns the maximum code point per Unicode standards"

  ^ 16r10FFFF

]

{ #category : 'Instance Creation' }
Character class >> new [

"Disallowed.  You may not create new instances of Character."

self shouldNotImplement: #new

]

{ #category : 'Deprecated Character Data Table' }
Character class >> passivateCharTablesToFile: file [

"Write the passivated contents of the #CharacterDataTables (if present)
to a file.

Useful for efficiently porting the CharacterDataTable to another stone.
See activateCharTablesFromFile: for the other side of this mechanism. "

self deprecated:  'Character class>>passivateCharTablesToFile: Deprecated as of GS/64 3.1, use Unicode classes' .

(Globals at: #CharacterDataTables ifAbsent: [ ^nil ] )
   passivate toServerTextFile: file

]

{ #category : 'Non-Printable Characters' }
Character class >> space [

"Returns the ASCII space Character."
"recompiled in charact2.gs"

^ $  .

]

{ #category : 'Printable Characters' }
Character class >> uppercaseRoman [

"Returns an InvariantArray containing all upper-case Roman ASCII
 characters in alphabetic order."

^#($A $B $C $D $E $F $G $H $I $J $K $L $M $N $O $P $Q $R $S $T $U
   $V $W $X $Y $Z)

]

{ #category : 'Instance Creation' }
Character class >> withSortValue: anInt [

"Will be deprecated.
 Legacy method returning character at a particular point in collation,
 not Unicode compatible"

<primitive: 546>
self _primitiveFailed: #withSortValue: args: { anInt }

]

{ #category : 'Instance Creation' }
Character class >> withValue: anInteger [

"Returns the Character with the specified value.
 Allowable range is 0 <= anInteger <= 16r10FFFF "

<primitive: 72>

anInteger _validateClass: SmallInteger.
OutOfRange new name:'anInteger' min: 0 max: 16r10FFFF actual: anInteger ; signal

]

{ #category : 'Private' }
Character >> __numericValue [
"Returns the numeric value (if one exists) for this character, or nil,
 using the legacy character tables."
<primitive: 641>
self _primitiveFailed: #__numericValue

]

{ #category : 'Private' }
Character >> _asSource [

"Private."

^ self printString

]

{ #category : 'Private' }
Character >> _category [

"Returns the numeric category id for this character.  This numeric
 index is specific to the GemStone legacy implementation, and is not
 the same as the ICU index from unicodeType. Use with _categoryAsSymbol
 to determine the correct unicode category. Will not return correct
 results for Characters over 255 unless deprecated Character data tables
 are installed."

<primitive: 640>
self _primitiveFailed: #_category

]

{ #category : 'Private' }
Character >> _categoryAsSymbol [

" Returns the category symbol for this character.

Category symbols are taken from the Unicode Standard. Note that
the index of these is not the same as ICU.

#Lu  - Letter, Uppercase
#Ll - Letter, Lowercase
#Lt  - Letter, Titlecase
#Lm - Letter, Modifier
#Lo - Letter, Other
#Mn - Mark, Nonspacing
#Mc - Mark, Spacing Combining
#Me - Mark, Enclosing
#Nd - Number, Decimal Digit
#Nl - Number, Letter
#No - Number, Other
#Pc - Punctuation, Connector
#Pd - Punctuation, Dash
#Ps - Punctuation, Open/Start
#Pe - Punctuation, Close/End
#Pi - Punctuation, Initial Quote
#Pf - Punctuation, Final Quote
#Po - Punctuation, Other
#Sm - Symbol, Math
#Sc - Symbol, Currency
#Sk - Symbol, Modifier
#So - Symbol, Other
#Zs - Separator, Space
#Zl - Separator, Line
#Zp - Separator, Paragraph
#Cc - Other, Control
#Cf - Other, Format
#Cs - Other, Surrogate
#Co - Other, Private Use
#Cn - Other, Not Assigned

"

^ #( #Lu #Ll #Lt #Lm #Lo #Mn #Mc #Me #Nd #Nl #No #Pc #Pd #Ps
   #Pe #Pi #Pf #Po #Sm #Sc #Sk #So #Zs #Zl #Zp #Cc #Cf #Cs #Co #Cn)
at: self _category

]

{ #category : 'New Indexing Comparison' }
Character >> _classSortOrdinal [

^ 30

]

{ #category : 'Indexing Support' }
Character >> _idxBasicCanCompareWithClass: aClass [
  "Returns true if the receiver may be inserted into a basic BtreeNode whose
   #lastElementClass is <aClass> (see RangeEqualityIndex class>>isBasicClass:)."

  (super _idxBasicCanCompareWithClass: aClass)
    ifTrue: [ ^ true ].
  ^ aClass == Character

]

{ #category : 'Private' }
Character >> _isPasswordSymbol [

| cat |
cat := self _category .
^ (cat >= 12) and:[ cat <= 21 ]

]

{ #category : 'Private' }
Character >> _numericValue [

"Legacy method.
 Returns the numeric value (if one exists) for this character, or nil,
 using the legacy character tables."
self deprecated:  'Character _numericValue  Deprecated as of GS/64 3.2, use numericValue'.
^ self __numericValue

]

{ #category : 'Private' }
Character >> _type [

"Returns 1 for alpha, 2 for digit, and 3 for special."

| cat |
cat := self _category .
cat == 9 ifTrue: [ ^ 2].
cat < 4 ifTrue: [ ^ 1].
^ 3

]

{ #category : 'Private' }
Character >> _typeAsSymbol [

"Private."

^ #( #alpha #digit #special ) at: self _type

]

{ #category : 'Unicode' }
Character >> _unicodeStatus: opcode [
"
    opcode  libicu function
    1      u_isUAlphabetic(ch) returns a Boolean
    2      u_isULowercase(ch)  returns a Boolean
    3      u_isUUppercase(ch)  returns a Boolean
    4      u_isdigit(ch)    returns a Boolean
    5      u_isalpha(ch)    returns a Boolean
    6      u_isalnum(ch)    returns a Boolean
    7      u_isxdigit(ch)   returns a Boolean
    8      u_ispunct(ch)    returns a Boolean
    9      u_isgraph(ch)    returns a Boolean
    10     u_isblank(ch)    returns a Boolean
    11     u_isdefined(ch)  returns a Boolean
    12     u_isspace(ch)    returns a Boolean
    13     u_isJavaSpaceChar(ch) returns a Boolean
    14     u_isWhiteSpace(ch)    returns a Boolean
    15     u_iscntrl(ch)         returns a Boolean
    16     u_isISOControl(ch)    returns a Boolean
    17     u_isprint(ch)         returns a Boolean
    18     u_isbase(ch)          returns a Boolean
    19     u_isMirrored(ch)  returns a Boolean
    20     u_charDigitValue  returns a SmallInteger
    21     u_charMirror      returns a Character
    22     u_foldCase        returns a Character
    23     u_charType        returns a SmallInteger
    24     u_isupper        returns a Boolean
    25     u_islower        returns a Boolean
    26     u_istitle        returns a Boolean
    27     u_getIntPropertyValue(c, UCHAR_NUMERIC_TYPE), returns a Boolean
    28     u_getNumericValue  returns a Float, SmallDouble or nil
    29     u_isISOControl(ch) || (ch == 32) || (ch == 160)   smalltalk isSeparator
    30     symbolic name of u_charType(ch), returns a Symbol
"
<primitive: 965>
opcode _validateClass: SmallInteger .
self _primitiveFailed: #_unicodeStatus: args: { opcode }

]

{ #category : 'Comparisons' }
Character >> < aCharacter [

"Legacy method.
 Returns true if the Legacy sort order of the receiver is
 less than that of aCharacter."

<primitive: 61>

aCharacter _validateClass: Character.
^  self _primitiveFailed: #< args: { aCharacter }.

]

{ #category : 'Comparisons' }
Character >> <= aCharacter [

"Legacy method.
 Returns true if the Legacy sort order of the receiver is
 less than or equal to that of aCharacter."

<primitive: 181>

aCharacter _validateClass: Character.
^ self _primitiveFailed: #<= args: { aCharacter }.

]

{ #category : 'Comparisons' }
Character >> = aCharacter [

"Returns true if the receiver and aCharacter have the same code point."

^ self == aCharacter 
]

{ #category : 'Comparisons' }
Character >> > aCharacter [

"Legacy method.
 Returns true if the Legacy sort order of the receiver is
 greater than that of aCharacter. "

<primitive: 182>

aCharacter _validateClass: Character.
^  self _primitiveFailed: #> args: { aCharacter }.

]

{ #category : 'Comparisons' }
Character >> >= aCharacter [

"Legacy method.
 Returns true if the Legacy sort order of the receiver is
 greater than or equal to that of aCharacter."

<primitive: 183>

aCharacter _validateClass: Character.
^  self _primitiveFailed: #>= args: { aCharacter }.

]

{ #category : 'Comparisons' }
Character >> ~= aCharacter [

"Returns false if the receiver and aCharacter have the same code point.
 Reimplemented as an optimization"

^ self ~~ aCharacter
]

{ #category : 'Converting' }
Character >> asCharacter [

"Returns the receiver."

^ self

]

{ #category : 'Deprecated' }
Character >> asciiLessThan: aChar [

"Returns true if the ASCII code of the receiver is less than that of
 aCharacter."

self deprecated: 'asciiLessThan: deprecated in 3.2.'.
^ self codePoint < aChar codePoint

]

{ #category : 'Accessing' }
Character >> asciiValue [

"Returns the Unicode value of the receiver (a SmallInteger)."

<primitive: 71>

self _primitiveFailed: #asciiValue .
self _uncontinuableError

]

{ #category : 'Converting' }
Character >> asDigit [

"Returns the digit value (0-9) of the receiver.  If the receiver is not
 a digit, this returns 0."

(self < $0 or:[ self > $9]) ifTrue: [^0].
^self codePoint - $0 codePoint

]

{ #category : 'Converting' }
Character >> asFoldcase [

"The result of calling u_foldCase(GCI_OOP_TO_CHAR(self), U_FOLD_CASE_DEFAULT)
 in libicu is returned as a Character

 The foldCase is the equivalent to use non-case-sensitive uses of strings or
 characters.
 It is recommended to use the asFoldcase method implemented
 in string classes MultiByteString and String because
 those methods take into account effects of adjacent characters
 on case folding."

^ self _unicodeStatus: 22

]

{ #category : 'Accessing' }
Character >> asInteger [

"Returns the Unicode value of the receiver (a SmallInteger)."

<primitive: 71>

self _primitiveFailed: #asInteger .
self _uncontinuableError

]

{ #category : 'Converting' }
Character >> asLowercase [
" Returns Unicode lowercase  equivalent of the receiver.
  If the receiver has no lowercase  equivalent, returns the receiver.

  calls u_tolower in libicu .
  same as java.lang.Character.toLowerCase() .

  Differs from the legacy method asLowercaseOld for code points
  for about 1000 code points between 256 and 67000 .

  This method only returns the simple, single-code point case mapping.
  Full case mappings should be used whenever possible because they produce
  better results by working on whole strings.
  They take into account the string context and the language and can map
  to a result string with a different length as appropriate.
  See asLowercaseForLocale: in classes String and MultiByteString .
"

<primitive: 963>
self _primitiveFailed: #asLowercase

]

{ #category : 'Converting-Legacy' }
Character >> asLowercaseOld [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns a Character that is the lower-case character corresponding
 to the receiver.  If the receiver is lower-case or has no case, this
 returns the receiver itself."

<primitive: 74>

self _primitiveFailed: #asLowercaseOld .
self _uncontinuableError

]

{ #category : 'Formatting' }
Character >> asString [

"Returns a one-Character String or DoubleByteString containing the receiver."

<primitive: 56>
| cp |
cp := self codePoint .
(cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
   ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
].
self _primitiveFailed: #asString .
self _uncontinuableError

]

{ #category : 'Converting' }
Character >> asSymbol [

"Returns a one-Character Symbol that represents the receiver."

^ self asString asSymbol

]

{ #category : 'Converting' }
Character >> asTitlecase [
" Returns the titlecase of the receiver.  This is either the uppercase, or
  the distinct titlecase character for the (few) characters that have a
  separate titlecase form. If the receiver has no case or is already title
  case, returns the receiver.

  calls u_totitle in libicu .
  same as java.lang.Character.toTitleCase() .

  This method only returns the simple, single-code point case mapping.
  Full case mappings should be used whenever possible because they produce
  better results by working on whole strings.
  They take into account the string context and the language and can map
  to a result string with a different length as appropriate.
  See asTitlecaseForLocale: in classes String and MultiByteString .
"
<primitive: 964>
self _primitiveFailed: #asUnicodeTitlecase

]

{ #category : 'Converting' }
Character >> asUppercase [

" Returns Unicode uppercase equivalent of the receiver.
  If the receiver has no uppercase equivalent, returns the receiver.

  calls u_toupper in libicu .
  same as java.lang.Character.toUpperCase() .

  Differs from the legacy method asUppercaseOld for
  code points 181, 255, and about 1000 code points >= 256 .

  This method only returns the simple, single-code point case mapping.
  Full case mappings should be used whenever possible because they produce
  better results by working on whole strings.
  They take into account the string context and the language and can map
  to a result string with a different length as appropriate.
  See asUppercaseForLocale: in classes String and MultiByteString .
"

<primitive: 968>
self _primitiveFailed: #asUppercase

]

{ #category : 'Converting-Legacy' }
Character >> asUppercaseOld [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns a Character that is the upper-case character corresponding
 to the receiver.  If the receiver is upper-case or has no case, this
 returns the receiver itself."

<primitive: 73>

self _primitiveFailed: #asUppercaseOld .
self _uncontinuableError

]

{ #category : 'Accessing' }
Character >> codePoint [

"Returns the Unicode value of the receiver (a SmallInteger)."

<primitive: 71>

self _primitiveFailed: #codePoint .
self _uncontinuableError

]

{ #category : 'Unicode' }
Character >> compareTo: aCharacter collator: anIcuCollator [

"Returns -1, 0, or 1 depending on how a Unicode16 string holding
 the receiver compares to a Unicode16 string holding the argument using
 the specified IcuCollator.
 anIcuCollator == nil is interpreted as   IcuCollator default ."

<primitive: 980>
 "primitive returns nil if aCharacter is not a Character"
  anIcuCollator ifNil:[ (System __sessionStateAt: 20) ifNil:[
     ^ self compareTo: aCharacter collator: IcuCollator default
  ]].
  self _primitiveFailed: #compareTo:collator: args: { aCharacter . anIcuCollator }

]

{ #category : 'Private' }
Character >> containsIdentity [

"Private."

^true

]

{ #category : 'Copying' }
Character >> copy [

"Returns the receiver.  (Does not create a new Character.)"

^self

]

{ #category : 'Converting' }
Character >> digitValue [

"If the result of calling u_charDigitValue(GCI_OOP_TO_CHAR(self)) in libicu
 is -1, returns nil.
 Otherwise the result from u_charDigitValue is returned as a SmallInteger.

 Results differ from legacy method digitValueOld for 450 code points
 between 1632 and 120831 "

^ self _unicodeStatus: 20

]

{ #category : 'Converting' }
Character >> digitValueInRadix: radixSmallInt [

"Returns a SmallInteger representing the value of the receiver
 in the given radix.
 Returns nil if if the receiver is not a digit in the given radix.
 If radixSmallInt < 2 or > 36, signals an OutOfRange error .

 The result is computed by calling u_digit(GCI_OOP_TO_CHAR(self), radix)
 in libicu."

<primitive: 966>

radixSmallInt _validateClass: SmallInteger .
(radixSmallInt < 2 or:[ radixSmallInt > 36]) ifTrue:[
   OutOfRange new
     name: 'radixSmallInt' min: 2 max: 36 actual: radixSmallInt ;
     signal
].
ArgumentError signal:'no valid digit translation'.
 ^ self _primitiveFailed: #digitValueInRadix: args: { radixSmallInt }

]

{ #category : 'Converting-Legacy' }
Character >> digitValueInRadixOld: radix [

"Legacy method.
 Returns a SmallInteger representing the value of the receiver, a digit, or
 returns nil if the receiver is not a digit in the given radix."

| val up |
radix == 10 ifTrue: [ ^self digitValueOld ].
radix < 10 ifTrue: [
  val := self digitValueOld .
  val >= radix ifTrue: [ ^nil ].
  ^val
].
val := self digitValueOld .
val ~~ nil ifTrue: [ ^val ].
up := self asUppercaseOld.
($A <= up and: [ up <= (self class withValue: ($A codePoint + radix - 11)) ])
ifTrue: [ ^(up codePoint - $A codePoint) + 10 ]
ifFalse: [ ^nil ]

]

{ #category : 'Converting-Legacy' }
Character >> digitValueOld [

"Legacy method.
 Returns a SmallInteger representing the value of the receiver,
 a digit, or returns nil if the receiver is not a digit."

(self isDigitOld)
  ifTrue:[ ^ self codePoint - $0 codePoint]
  ifFalse:[ ^ nil]

]

{ #category : 'Formatting' }
Character >> displayWidth [

"Returns the width necessary to display the receiver.
 For a Character, this method always returns 1."

^ 1

]

{ #category : 'Case-Insensitive Comparisons' }
Character >> equalsNoCase: aCharacter [

"Returns true if the receiver is the same Character as the argument regardless
 of case or internal representation.
 using equivalent of asUppercase before comparing."

<primitive: 979>
"If the primitive fails,
 then aCharacter must not be an instance of Character"

^ aCharacter isEquivalent: self

]

{ #category : 'Case-Insensitive Comparisons' }
Character >> equalsNoCaseOld: aCharacter [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns true if the receiver is the same Character as the argument regardless
 of case or internal representation,
 using equivalent of asUppercaseOld before comparing."

<primitive: 75>
"If the primitive fails,
 then aCharacter must not be an instance of Character"

^ aCharacter isEquivalent: self

]

{ #category : 'Grease' }
Character >> greaseInteger [
"Returns the Unicode value of the receiver (a SmallInteger)."
<primitive: 71>
self _primitiveFailed: #greaseInteger .
self _uncontinuableError

]

{ #category : 'Comparing' }
Character >> hash [

"Returns a numeric hash key for the receiver." 

^ self codePoint

]

{ #category : 'Testing' }
Character >> hasMirror [

"Return true if the receiver has a mirrored equivalent, E.g. s either the open
 or close of mirrored pairs such as ${ $}, $< $>, etc.

 Calls u_isMirrored(GCI_OOP_TO_CHAR(self)) in libicu .
 "

^ self _unicodeStatus: 19

]

{ #category : 'Testing' }
Character >> isAlphabetic [

"The result of calling u_isUAlphabetic(GCI_OOP_TO_CHAR(self)) in libicu is
 returned as a Boolean.  Result is TRUE if receiver code point has the
 Alphabetic Unicode property."

^ self _unicodeStatus: 1

]

{ #category : 'Testing' }
Character >> isAlphaNumeric [

"The result of calling u_isalnum(GCI_OOP_TO_CHAR(self)) in libicu is returned
 as a Boolean.
 Differs subtantially from the legacy method isAlphaNumericOld
 for codePoints >= 256 "

^ self _unicodeStatus: 6

]

{ #category : 'Testing-Legacy' }
Character >> isAlphaNumericOld [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns true if the receiver is a Roman letter or digit.  Returns false
 otherwise."

 | cat |
 cat := self _category .
 ^ cat == 9 or:[ cat < 4 ]

]

{ #category : 'Testing' }
Character >> isDigit [

"The result of calling u_isdigit(GCI_OOP_TO_CHAR(self)) in libicu is returned
 as a Boolean.
 Returns true for characters with Unicode general category 'Nd'
 (decimal digit numbers).
 Same as java.lang.Character.isDigit().

 Differs from the legacy method isDigitOld for 450 code points between
 1632 and 120831, which are considered digits in the Unicode standard,
 and for which isDigitOld returns false."

^ self _unicodeStatus: 4

]

{ #category : 'Testing-Legacy' }
Character >> isDigitOld [

"Legacy method.
 Returns true if the receiver is a digit.  Returns false otherwise."

^ self _category == 9

]

{ #category : 'Case-Insensitive Comparisons' }
Character >> isEquivalent: aCharacter [

"Returns true if the receiver is the same Character as the argument regardless
 of case or internal representation.
 using equivalent of asUppercase before comparing."

<primitive: 979>
"If the primitive fails,
 then aCharacter must not be an instance of Character"

^ aCharacter isEquivalent: self

]

{ #category : 'Case-Insensitive Comparisons' }
Character >> isEquivalentOld: aCharacter [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns true if the receiver is the same Character as the argument regardless
 of case or internal representation,
 using equivalent of asUppercaseOld before comparing."

<primitive: 75>
"If the primitive fails,
 then aCharacter must not be an instance of Character"

^ aCharacter isEquivalent: self

]

{ #category : 'Unicode' }
Character >> isGraphic [

"Returns true if the receiver is a graphic character; a printable character,
 excluding separators. Return false for characters with general categories Cc (control
 codes), Cf (format controls), Cs (surrogates), Cn (unassigned), and Z (separators).

 Calls u_isgraph(GCI_OOP_TO_CHAR(self)) in libicu"

^ self _unicodeStatus: 9

]

{ #category : 'Testing' }
Character >> isHexDigit [

"Returns true if the receiver is a hexadecimal digit.

 Returns true for characters with Unicode general category 'Nd' (decimal digit numbers).
 as well as Latin letters a-f and A-F in both ASCII and Fullwidth ASCII.
 (That is, for letters with code points
  16r0041..16r0046, 16r0061..16r0066, 16rFF21..16rFF26, 16rFF41..16rFF46.)

 In order to narrow the definition of hexadecimal digits to only ASCII
 characters, use  (c codePoint <= 16r7F and:[ unicodeIsXDigit ) .

 calls u_isxdigit in libicu .
"

^ self _unicodeStatus: 7

]

{ #category : 'Testing' }
Character >> isLetter [

"The result of calling u_isalpha(GCI_OOP_TO_CHAR(self)) in libicu is
 returned as a Boolean.
 Result is true for code points Unicode general categories 'L' (letters).

 Same as isAlphabetic for code points <= 836 .
 Same as java.lang.Character.isLetter() .

 Differs substantially from legacy isLetterOld for code points >= 256"

^ self _unicodeStatus: 5

]

{ #category : 'Testing-Legacy' }
Character >> isLetterOld [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns true if the receiver is a Roman letter.  Returns false otherwise."

^ self _category < 4

]

{ #category : 'Testing' }
Character >> isLowercase [
"Returns true if the receiver's code point has
 the Unicode general category  'Ll' (lowercase letter).

 Calls u_islower in libicu .
 Same as java.lang.Character.isLowerCase() .

 This misses some characters that are also lowercase but have
 a different general category value.
 In order to include those, use unicodeIsULowercase .
 isLowercase and unicodeIsULowercase differ for code points 170, 186,
 and about 180 code points >= 256 .

 Differs from legacy method isLowercaseOld
 for code points 170, 186, and about 1700 code points >= 256 .
"

^ self _unicodeStatus: 25

]

{ #category : 'Testing-Legacy' }
Character >> isLowercaseOld [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns true if the receiver is a lower-case character.  Returns false
 otherwise."

^ self _category == 2

]

{ #category : 'Unicode' }
Character >> isNumeric [
  "The result of calling
   u_getIntPropertyValue(GCI_OOP_TO_CHAR(self), UCHAR_NUMERIC_TYPE) in libicu
   is returned as a Boolean .
   Will return true for characters having either Numeric_Type Numeric
   (such as Han characters in Chinese-style number format) or Numeric_Type Decimal."

^ self _unicodeStatus: 27

]

{ #category : 'Testing-Legacy' }
Character >> isNumericOld [

"Legacy method.
 Returns true if the receiver contains numeric content ( category is #Nd #Nl #No).
 Returns false otherwise."

| category |
category := self _category.
category < 9 ifTrue: [ ^ false ].
category < 12 ifTrue: [ ^ true ].
^ false

]

{ #category : 'Testing' }
Character >> isPrintable [

 "Return true if the receiver is a printable character; this includes characters
  with any general category other than 'C' (controls).

  Calls u_isprint(GCI_OOP_TO_CHAR(self)) in libicu i.
"

^ self _unicodeStatus: 17

]

{ #category : 'Testing' }
Character >> isPunctuation [

"Return a boolean, true if the receiver is a punctuation character, false otherwise.

 Calls u_ispunct(GCI_OOP_TO_CHAR(self)) in libicu"

^ self _unicodeStatus: 8

]

{ #category : 'Testing' }
Character >> isSeparator [

"Returns true if codepoint of the receiver satisfies
    u_isISOControl(ch) || (ch == 32) || (ch == 160)
 using libicu.

 which is the same as isSeparator in previous releases."

^ self _unicodeStatus: 29

]

{ #category : 'Testing' }
Character >> isSpecial [

"Returns true if the receiver is a special object."

^ true

]

{ #category : 'Testing' }
Character >> isTitlecase [
"Returns true if the receiver's code point has the Unicode general category
 'Lt' (titlecase letter).

 Note that only titlecase characters return true. While asTitlecase converts
 to uppercase or titlecase, isTitlecase only returns true for titlecase.

 Calls u_istitle in libicu .
 Same as java.lang.Character.isTitleCase() .

 Differs from legacy method isTitlecaseOld for titlecase characters, when
 character data tables not installed; about 30 code points between 400 and 8100.
 The first code point for which isTitlecase returns true is 453.
"

^ self _unicodeStatus: 26

]

{ #category : 'Testing-Legacy' }
Character >> isTitlecaseOld [

"Legacy method.
 Returns true if the receiver is a title-case character.  Returns false
 otherwise."

^ self _category == 3

]

{ #category : 'Testing' }
Character >> isUppercase [
"Returns true if the receiver's code point has
 the Unicode general category  'Lu' (uppercase letter).

 Calls u_isupper in libicu .
 Same as java.lang.Character.isUpperCase().

 This misses some characters that are also uppercase but
 have a different general category value.  There are about 50 such
 differences between codepoints 8500 and 9500 .
 In order to include those, use unicodeIsUUppercase .

 Differs from legacy method isUppercaseOld
 for about 1400 code points >= 256 .
"

^ self _unicodeStatus: 24

]

{ #category : 'Testing-Legacy' }
Character >> isUppercaseOld [

"Legacy method. Not reliable for codepoints over 255 unless
 (deprecated) Character Data Tables installed.
 Returns true if the receiver is an upper-case character.  Returns false
 otherwise."

^ self _category == 1

]

{ #category : 'Testing-Legacy' }
Character >> isVowel [

"Legacy method. Vowel is not a unicode property.  Results may not be correct
 for code points over 255.
 Returns true if the receiver is a vowel ('Y' is considered to be a vowel).
 Returns false otherwise.

 This code assumes that the Legacy collation sequence places all uppercase variations
 of a given letter (including various diacritical marks) immediately following the
 plain version of the letter.
"
| ucs arr chCls |
ucs := self asUppercaseOld sortValue.
arr := #( $A $E $I $O $U $Y ) .
chCls := Character .
1 to: arr size do:[:j | | v |
  v := arr at: j .
  ucs < v sortValue  ifTrue: [ ^ false ].
  ucs < ( chCls withValue: v codePoint  + 1 ) sortValue  ifTrue:[^ true ]
].
^ false

]

{ #category : 'Converting' }
Character >> mirror [

"If the argument is the open or close of a mirrored pair, such as $( $) or ${ $},
 return the other character, the mirror of the receiver. If the receiver does
 not have a mirror, return the receiver.

 Calls u_charMirror(GCI_OOP_TO_CHAR(self)) in libicu .
 "

^ self _unicodeStatus: 21

]

{ #category : 'Converting' }
Character >> numericValue [

 "Calls u_getNumericValue(GCI_OOP_TO_CHAR(self)) in libicu
  and returns an Integer, Fraction, Float, or nil.

  Differs from digitValue in that numericValue  method handles
  characters having Numeric_Type Numeric (such as Han characters in Chinese-style
  number format) in addition to Numeric_Type Decimal."

^ self _unicodeStatus: 28

]

{ #category : 'Formatting' }
Character >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream."

aStream nextPut: $$ .
aStream nextPut: self

]

{ #category : 'Formatting' }
Character >> printString [

"Returns a String whose contents are a displayable representation of the
 receiver."

"GemStone does not allow the creation of new kinds of Character, so there
 is no point in creating a stream and sending printOn:."

| result |
result := String new: 2 .
result at: 1 put: $$ .
result at: 2 put: self  .
^ result

]

{ #category : 'Accessing' }
Character >> sortValue [

"Will be deprecated.
 Legacy method providing index into collation sequence, not Unicode compatible"

<primitive: 545>
self _primitiveFailed: #sortValue

]

{ #category : 'Unicode' }
Character >> unicodeCategory [

  "Returns a Symbol , the 2-letter Unicode name of
   general category for the code point.
   Result is based on u_charType(GCI_OOP_TO_CHAR(self)) in libicu"

  ^ self _unicodeStatus: 30

]

{ #category : 'Unicode' }
Character >> unicodeIsBase [

"The result of calling u_isbase(GCI_OOP_TO_CHAR(self)) in libicu is
 returned as a Boolean.

 From libicu uchar.h :
   Returns true for general categories 'L' (letters), 'N' (numbers),
   'Mc' (spacing combining marks), and 'Me' (enclosing marks).

   Note that this is different from the Unicode definition in
   chapter 3.5, conformance clause D13,
   which defines base characters to be all characters (not Cn)
   that do not graphically combine with preceding characters (M)
   and that are neither control (Cc) or format (Cf) characters.
"

^ self _unicodeStatus: 18

]

{ #category : 'Unicode' }
Character >> unicodeIsBlank [

"The result of calling u_isblank(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 10

]

{ #category : 'Unicode' }
Character >> unicodeIsControl [

"The result of calling u_iscntrl(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 15

]

{ #category : 'Unicode' }
Character >> unicodeIsDefined [

"The result of calling u_isdefined(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 11

]

{ #category : 'Unicode' }
Character >> unicodeIsISOControl [

"The result of calling u_isISOControl(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 16

]

{ #category : 'Unicode' }
Character >> unicodeIsJavaSpace [

"The result of calling u_isJavaSpaceChar(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 13

]

{ #category : 'Unicode' }
Character >> unicodeIsSpace [

"The result of calling u_isspace(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 12

]

{ #category : 'Unicode' }
Character >> unicodeIsULowercase [

"The result of calling u_isULowercase(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 2

]

{ #category : 'Unicode' }
Character >> unicodeIsUUppercase [

"The result of calling u_isUUppercase(GCI_OOP_TO_CHAR(self)) in libicu
 is returned as a Boolean.

 Result is true if the receiver has the Uppercase Unicode property.
 Different than isUppercase.
"

^ self _unicodeStatus: 3

]

{ #category : 'Unicode' }
Character >> unicodeIsWhitespace [

"The result of calling u_isWhitespace(GCI_OOP_TO_CHAR(self)) in libicu is returned as a Boolean"

^ self _unicodeStatus: 14

]

{ #category : 'Unicode' }
Character >> unicodeType [

"Return the general cateory SmallInteger for the receiver, by calling
 u_charType(GCI_OOP_TO_CHAR(self)) in libicui.  Same as java.lang.Character.getType().

 Values returned from this method do not have the same category equivalent as
 GemStone legacy category; do not use result with _categorySymbol:.
"

^ self _unicodeStatus: 23

]

{ #category : 'Storing and Loading' }
Character >> writeTo: passiveObj [

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| av ba |
av := self codePoint .
av <= 16rFF ifTrue:[
  (ba := ByteArray new: 1) at: 1 put: av .
  passiveObj nextPut: $$; nextPutAllBytes: ba .
] ifFalse:[  | ccls b3 b2 b1 b0 |
  ccls := Character .
  b0 := av bitAnd: 16rFF .
  av <= 16rFFFF ifTrue:[
    b1 := av bitShift: -8 .
    (ba := ByteArray new: 2) at: 1 put: b1 ; at: 2 put: b0 .
    passiveObj nextPut: $! ; nextPutAllBytes: ba .
  ] ifFalse:[
    av := av bitShift: -8 .
    b1 := av bitAnd: 16rFF .
    av := av bitShift: -8 .
    b2 := av bitAnd: 16rFF .
    av := av bitShift: -8 .
    b3 := av bitAnd: 16rFF .
    (ba := ByteArray new: 4) at: 1 put: b3 ; at: 2 put: b2 ; 
         at: 3 put: b1; at: 4 put: b0 .
    passiveObj nextPut: $& ; nextPutAllBytes: ba .
  ]
]
]
