Extension { #name : 'BlockClosure' }

{ #category : 'Reloading Decompiled Methods' }
BlockClosure class >> _new [

"Private."

^ super new .

]

{ #category : 'Instance Creation' }
BlockClosure class >> new [

"Disallowed."

self shouldNotImplement: #new

]

{ #category : 'Private' }
BlockClosure >> _deepCopyWith: copiedObjDict [

"Private.  Used internally to implement deepCopy."

^ self.

]

{ #category : 'Accessing' }
BlockClosure >> argumentCount [
  "Answer the number of arguments needed to evaluate the receiver."

  ^self subclassResponsibility: #argumentCount.

]

{ #category : 'Continuations' }
BlockClosure >> callCC [
   "Evaluate the receiver, which must be a one-argument block.
   The argument to the block will be a newly created continuation,
   which is an instance of GsProcess that contains a copy of the
   active process. Unless control flow is otherwise interrupted,
   return the result of evaluating the last expression in the block.

   If a reference is retained to the continuation that is created
   during the execution of this method, it may later be evaluated
   using the continuation's value: or value methods (distinct from
   the BlockClosure's value: and value methods). When the continuation
   value: is evaluated, it is effectively a GOTO to the point in
   execution that the original call to callCC returned, (optionally)
   returning a different value. The actual callCC block is only
   executed once; later evaluations of the continuation return from
   the block, but do not re-execute the block."

   ^ self value: (GsProcess continuationFromLevel: 2)

]

{ #category : 'Copying' }
BlockClosure >> copy [

"Returns the receiver. Copies of blocks are not made."

^ self.

]

{ #category : 'Flow of Control' }
BlockClosure >> doWhileFalse: conditionBlock [
  "Evaluate the receiver once, then again as long the value of conditionBlock is false."
  ^self subclassResponsibility: #doWhileFalse:
]

{ #category : 'Block Evaluation' }
BlockClosure >> ensure: aBlock [
  "Evaluate the receiver.
  Evaluate aBlock after evaluating the receiver,
  or before any return from a block that would return to the sender.
  Returns result of evaluating the receiver.

  aBlock must be a zero-arg instance of ExecBlock,
  otherwise an error is generated."

  ^self subclassResponsibility: #ensure:.

]

{ #category : 'Block Evaluation' }
BlockClosure >> ifCurtailed: terminationBlock [
  "Evaluate the receiver and return its result.
  If abnormal termination of the receiver occurs, terminationBlock is
  evaluated. The value returned from the evaluation of terminationBlock
  is discarded.

  Activation of an exception handler from within the receiver is not in and
  of itself an abnormal termination. However, if the exception handler for
  an exception that is not resumable results in termination of the receiver
  or if its handler block contains a return statement that results in
  abnormal termination of the receiver, then terminationBlock will be evaluated
  after evaluation of the exception handler.

  If an abnormal termination result in the termination of multiple blocks
  which were evaluated using either #ensure: or #ifCurtailed: the respective
  terminationBlocks will be executed in the reverse of the order in which
  the corresponding receiver blocks were evaluated."

  | wasCurtailed result |
  wasCurtailed := true.
  ^[
     result := self value.
     wasCurtailed := false.
     result
  ] ensure:[
    wasCurtailed ifTrue: terminationBlock
  ].

]

{ #category : 'Updating' }
BlockClosure >> instVarAt: anIndex put: aValue [

"Disallowed."

self shouldNotImplement: #instVarAt:put:

]

{ #category : 'Testing' }
BlockClosure >> isSimple [

"Returns the default answer, false."

^ false

]

{ #category : 'Block Evaluation' }
BlockClosure >> on: exceptionSelector do: handlerBlock [
	"Try to evaluate the receiver, which should be a zero-argument block.
	 If an exception occurs and the expression exceptionSelector handles: theExceptionInstance
	 returns true, then evaluate the one argument block handlerBlock, passing it the exception
	 instance as its argument.

	 These forms are supported directly by the VM
		(1) on: anException do: handlerBlock
		(2) on: anExceptionSet do: handlerBlock
	 This form is handled by Smalltalk code in the body of this method.
		(3) on: anObject do: handlerBlock

	 anException must be the class Exception  or a subclass thereof;
	 anExceptionSet must be a kind of ExceptionSet;
	 handlerBlock must be an instance of ExecBloc otherwise an error is generated.

	 For forms 1, 2, and 3 if handlerBlock is not a one argument block,
	 an error is generated if exception handling attempts to invoke that handlerBlock.

	 If handlerBlock is invoked to handle an Exception which occurs during execution of the
	 receiver and handlerBlock completes normally , then the result of handlerBlock (the value
	 of the last expression in handlerBlock) will be the result of the on:do: send .  Other-than-normal
	 completion of handlerBlock is available by use of Exception's instance methods such as
	 #return, #return:, #retry, #retryUsing:, #resume, #resume:, #pass, and #outer within handlerBlock.

	 For forms 1 and 2, when searching for a handlerBlock to handle a signaled Exception, the VM
	 uses Behavior>>_subclassOf: semantics . classHistories of the class of the signaled Exception
	 and of anException or elements of anExceptionSet are ignored."

	^self subclassResponsibility: #on:do:.

]

{ #category : 'Flow of Control' }
BlockClosure >> untilFalse [

  ^self subclassResponsibility: #untilFalse

]

{ #category : 'Flow of Control' }
BlockClosure >> untilFalse: aBlock [

  ^self subclassResponsibility: #untilFalse:

]

{ #category : 'Block Evaluation' }
BlockClosure >> value [
	"Return the value of the receiver evaluated with no arguments.
	 If the receiver expects any arguments, signal an error."

	^self subclassResponsibility: #value.

]

{ #category : 'Block Evaluation' }
BlockClosure >> value: anObject [
	"Return the value of the receiver evaluated with anObject as its argument.  If
	 the receiver expects a different number of arguments, signal an error."

	^self subclassResponsibility: #value:.

]

{ #category : 'Block Evaluation' }
BlockClosure >> value: firstObject value: secondObject [
	"Return the value of the receiver evaluated with the specified arguments.  If
	 the receiver expects a different number of arguments, signal an error."

	^self subclassResponsibility: #value:value:.

]

{ #category : 'Block Evaluation' }
BlockClosure >> valueWithArguments: argList [
	"Return the value of the receiver evaluated with the specified arguments.  If
	 the receiver expects a different number of arguments, signal an error."

	^self subclassResponsibility: #valueWithArguments:.

]

{ #category : 'Flow of Control' }
BlockClosure >> whileFalse [
	"Evaluate the receiver once and then repeatedly as long as the value
	 returned by the evaluation is false."

	^self subclassResponsibility: #whileFalse.

]

{ #category : 'Flow of Control' }
BlockClosure >> whileFalse: aBlock [
	"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
	 while the receiver evaluates to false.  Return nil.  Generates an error if the
	 receiver is not a zero-argument block."

	^self subclassResponsibility: #whileFalse:.

]

{ #category : 'Flow of Control' }
BlockClosure >> whileTrue [
	"Evaluate the receiver once and then repeatedly as long as the value
	 returned by the evaluation is true."

	^self subclassResponsibility: #whileTrue.

]

{ #category : 'Flow of Control' }
BlockClosure >> whileTrue: aBlock [
	"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
	 while the receiver evaluates to true.  Return nil.  Generates an error if the
	 receiver is not a zero-argument block."

	^self subclassResponsibility: #whileTrue:.

]

{ #category : 'Storing and Loading' }
BlockClosure >> writeTo: aPassiveObject [

"Instances of BlockClosure cannot be converted to passive form.  This method
 writes nil to aPassiveObject and stops GemStone Smalltalk execution with a
 notifier."

aPassiveObject writeObject: nil.
self _error: #rtErrAttemptToPassivateInvalidObject.

]
