Extension { #name : 'Array' }

{ #category : 'Private' }
Array class >> _encodingForStringDensity [

  "Number of characters encoded per SmallInteger by <primitive: 542>."

^ 7

]

{ #category : 'Private' }
Array class >> _insertEncodingForString: aString arraySize: aSmallInteger [

  "Encode the given string into SmallIntegers and place them in a new
   instance of Array. Used for user-defined indexing support.

   Note: if there are null characters in the encoded string they will be
      effectively ignored during encoding and the decoded string will
      not match the encoded string."

  <primitive: 542>

  aString  _validateClass: String .
  aSmallInteger _validateClass: SmallInteger .
  ^ self _primitiveFailed: #_insertEncodingForString:arraySize:
         args: { aString . aSmallInteger }


]

{ #category : 'Filein Support' }
Array class >> _newKernelByteSubclass: clsName
classVars: classVarArg
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: aReservedOop [

"Disallowed for Array and its subclasses."

^ self _error: #classErrByteSubclass

]

{ #category : 'Disallowed' }
Array class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
isInvariant: invarBoolean [

"Disallowed for Array and its subclasses."
^ self _error: #classErrByteSubclass

]

{ #category : 'Subclass Creation' }
Array class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: options [

"Disallowed for Array and its subclasses."
^ self _error: #classErrByteSubclass

]

{ #category : 'Instance Creation' }
Array class >> with: aValue [

<primitive: 1099>
^ self _primitiveFailed: #with: args: { aValue }

]

{ #category : 'Instance Creation' }
Array class >> with: aValue with: val2 [

<primitive: 1099>
^ self _primitiveFailed: #with:with: args: { aValue . val2 }

]

{ #category : 'Instance Creation' }
Array class >> with: aValue with: val2 with: val3 [

<primitive: 1099>
^ self _primitiveFailed: #with:with:with: args: { aValue . val2 . val3 }

]

{ #category : 'Instance Creation' }
Array class >> with: aValue with: val2 with: val3 with: val4 [

<primitive: 1099>
^ self _primitiveFailed: #with:with:with:with: args: { aValue . val2 . val3 . val4 }

]

{ #category : 'Instance Creation' }
Array class >> with: aValue with: val2 with: val3 with: val4 with: val5 [

<primitive: 1099>
^ self _primitiveFailed: #with:with:with:with:with: args: { aValue . val2 . val3 . val4 . val5 }

]

{ #category : 'Adding' }
Array >> _addAllFromNsc: aBag [

""

<primitive: 202>
^ self _primitiveFailed: #_addAllFromNsc: args: { aBag }

]

{ #category : 'Decompiling without Sources' }
Array >> _asSource [

""

| result word lineLength LF |
self isInvariant ifFalse:[ self _error: #rtErrObjVariant ] .
result := String new .
LF := Character lf .
result addAll: ' #( ' .
lineLength := result size .
1 to: self size do:[:j |
  word := (self at: j) _asSource .
  result addAll: word .
  result add: $  .
  lineLength := lineLength + word size + 1 .
  lineLength > 80 ifTrue:[
    result add: LF ; add: $  .
    lineLength := 1 .
    ].
  ].
result addAll: ') ' .
^ result .

]

{ #category : 'Accessing' }
Array >> _at: anIndex [

"Returns the value of an indexed variable in the receiver.
 The argument anIndex must not be larger than the size of the
 receiver, and must not be less than 1.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds, or if the receiver is not indexable."

<primitive: 699>
(anIndex _isInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
^ self _primitiveFailed: #at: args: { anIndex }

]

{ #category : 'Updating' }
Array >> _at: anIndex put: aValue [

"Stores the argument aValue in the indexed variable of the
 receiver indicated by anIndex.  The argument anIndex must not be
 larger than 1 + the size of the receiver, and must not be less than 1.

 Returns aValue.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds."

<primitive: 745>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

^ self _primitiveFailed: #at:put: args: { anIndex . aValue }

]

{ #category : 'Updating' }
Array >> _basicAt: anIndex put: aValue [

"Stores the argument aValue in the indexed variable of the
 receiver indicated by anIndex.  The argument anIndex must not be
 larger than 1 + the size of the receiver, and must not be less than 1.

 Returns aValue.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds."

<primitive: 745>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

^ self _primitiveFailed: #_basicAt:put: args: { anIndex . aValue }

]

{ #category : 'Private' }
Array >> _decodeKeyAt: keyIdx decoding: numToDecode into: aString [
  "Decode <numToDecode> SmallIntegers from the receiver into <aString> as
   encoded by <primitive: 542>.

   Note: if there are null characters in the encoded string they will be
      effectively ignored during encoding and the decoded string will
      not match the encoded string."

  <primitive: 631 >
  aString  _validateClass: String .
  numToDecode _validateClass: SmallInteger .
  keyIdx _validateClass: SmallInteger .
  ^ self _primitiveFailed: #_decodeKeyAt:decoding:into:
         args: { keyIdx . numToDecode . aString }

]

{ #category : 'Removing' }
Array >> _deleteNoShrinkFrom: startIndex to: stopIndex [

"The elements of the receiver from startIndex to stopIndex are
 deleted from the receiver.  And the tail of the receiver is filled with
 (stopIndex - startIndex + 1) number of nils.

 The size of the receiver is not changed.
 Does space-efficient tranlogging of the deletion.

 Both startIndex and stopIndex must be positive integers not larger
 than the size of the receiver, with startIndex <= stopIndex."

<primitive: 602 >

(stopIndex < startIndex)
ifTrue:
   [ ^ startIndex _error: #rtErrBadCopyFromTo args: { stopIndex }].
((stopIndex > self size) or: [(stopIndex < 1)])
   ifTrue: [ ^ self _errorIndexOutOfRange: stopIndex].
(startIndex < 1)
   ifTrue: [ ^ self _errorIndexOutOfRange: startIndex].
^ self _primitiveFailed: #_deleteNoShrinkFrom:to:
       args: { startIndex . stopIndex }

]

{ #category : 'Private' }
Array >> _deleteNoShrinkFrom: startIndex to: stopIndex anchorTailSize: tailSize [

"Same as _deleteNoShrinkFrom: startIndex to: stopIndex except the last
tailSize objects remain in the tail of the array.  The size of the receiver does not change
and the gap created by the delete operation is filled with nils.

This method can fail for the following reasons:
-receiver participates in an index.
-receiver is a large object.
-the delete operation requested would delete any part of the tail

 The size of the receiver is not changed.

 Both startIndex and stopIndex must be positive integers not larger
 than the size of the receiver, with startIndex <= stopIndex.  "

<primitive: 617 >

(stopIndex < startIndex)
ifTrue:
   [ ^ startIndex _error: #rtErrBadCopyFromTo args: { stopIndex }].
((stopIndex > self size) or: [(stopIndex < 1)])
   ifTrue: [ ^ self _errorIndexOutOfRange: stopIndex].
(startIndex < 1)
   ifTrue: [ ^ self _errorIndexOutOfRange: startIndex].
(stopIndex > (self size - tailSize) )
   ifTrue: [ ^ self _errorIndexOutOfRange: tailSize].

^ self _primitiveFailed: #_deleteNoShrinkFrom:to:anchorTailSize:
       args: { startIndex . stopIndex . tailSize }

]

{ #category : 'Private' }
Array >> _finalize: anObj at: offset [

"Finalizes the reference to object anObject by substituting nil."

self at: offset put: nil.
^true

]

{ #category : 'Copying' }
Array >> _insertAt: destOffset
from: anArray
fromStart: startOffset
fromEnd: endOffset
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures.  Does not do optimized tranlogging.

 Inserts the portion of anArray from startOffset to endOffset
 into the receiver beginning at destOffset.

 If anArray is nil, then  (endOffset - startOffset + 1) nils are
 inserted into the receiver.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by
 the amount (endOffset - startOffset + 1).
 The receiver must be a small object.

 If the receiver must be grown, it will be grown by 10 times the number
 of OOPs inserted up to a max of 500 oops. The receiver will not be
 grown larger than the max size of a small object. If the number of
 inserted oops alone will cause the object to be larger than the max
 size of a small object, then an error will be generated.

 Generates an error if any of the arguments imply the receiver must be
 grown to be a large object, or if destOffset is beyond the end of
 the receiver."

<primitive: 605 >

| numInserted newSize |

anArray ~~ nil ifTrue:[ anArray _validateClass: Array ].

(destOffset < 1 or:[ destOffset > self _basicSize] )
   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(startOffset < 1) ifTrue:[ self _errorIndexOutOfRange: startOffset] .
(endOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: endOffset] .
(numToMove < 0)   ifTrue:[ self _errorIndexOutOfRange: numToMove] .
(endOffset < startOffset) ifTrue:[ self _errorIndexOutOfRange: endOffset ].
(anArray ~~ nil and: [startOffset > anArray _basicSize]) ifTrue:[ anArray _errorIndexOutOfRange: startOffset].
(anArray ~~ nil and: [endOffset > anArray _basicSize]) ifTrue:[ anArray _errorIndexOutOfRange: endOffset].

numInserted := endOffset - startOffset + 1 .

newSize := destOffset + numInserted + numToMove .
newSize > 2034 "virtual machine constant OBJ_OOPS_SIZE" ifTrue:[
  self _error: #objErrMaxSize args:{ 2034 "virtual machine constant" . newSize }.
].

self _primitiveFailed: #_insertAt:from:fromStart:fromEnd:numToMoveDown:
     args: { destOffset . anArray . startOffset . endOffset . numToMove }

]

{ #category : 'Copying' }
Array >> _insertAt: destOffset
value: anObject
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures.  Does space-efficient tranlogging of the insertion.

 Inserts anObject into receiver at destOffset, with space-efficient tranlogging
 of the insert.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by 1 .
 then does (self at: destOffset put: anObject ).
 The receiver must be a small object;

 Generates an error if any of the arguments imply the receiver must be
 grown to be a large object, or if destOffset is beyond the end of
 the receiver."

<primitive: 1041>
| newSize |
destOffset _validateClass: SmallInteger .
numToMove _validateClass: SmallInteger .
(destOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(numToMove < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
newSize := self namedSize +  destOffset + 1  +  numToMove .
newSize > 2034 "virtual machine constant OBJ_OOPS_SIZE" ifTrue:[
  self _error: #objErrMaxSize args:{ 2034 "virtual machine constant" . newSize }.
].
self _primitiveFailed: #_insertAt:value:numToMoveDown
     args: { destOffset . anObject . numToMove }

]

{ #category : 'Copying' }
Array >> _insertAt: destOffset
value: valOne
value: valTwo
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures.  Does space-efficient tranlogging of the insertion.

 Inserts objects into receiver at destOffset, with space-efficient tranlogging
 of the insert.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by 2 .
 then does (self at: destOffset put: valOne ; at: destOffset+1 put: valTwo ).
 The receiver must be a small object;

 Generates an error if any of the arguments imply the receiver must be
 grown to be a large object, or if destOffset is beyond the end of
 the receiver."

<primitive: 1032>
| newSize |
destOffset _validateClass: SmallInteger .
numToMove _validateClass: SmallInteger .
(destOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(numToMove < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
newSize := self namedSize +  destOffset + 2  +  numToMove .
newSize > 2034 "virtual machine constant OBJ_OOPS_SIZE" ifTrue:[
  self _error: #objErrMaxSize args:{ 2034 "virtual machine constant" . newSize }.
].
self _primitiveFailed: #_insertAt:value:value:numToMoveDown
     args: { destOffset . valOne . valTwo . numToMove }

]

{ #category : 'Copying' }
Array >> _insertAt: destOffset
value: valOne
value: valTwo
value: valThree
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures.  Does space-efficient tranlogging of the insertion.

 Inserts objects into receiver at destOffset, with space-efficient tranlogging
 of the insert.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by 3 .
 then does (self at: destOffset put: valOne ; at: destOffset+1 put: valTwo ;
                at: destOffset+2 put: valThree )
 The receiver must be a small object;

 Generates an error if any of the arguments imply the receiver must be
 grown to be a large object, or if destOffset is beyond the end of
 the receiver."

<primitive: 1033>
| newSize |
destOffset _validateClass: SmallInteger .
numToMove _validateClass: SmallInteger .
(destOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(numToMove < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
newSize := self namedSize +  destOffset + 3  +  numToMove .
newSize > 2034 "virtual machine constant OBJ_OOPS_SIZE" ifTrue:[
  self _error: #objErrMaxSize args:{ 2034 "virtual machine constant" . newSize }.
].
self _primitiveFailed: #_insertAt:value:value:value:numToMoveDown
     args: { destOffset . valOne . valTwo . valThree . numToMove }

]

{ #category : 'Copying' }
Array >> _insertAt: destOffset
value: valOne
value: valTwo
value: valThree
value: valFour
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures.  Does space-efficient tranlogging of the insertion.

 Inserts objects into receiver at destOffset, with space-efficient tranlogging
 of the insert.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by 4 .
 then does (self at: destOffset put: valOne ; at: destOffset+1 put: valTwo ;
         at: destOffset+2 put: valThree ;  at: destOffset+3 put: valFour )
 The receiver must be a small object;

 Generates an error if any of the arguments imply the receiver must be
 grown to be a large object, or if destOffset is beyond the end of
 the receiver."

<primitive: 1034>
| newSize |
destOffset _validateClass: SmallInteger .
numToMove _validateClass: SmallInteger .
(destOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(numToMove < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
newSize := self namedSize +  destOffset + 4  +  numToMove .
newSize > 2034 "virtual machine constant OBJ_OOPS_SIZE" ifTrue:[
  self _error: #objErrMaxSize args:{ 2034 "virtual machine constant" . newSize }.
].
self _primitiveFailed: #_insertAt:value:value:value:value:numToMoveDown
     args: { destOffset . valOne . valTwo . valThree . valFour . numToMove }

]

{ #category : 'Copying' }
Array >> _insertAt: destOffset
value: valOne
value: valTwo
value: valThree
value: valFour
value: valFive
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures.  Does space-efficient tranlogging of the insertion.

 Inserts objects into receiver at destOffset, with space-efficient tranlogging
 of the insert.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by 5 .
 then does (self at: destOffset put: valOne ; at: destOffset+1 put: valTwo ;
         at: destOffset+2 put: valThree ;  at: destOffset+3 put: valFour;
         at: destOffset+4 put: valFive  )
 The receiver must be a small object;

 Generates an error if any of the arguments imply the receiver must be
 grown to be a large object, or if destOffset is beyond the end of
 the receiver."

<primitive: 1035>
| newSize |
destOffset _validateClass: SmallInteger .
numToMove _validateClass: SmallInteger .
(destOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(numToMove < 1)   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
newSize := self namedSize +  destOffset + 5  +  numToMove .
newSize > 2034 "virtual machine constant OBJ_OOPS_SIZE" ifTrue:[
  self _error: #objErrMaxSize args:{ 2034 "virtual machine constant" . newSize }.
].
self _primitiveFailed: #_insertAt:value:value:value:value:value:numToMoveDown
     args: { destOffset . valOne . valTwo . valThree . valFour . valFive . numToMove }

]

{ #category : 'Copying' }
Array >> _largeInsertAt: destOffset
from: anArray
fromStart: startOffset
fromEnd: endOffset
numToMoveDown: numToMove [

"Intended for use in manipulating objects which are nodes of B-trees or
 similar structures. Similar to primitive 605, except that with this
 primitive objects will be grown to large objects if necessary.
 Does not do optimized tranlogging.

 Inserts the portion of anArray from startOffset to endOffset
 into the receiver beginning at destOffset.

 If anArray is nil, then  (endOffset - startOffset + 1) nils are
 inserted into the receiver.

 The indexable instance variables of the receiver from destOffset to
 (destOffset + numToMove) are moved towards the end of the receiver by
 the amount (endOffset - startOffset + 1).
 The receiver may be a small or large object.

 If the receiver must be grown, it will be grown by 10 times the number
 of OOPs inserted up to a max of 500 oops.

 Generates an error if destOffset is beyond the end of the receiver."

<primitive: 552 >

anArray ~~ nil ifTrue:[ anArray _validateClass: Array ].

(destOffset < 1 or:[ destOffset > self _basicSize] )
   ifTrue:[ self _errorIndexOutOfRange: destOffset] .
(startOffset < 1) ifTrue:[ self _errorIndexOutOfRange: startOffset] .
(endOffset < 1)   ifTrue:[ self _errorIndexOutOfRange: endOffset] .
(numToMove < 0)   ifTrue:[ self _errorIndexOutOfRange: numToMove] .
(endOffset < startOffset) ifTrue:[ self _errorIndexOutOfRange: endOffset ].
(anArray ~~ nil and: [startOffset > anArray _basicSize]) ifTrue:[ anArray _errorIndexOutOfRange: startOffset].
(anArray ~~ nil and: [endOffset > anArray _basicSize]) ifTrue:[ anArray _errorIndexOutOfRange: endOffset].

self _primitiveFailed: #_largeInsertAt:from:fromStart:fromEnd:numToMoveDown:
     args: { destOffset . anArray . startOffset . endOffset . numToMove }

]

{ #category : 'Adding' }
Array >> add: anObject [

"Makes anObject one of the receiver's elements and returns anObject.  The
 new element is actually added as the last element of the receiver.  This
 method is equivalent to #addLast: ."

<primitive: 203>
^ self _primitiveFailed: #add: args: { anObject }

]

{ #category : 'Adding' }
Array >> addAll: aCollection [

"Adds all of the elements of aCollection to the receiver and returns
 aCollection."

<primitive: 213>
"primitive handles arg kinds Array, OrderedCollection and IdentityBag."

^ super addAll: aCollection

]

{ #category : 'Adding' }
Array >> addAll: anArray excludingFirst: excludeCount [

"If   anArray size > (excludeCount+1)
adds elements of anArray from (excludeCount+1)  to  (anArray size)
to the receiver,  otherwise does nothing.
Returns the receiver .

If excludeCount is less than 0 it is intepreted as 0 ."

<primitive: 231>
anArray _validateClasses: { Array . OrderedCollection }.
excludeCount _validateClass: SmallInteger .
^ self _primitiveFailed: #addAll:excludingFirst:
       args: { anArray . excludeCount }

]

{ #category : 'Adding' }
Array >> addLast: anObject [

"Adds anObject as the last element of the receiver and returns anObject."

<primitive: 203>
^ self _primitiveFailed: #addLast: args: { anObject }

]

{ #category : 'Accessing' }
Array >> at: anIndex [

"Returns the value of an indexed variable in the receiver.
 The argument anIndex must not be larger than the size of the
 receiver, and must not be less than 1.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds, or if the receiver is not indexable."

<primitive: 699>
(anIndex _isInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
^ self _primitiveFailed: #at: args: { anIndex }

]

{ #category : 'Private' }
Array >> at: anIndex caseInsensitiveEquals: encodedStringArray [

 "Compares without regard to case, in order starting at anIndex, if the contents of the receiver
  are equal to the encoded contents of <encodedStringArray>. The elements of both
  collections must be SmallIntegers. The SmallIntegers represents strings encoded using
  <primitive: 542>."

  ^self at: anIndex compareEqualNoCaseWithEncodedStringArray: encodedStringArray startingAt: 1.

]

{ #category : 'Private' }
Array >> at: anIndex caseSensitiveEquals: encodedStringArray [

 "Compares without regard to case, in order starting at anIndex, if the contents of the receiver
  are equal to the encoded contents of <encodedStringArray>. The elements of both
  collections must be SmallIntegers. The SmallIntegers represents strings encoded using
  <primitive: 542>."

  ^self compareStartingAt: anIndex to: encodedStringArray startingAt: 1

]

{ #category : 'Private' }
Array >> at: anIndex compareEqualNoCaseWithEncodedStringArray: encodedStringArray startingAt: stringOffset [

 "Compares without regard to case, in order starting at anIndex, if the contents of the receiver
  are equal to the encoded contents of <encodedStringArray>, starting at stringOffset. The elements of both
  collections must be SmallIntegers. The SmallIntegers represents strings encoded using
  <primitive: 542>."

  <primitive: 632 >
  ^self _primitiveFailed: #at:compareEqualNoCaseWithEncodedStringArray:startingAt:
        args: { anIndex .  encodedStringArray . stringOffset }


]

{ #category : 'Private' }
Array >> at: anIndex compareWithEncodedStringArray: encodedStringArray startingAt: stringOffset opCode: anOpCode [

 "Compares, in order starting at anIndex, if the contents of the receiver
  are less than/greater than the contents of anArray, starting at stringOffset.
  The elements of both collections must be SmallIntegers. The SmallIntegers
  represents strings encoded using <primitive: 542>.

    op code == 0 means less than
    op code == 1 means greater than"

  <primitive: 629 >
  ^ self _primitiveFailed: #at:compareWithEncodedStringArray:startingAt:opCode:
         args: { anIndex . encodedStringArray . stringOffset . anOpCode }

]

{ #category : 'Private' }
Array >> at: anIndex greaterThanEncodedStringArray: encodedStringArray startingAt: arrayOffset [
  "Compares, in order starting at anIndex, if the contents of the receiver are greater
   than the contents of anArray, starting at stringOffset. The elements of both
   collections must be SmallIntegers. The SmallIntegers represent encoded string for
   index. The string was encoded using <primitive: 542>."

  ^self at: anIndex
        compareWithEncodedStringArray: encodedStringArray
        startingAt: arrayOffset
	opCode: 1.

]

{ #category : 'Private' }
Array >> at: anIndex lessThanEncodedStringArray: encodedStringArray startingAt: arrayOffset [
   "Compares, in order starting at anIndex, if the contents of the receiver
    are less than the contents of anArray, starting at stringOffset.
    The elements of both collections must be SmallIntegers. The SmallIntegers represent
    encoded string for index. The string was encoded using <primitive: 542>."

  ^self at: anIndex
	compareWithEncodedStringArray: encodedStringArray
	startingAt: arrayOffset
	opCode: 0.

]

{ #category : 'Updating' }
Array >> at: anIndex put: aValue [

"Stores the argument aValue in the indexed variable of the
 receiver indicated by anIndex.  The argument anIndex must not be
 larger than 1 + the size of the receiver, and must not be less than 1.

 Returns aValue.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds."

<primitive: 745>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

^ self _primitiveFailed: #at:put: args: { anIndex . aValue }

]

{ #category : 'Accessing' }
Array >> atOrNil: anIndex [

"Return the value   self at: anIndex ,
 or return nil if anIndex is out of range . "

<primitive: 699>
anIndex _isInteger ifTrue:[
  ^ nil
].
self _errorNonIntegerIndex: anIndex .
^ self _primitiveFailed: #atOrNil: args: { anIndex }

]

{ #category : 'Private' }
Array >> compareStartingAt: anIndex to: anArray startingAt: anotherIndex [

  "Compare the elements of the receiver starting at <anIndex> to <anArray>
   starting at <anotherIndex>. Note that it is assumed that the objects
   in each slot of the receiver and <anArray> are SmallIntegers encoded
   from strings produced by <primitive: 542>, however, it is not a
   requirement, since each element is compared using identity."

  <primitive: 628 >
  ^ self _primitiveFailed: #compareStartingAt:to:startingAt:
         args: { anIndex . anArray . anotherIndex }

]

{ #category : 'Copying' }
Array >> copyFrom: startIndex to: stopIndex [

"Returns a new Array containing the elements of the receiver
 between startIndex and stopIndex, inclusive.  The result is of the same class
 as the receiver.

 If startIndex > stopIndex then an empty collection is returned.
 Otherwise both startIndex and stopIndex must be positive integers not larger than the
 size of the receiver, with startIndex <= stopIndex.
"

<primitive: 817>
(startIndex < 1) ifTrue: [ ^ self _errorIndexOutOfRange: startIndex].

((stopIndex > self size) or: [(stopIndex < 0)])
   ifTrue: [ ^ self _errorIndexOutOfRange: stopIndex].

self _primitiveFailed: #copyFrom:to:
     args: { startIndex . stopIndex }

]

{ #category : 'Copying' }
Array >> copyNotNilFrom: startIndex to: stopIndex [
 "Return an Array containing the non-nil elements 
  that are within the specified offsets of the receiver."
 <primitive: 541>
 "Primitive fails for a large object."
 | res |
 startIndex _validateInstanceOf: SmallInteger .
 stopIndex _validateInstanceOf: SmallInteger .
 (startIndex < 1 or:[ startIndex > self size ]) ifTrue:[
   ^ self _errorIndexOutOfRange: startIndex
 ].
 stopIndex < startIndex ifTrue:[ ^ self _errorIndexOutOfRange: stopIndex].
 res := { } .
 startIndex to: stopIndex do:[:j |
   (self at: j) ifNotNil:[:x| res add: x  ] .
 ].
 ^ res
]

{ #category : 'Obsolete' }
Array >> fillFrom: index1 resizeTo: newSize with: anObject [

  self deprecated: 'Array >> fillFrom:resizeTo:with: has primitive support removed v3.7.2 to avoid out of memory issues. Use fillFrom:to:with: after pregrowing the Array'.

  Error signal: 'Array >> fillFrom:resizeTo:with: not supported, see Array >> fillFrom:to:with:' .
]

{ #category : 'Initializing' }
Array >> fillFrom: startIdx to: endIdx with: anObject [

"  store anObject into instVars startIdx .. endIdx of the receiver.
   the receiver will be grown if necessary .
   Attempts to grow the receiver beyond 2034 total instVars signals an error"

<primitive: 607>
| namedSize |
startIdx _validateClass: SmallInteger .
endIdx _validateClass: SmallInteger .
(startIdx < 1) ifTrue:[ self _errorIndexOutOfRange: startIdx ].
(startIdx > endIdx) ifTrue:[ startIdx _error: #rtErrBadCopyFromTo args: { endIdx }].
(endIdx + (namedSize := self class instSize)) > 2034 ifTrue:[ 
  OutOfRange new name:'endIdx' max: 2034 - namedSize actual: endIdx ; signal
].
self _primitiveFailed: #fillFrom:to:with: args: { startIdx . endIdx . anObject }

]

{ #category : 'Comparing' }
Array >> hasIdenticalContents: anArray [

"Returns true if all of the following conditions are true:

 1.  The receiver and anArray are of the same class.
 2.  The two Arrays are the same size.
 3.  The corresponding elements of the receiver and anArray are identical.

 Returns false otherwise."

<primitive: 612 >

^ self _primitiveFailed: #hasIdenticalContents: args: { anArray }

]

{ #category : 'Searching' }
Array >> includesIdentical: anObject [

"Returns true if anObject is identical to one of the elements of the
 receiver.  Returns false otherwise."

<primitive: 59>
self _primitiveFailed: #includesIdentical: args: { anObject }

]

{ #category : 'Searching' }
Array >> includesValue: anObject [

"Returns true if anObject is equal to one of the elements of the receiver.
 Returns false otherwise."

^ self includes: anObject

]

{ #category : 'Searching' }
Array >> indexOfIdentical: anObject [

"Private.  Returns the index of the first element in the receiver that is
 identical to the argument.  If the receiver does not have any elements that are
 identical to the argument, returns zero."

<primitive: 494>
self _primitiveFailed: #indexOfIdentical: args: { anObject }

]

{ #category : 'Searching' }
Array >> indexOfNotNil: startOffset to: endOffset [
"If startOffset <= endOffset, returns the first offset witin in the specified range
 of a non-nil element of the receiver.
 If startOffset > endOffset, returns the last offset within the specified range
 of a non-nil element of the receiver.
 Returns zero if all are nil .
 Intended for use only on Arrays of size <= 2000 .  
 Performance on larger arrays will be slow.
 "
 <primitive: 540>
 "Primitive fails for a large object."
  | sz |
 startOffset _validateInstanceOf: SmallInteger .
 endOffset _validateInstanceOf: SmallInteger .
 sz := self size .
 (startOffset < 1 or:[ startOffset > sz]) ifTrue:[
   ^ self _errorIndexOutOfRange: startOffset
 ].
 (endOffset < 1 or:[ endOffset > sz]) ifTrue:[
   ^ self _errorIndexOutOfRange: startOffset
 ].
 startOffset <= endOffset ifTrue:[
   startOffset to: endOffset do:[:j |
     (self at: j) ifNotNil:[ ^ j ] .
   ].
 ] ifFalse:[
   startOffset _downTo: endOffset do:[:j |
     (self at: j) ifNotNil:[ ^ j ] .
   ].
 ].
 ^ 0
]

{ #category : 'Enumerating' }
Array >> pairsDo: aBlock [
  "aBlock must be a two argument block"

  1 to: self size by: 2 do:[:j |
    aBlock value:(self at: j) value:(self at: j+1)
  ]
]

{ #category : 'Copying' }
Array >> replaceFrom: startIndex to: stopIndex with: aCollection startingAt: repIndex [

"Replaces the elements of the receiver between the indexes startIndex and
 stopIndex inclusive with the elements of aSeqCollection starting at repIndex.
 If aCollection is identical to the receiver, the source and
 destination blocks may overlap.

 aCollection must be a kind of SequenceableCollection or a kind of IdentityBag.

 Returns the receiver."

<primitive: 608>
startIndex _isSmallInteger ifFalse:[ startIndex _validateClass: SmallInteger ].
stopIndex _isSmallInteger ifFalse:[ stopIndex _validateClass: SmallInteger ].
repIndex _isSmallInteger ifFalse:[ repIndex _validateClass: SmallInteger ].

^ super replaceFrom: startIndex to: stopIndex with: aCollection startingAt: repIndex
]
