Extension { #name : 'AlmostOutOfMemoryError' }

{ #category : 'Control' }
AlmostOutOfMemoryError class >> disable [
  "Disables signalling of AlmostOutOfMemoryError and resets threshold to 90%"
  System _updateSignalErrorStatus: 9 toState: -1 .

]

{ #category : 'Control' }
AlmostOutOfMemoryError class >> enable [
  "Enable signaling of AlmostOutOfMemoryError with the current threshold.
  If no in-memory garbage collection has run since the last delivery
  of an AlmostOutOfMemory or AlmostOutOfMemoryError, then the actual enable will
  be deferred until after in-memory garbage collection ."

  System _updateSignalErrorStatus: 9 toState: 0 .

]

{ #category : 'Control' }
AlmostOutOfMemoryError class >> enableAtThreshold: anInteger [
  "anInteger represents a percentage and must be between 1 and 125.
  Sets the threshold for signalling AlmostOutOfMemoryError  .
  and enables the signalling of AlmostOutOfMemoryError .
  Threshold is also used by AlmostOutOfMemory (a Notification) if enabled.
  Returns the receiver."

  AlmostOutOfMemory _validateThreshold: anInteger .
  System _updateSignalErrorStatus: 9 toState: anInteger .

]

{ #category : 'Control' }
AlmostOutOfMemoryError class >> enabled [
  "Returns true if signaling of AlmostOutOfMemoryError is enabled.

   See also AlmostOutOfMemoryError >> enable .
   If the effect of the previous enable was deferred, will return false."
  ^ (System _signalErrorStatus: 9 ) > 0

]

{ #category : 'Control' }
AlmostOutOfMemoryError class >> threshold [
  "Returns the current threshold without changing enabled status
   of AlmostOutOfMemoryError.
   Threshold is shared with AlmostOutOfMemory (a Notification) ."

  ^ AlmostOutOfMemory threshold

]

{ #category : 'Control' }
AlmostOutOfMemoryError class >> threshold: anInteger [
  "anInteger represents a percentage and must be between 1 and 125.
  Sets the threshold for signalling AlmostOutOfMemoryError 
  without changing the enabled status .
  Threshold is shared with AlmostOutOfMemory (a Notification) .
  Returns the receiver."

  ^ AlmostOutOfMemory threshold: anInteger .

]

{ #category : 'Instance initialization' }
AlmostOutOfMemoryError >> initialize [
  gsNumber := 2744"ERR_AlmostOutOfMemory".
  gsResumable := true .
  gsTrappable := true .

]
