Extension { #name : 'AlmostOutOfMemory' }

{ #category : 'Control' }
AlmostOutOfMemory class >> _validateThreshold: anInteger [

  "anInteger represents a percentage and must be between 1 and 125."

  anInteger _isSmallInteger ifFalse:[ anInteger _validateClass: SmallInteger ].
  (anInteger < 1 or:[ anInteger > 125]) ifTrue:[
    OutOfRange new name: 'threshold' min: 1 max: 125 actual: anInteger ;
	signal
  ].

]

{ #category : 'Control' }
AlmostOutOfMemory class >> disable [
  "Disables signalling of AlmostOutOfMemory and resets threshold to 90%"
  System _updateSignalErrorStatus: 5 toState: -1 .
  ^ self

]

{ #category : 'Control' }
AlmostOutOfMemory class >> enable [
  "Enable signaling of AlmostOutOfMemory with the current threshold.
  If no in-memory garbage collection has run since the last delivery
  of an AlmostOutOfMemory exception, then the actual enable will
  be deferred until after in-memory garbage collection .

  You must install a handler for AlmostOutOfMemory to take action
  or execute
    Notification enableSignalling
  to have AlmostOutOfMemory and other Notifications signalled to the
  application to avoid having AlmostOutOfMemory silently ignored."

  System _updateSignalErrorStatus: 5 toState: 0 .
  ^ self

]

{ #category : 'Control' }
AlmostOutOfMemory class >> enableAtThreshold: anInteger [

  "anInteger represents a percentage and must be between 1 and 125.
  Sets the threshold for signalling AlmostOutOfMemory notification
  and enables the notification.  
  Threshold is also used by AlmostOutOfMemoryError if enabled.
  Returns the receiver."

  self _validateThreshold: anInteger .
  System _updateSignalErrorStatus: 5 toState: anInteger .
  ^ self

]

{ #category : 'Control' }
AlmostOutOfMemory class >> enabled [
  "Returns true if signaling of AlmostOutOfMemory is enabled.

   See also AlmostOutOfMemory >> enable .
   If the effect of the previous enable was deferred, will return false."
  ^ (System _signalErrorStatus: 5) > 0

]

{ #category : 'Control' }
AlmostOutOfMemory class >> threshold [
  "Returns the current threshold without changing enabled status
   of the AlmostOutOfMemory notification.
  Threshold is shared with AlmostOutOfMemoryError . "

  ^ System _updateSignalErrorStatus: 7 toState: -1 .

]

{ #category : 'Control' }
AlmostOutOfMemory class >> threshold: anInteger [
  "anInteger represents a percentage and must be between 1 and 125.
  Sets the threshold for signalling AlmostOutOfMemory notification
  without changing the enabled status .
  Threshold is shared with AlmostOutOfMemoryError .
  Returns the receiver."

  self _validateThreshold: anInteger .
  System _updateSignalErrorStatus: 7 toState: anInteger .
  ^ self

]

{ #category : 'Instance initialization' }
AlmostOutOfMemory >> initialize [
  gsNumber := ERR_AlmostOutOfMemory.
  gsResumable := true .
  gsTrappable := true .

]
