Extension { #name : 'Behavior' }

{ #category : 'Modifying Classes' }
Behavior >> _addClassVar: aSymbol value: aVal [

"Adds the class variable with name aSymbol to the receiver's
 class variables dictionary.

 FINAL implementation in behavio_2.gs "
  | dict |
  self _validatePrivilege ifTrue:[
    (dict := classVars) ifNil:[
      dict := self _createClassVarsDict .
    ].
    dict at: aSymbol put: aVal .
  ]

]

{ #category : 'Updating the Method Dictionary' }
Behavior >> _basicRemoveSelector: aSymbol environmentId: envId [
  "returns  true if a method found to remove"
| md pmd removed tmeth pmeth |
self _validatePrivilege ifFalse:[ ^ false ].
md := self transientMethodDictForEnv: envId .
removed := false .
md ifNotNil:[
  tmeth := md removeKey: aSymbol otherwise: nil .
].
pmd := self persistentMethodDictForEnv: envId .
pmd ifNotNil:[
  pmeth := pmd removeKey: aSymbol otherwise: nil .
].
"refresh method lookup caches to account for removal of the selector
 and delete any breakpoints in the removed method(s) ."
tmeth ifNotNil:[
  removed := true .
  self _refreshLookupCache: aSymbol oldMethod: tmeth env: envId .
].
pmeth ifNotNil:[
  removed := true .
  self _codeChangedForEnv: envId .
  self _refreshLookupCache: aSymbol oldMethod: pmeth env: envId .
].
^ removed

]

{ #category : 'Updating the Method Dictionary' }
Behavior >> _rwCompileMethodForConditionalPackaging: sourceString symbolList: symList category: categ environmentId: environmentId ifUnpackagedDo: unpackagedBlock [
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	^ unpackagedBlock value

]

{ #category : 'Updating Categories' }
Behavior >> _rwMoveMethod: aSelector toCategory: categoryName [
	^ self _moveMethod: aSelector toCategory: categoryName
]

{ #category : 'Updating the Method Dictionary' }
Behavior >> _rwRemoveAllMethods: baseMeths environmentId: envId [
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	envId == 0
		ifFalse: [ 
			"only set time stamps for methods in envId 0"
			^ self ].
	baseMeths
		keysAndValuesDo: [ :sel :meth | 
			self setStamp: nil forMethod: sel ].

]

{ #category : 'Updating the Method Dictionary' }
Behavior >> _rwRemoveSelector: aString environmentId: envId ifUnpackagedDo: unpackagedBlock [
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	^ unpackagedBlock value

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> _topazMethodLookup: aString env: envId usePackages: ignoreBool [
  "Returns an Array   { actualSelector , class } "
  | sel |
  sel := aString .
  ^ { sel .
      self whichClassIncludesSelector: sel environmentId: envId
    }

]

{ #category : 'Accessing Categories' }
Behavior >> _unifiedCategorys: envId [
  | cats |
  cats := self _baseCategorys: envId .
  cats ifNil:[ cats := GsMethodDictionary new ] ifNotNil:[ cats copy ].
  ^ cats

]

{ #category : 'Category' }
Behavior >> category [

"FINAL version of this method in behavio_2.gs .

 Returns the classCategory instance variable of the receiver.  If the receiver's
 category is nil, returns its superclass's category."

| categ supercls |
categ := self _classCategory .
supercls := self superClass .
categ == nil ifTrue: [
  supercls == Object ifTrue:[ ^'User Classes' ].
  supercls == nil ifTrue: [ ^'Kernel' ].
  ^ supercls category
].
^ categ

]

{ #category : 'Pragmas' }
Behavior >> compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal [
  | sym pmd md meth |
  sym := Symbol _existingWithAll: aSelector.
  sym ifNil:[ ^ notFoundVal ].
  md := self transientMethodDictForEnv: envId .
  md ifNotNil:[
    meth := md at: sym otherwise: nil .
    meth ifNotNil:[ ^ meth ].
  ].
  pmd := self persistentMethodDictForEnv: envId .
  meth := notFoundVal .
  pmd ifNotNil:[
    meth := pmd at: sym otherwise: notFoundVal .
  ].
  ^ meth

]

{ #category : 'Updating the Method Dictionary' }
Behavior >> compileMethod: sourceString dictionaries: aSymbolList category: aCategoryString environmentId: environmentId [
	"This compiles some source code for the receiver.  The first argument,
 sourceString, is the string of source code to be compiled.  The second
 argument is a SymbolList to be used in parsing, along with the list of all
 class variables and pool dictionaries for the receiver and all of its
 superclasses.  The third argument (a String) indicates the method's category.

 sourceString must be a kind of String or DoubleByteString.  Instances of
 JapaneseString are not supported as source strings.  String literals
 ('abc') are generated as instances of the class of sourceString,
 unless sourceString is a Symbol, in which case 'abc' produces a String.
 If sourceString is a DoubleByteSymbol, 'abc' produces a DoubleByteString.

 anEnvironmentId must be a SmallInteger >= 0 and <= 16rFFFF.
 0 denotes the base Smalltalk image.  1 was reserved for use by Ruby .

 If there are no errors, this adds the resulting compiled method to the
 receiver's method dictionary and returns that method,
 otherwise signals a CompileError .
 A CompileWarning may be signaled, after adding the new method
 to a receiver's method dictionary."

	| symList categ meth |
	self _validatePrivilege
		ifFalse: [ ^ nil ].

	aSymbolList class == SymbolList
		ifTrue: [ symList := aSymbolList ]
		ifFalse: [ 
			aSymbolList _validateClass: Array.
			symList := SymbolList withAll: aSymbolList ].
	categ := aCategoryString asSymbol.

	GsObjectSecurityPolicy
		setCurrent: self objectSecurityPolicy
		while: [ 
			meth := self
				compileMethod: sourceString
				dictionaries: symList
				category: categ
				intoMethodDict: nil
				intoCategories: nil
				environmentId: environmentId ].
	^ meth
]

{ #category : 'Accessing Categories' }
Behavior >> env: environmentId categorysDo: aBlock [
  "evaluates aBlock for each method category of receiver
   in specified environment. Returns the receiver.

   aBlock should be a two argument block
   expecting the args  categoryNameSymbol ,   selectorsSet.
   If the package manager is active in the current session,
   aBlock may be invoked more than once for each category name.
   The iteration is done directly over the receiver's categories."

  self env: environmentId baseCategorysDo: aBlock

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> includesSelector: aString environmentId: envId [

"Returns true if the receiver defines a method for responding to aString."
  (Symbol _existingWithAll: aString) ifNotNil:[:sym |
     ^ (self compiledMethodAt: sym environmentId: envId otherwise: nil) ~~ nil
  ].
  ^ false

]

{ #category : 'Pragmas' }
Behavior >> pragmasForMethod: selector [
        "Need to install SessionMethod support to access Pragmas"

        ^#()

]

{ #category : 'Modifying Classes' }
Behavior >> recompileAllMethodsInContext: aSymbolList [

"behavio_2.gs installs real implementation"

^ self

]

{ #category : 'Modifying Classes' }
Behavior >> recompileAllSubclassMethodsInContext: aSymbolList [

"behavio_2.gs installs real implementation"

^ self

]

{ #category : 'Updating the Method Dictionary' }
Behavior >> removeAllMethods [
"FINAL implementation in Filein3B ... "
  ^ self removeAllMethods: 0
]

{ #category : 'Updating the Method Dictionary' }
Behavior >> removeAllMethods: envId [

"Removes all methods from the receiver.  This should not be done without
 considerable forethought!"

"FINAL implementation in Filein4Rowan"

| baseCats baseMeths |
self _validatePrivilege ifFalse:[ ^ nil ].
baseCats := self _baseCategorys: envId .
baseCats ifNotNil: [ baseCats removeAll ].
baseMeths := self persistentMethodDictForEnv: envId .
baseMeths ifNotNil: [
  baseMeths removeAll .
].
self _clearLookupCaches: envId .
]

{ #category : 'Updating Categories' }
Behavior >> removeCategory: categoryName environmentId: envId [
  "behavio_2.gs installs real implementation"
  ^ self _removeBaseCategory: categoryName environmentId: envId

]

{ #category : 'Updating the Method Dictionary' }
Behavior >> removeSelector: aString environmentId: envId [

	"Filein3B.gs installs final implementation"
| sym |
sym := Symbol _existingWithAll: aString .
sym ifNil:[ self error:'the selector ', aString , '  does not exist' ].
self _basicRemoveSelector: sym environmentId: envId.
self env: envId baseCategorysDo: [ :categName :selectors |
  (selectors remove: sym ifAbsent:[ nil ]) ifNotNil:[
    ^ self "done"
  ].
].

]

{ #category : 'Accessing the Method Dictionary' }
Behavior >> whichClassIncludesSelector: aString environmentId: envId [

"behavio_2.gs installs real implementation"

  | currClass aSymbol |
  aSymbol := Symbol _existingWithAll: aString .
  aSymbol ifNil:[ ^ nil ].

  currClass := self.
  [ currClass == nil ] whileFalse:[
    (currClass includesSelector: aSymbol) ifTrue:[ ^ currClass ].
    currClass := currClass superClass
  ].
  ^ nil

]

