Class {
	#name : 'RwPkgAdoptTool',
	#superclass : 'RwPackageTool',
	#category : 'Rowan-Tools-Core'
}

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClass: theClass classExtension: classExtension instanceSelectors: instanceSelectors classSelectors: classSelectors intoPackageNamed: packageName [
	"adopt the methods for class named <className> and it's methods into the package named <packageName>, 
		if it is not a <classExtension>, adopt the class into the package as well."

	"Ignore packaged instance and class methods"

	| loadedPackage loadedProject packageSymDictName theSymbolDictionary registry theBehavior className |
	loadedPackage := Rowan image loadedPackageNamed: packageName.
	loadedProject := loadedPackage loadedProject.
	className := theClass name asString.

	packageSymDictName := (loadedProject
		gemstoneSymbolDictNameForPackageNamed: packageName) asSymbol.
	theSymbolDictionary := Rowan image symbolDictNamed: packageSymDictName.

	registry := theSymbolDictionary rowanSymbolDictionaryRegistry.

	classExtension
		ifFalse: [ 
			[ 
			(Rowan image
				validClassCategory: theClass category
				forLoadedPackage: loadedPackage)
				ifFalse: [ 
					(RwAdoptClassCategoryPackageConventionViolationErrorNotification
						classNamed: className
						classCategory: theClass category
						packageConvention: loadedProject packageConvention
						intoPackageNamed: packageName) signal.
					^ self	"if exception resumed then we'll skip the adopt operation for this class" ].
			registry
				addClassAssociation: (theSymbolDictionary associationAt: theClass name)
				forClass: theClass
				toPackageNamed: packageName ]
				on: RwExistingAssociationWithSameKeyNotification
				do: [ :ex | ex resume ] ].

	theBehavior := theClass.
	instanceSelectors
		do: [ :methodSelector | 
			| theCompiledMethod |
			theCompiledMethod := (theBehavior
				compiledMethodAt: methodSelector
				otherwise: nil)
				ifNil: [ 
					(RwAdoptMissingMethodErrorNotification
						method: methodSelector
						isMeta: false
						inClassNamed: className
						isClassExtension: classExtension
						intoPackageNamed: packageName) signal.	"skip adoption of this method"
					nil ].
			theCompiledMethod
				ifNotNil: [ 
					theCompiledMethod isFromTrait not
						ifTrue: [ 
							registry
								adoptCompiledMethod: theCompiledMethod
								classExtension: classExtension
								for: theBehavior
								protocol: (theBehavior categoryOfSelector: methodSelector)
								toPackageNamed: packageName ] ] ].

	theBehavior := theClass class.
	classSelectors
		do: [ :methodSelector | 
			| theCompiledMethod |
			theCompiledMethod := (theBehavior
				compiledMethodAt: methodSelector
				otherwise: nil)
				ifNil: [ 
					(RwAdoptMissingMethodErrorNotification
						method: methodSelector
						isMeta: true
						inClassNamed: className
						isClassExtension: classExtension
						intoPackageNamed: packageName) signal.	"skip adoption of this method"
					nil ].
			theCompiledMethod
				ifNotNil: [ 
					theCompiledMethod isFromTrait not
						ifTrue: [ 
							registry
								adoptCompiledMethod: theCompiledMethod
								classExtension: classExtension
								for: theBehavior
								protocol: (theBehavior categoryOfSelector: methodSelector)
								toPackageNamed: packageName ] ] ]
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClass: theClass intoPackageNamed: packageName [
	"adopt the class named <className> and it's methods into the package named <packageName>"

	"Ignore packaged instance and class methods"

	self
		adoptClass: theClass
		classExtension: false
		instanceSelectors: theClass selectors
		classSelectors: theClass class selectors
		intoPackageNamed: packageName
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClassExtension: theClass instanceSelectors: instanceSelectors classSelectors: classSelectors intoPackageNamed: packageName [
	"adopt extension methods for the class named <className> into the package named <packageName>"

	^ self
		adoptClass: theClass
		classExtension: true
		instanceSelectors: instanceSelectors
		classSelectors: classSelectors
		intoPackageNamed: packageName
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClassExtensionNamed: className  instanceSelectors: instanceSelectors classSelectors: classSelectors intoPackageNamed: packageName [

	"adopt extension methods for the class named <className> into the package named <packageName>"

	self 
		adoptClassNamed: className 
		classExtension: true 
		instanceSelectors: instanceSelectors 
		classSelectors: classSelectors 
		intoPackageNamed: packageName

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClassNamed: className classExtension: classExtension instanceSelectors: instanceSelectors classSelectors: classSelectors intoPackageNamed: packageName [
	"adopt the methods for class named <className> and it's methods into the package named <packageName>, 
		if it is not a <classExtension>, adopt the class into the package as well."

	"Ignore packaged instance and class methods"

	| loadedPackage loadedProject packageSymDictName theClass theSymbolDictionary |
	loadedPackage := Rowan image loadedPackageNamed: packageName.
	loadedProject := loadedPackage loadedProject.

	packageSymDictName := (loadedProject gemstoneSymbolDictNameForPackageNamed: packageName)
		asSymbol.
	theSymbolDictionary := Rowan image symbolDictNamed: packageSymDictName.

	theClass := theSymbolDictionary
		at: className asSymbol
		ifAbsent: [ 
			(RwAdoptMissingClassErrorNotification
				classNamed: className
				isClassExtension: classExtension
				intoPackageNamed: packageName) signal.
			"if exception resumed then we'll skip the adopt operation for this class"
			^ self ].
	^ self adoptClass: theClass classExtension: classExtension instanceSelectors: instanceSelectors classSelectors: classSelectors intoPackageNamed: packageName
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClassNamed: className  instanceSelectors: instanceSelectors classSelectors: classSelectors intoPackageNamed: packageName [

	"adopt the class named <className> and it's methods into the package named <packageName>"

	"Ignore packaged instance and class methods"
	
	self 
		adoptClassNamed: className 
		classExtension: false 
		instanceSelectors: instanceSelectors 
		classSelectors: classSelectors 
		intoPackageNamed: packageName

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptClassNamed: className  intoPackageNamed: packageName [

	"adopt the class named <className> and it's methods into the package named <packageName>"

	"Ignore packaged instance and class methods"

	| theClass |

	theClass := Rowan globalNamed: className.
	self 
		adoptClassNamed: className 
		instanceSelectors: theClass selectors 
		classSelectors: theClass class selectors 
		intoPackageNamed: packageName

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptMethod: methodSelector inClassNamed: className  isMeta: isMeta intoPackageNamed: packageName [

	"adopt the method <methodSelector> in class named <className> and it's methods into the package named <packageName>"

	| theClass theBehavior protocolString  |
	theClass := Rowan globalNamed: className.
	theBehavior := isMeta
		ifTrue: [ theClass class ]
		ifFalse: [ theClass ].
	protocolString := (theBehavior categoryOfSelector: methodSelector asSymbol) asString. 
	self 
		adoptMethod: methodSelector 
		protocol: protocolString 
		inClassNamed: className  
		isMeta: isMeta 
		intoPackageNamed: packageName

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptMethod: methodSelector protocol: protocolString inClassNamed: className isMeta: isMeta intoPackageNamed: packageName [
	"adopt the method <methodSelector> in class named <className> and it's methods into the package named <packageName>.
		move the method into protocol <protocolString> "

	| loadedPackage loadedProject packageSymDictName theClass theSymbolDictionary registry theBehavior theCompiledMethod |
	loadedPackage := Rowan image loadedPackageNamed: packageName.
	loadedProject := loadedPackage loadedProject.

	packageSymDictName := loadedProject gemstoneSymbolDictNameForPackageNamed: packageName.

	theClass := Rowan globalNamed: className.
	theSymbolDictionary := Rowan image symbolDictNamed: packageSymDictName.

	registry := theSymbolDictionary rowanSymbolDictionaryRegistry.

	theBehavior := isMeta
		ifTrue: [ theClass class ]
		ifFalse: [ theClass ].

	theCompiledMethod := theBehavior compiledMethodAt: methodSelector.

	theCompiledMethod rowanProjectName = Rowan unpackagedName
		ifFalse: [ 
			self
				error:
					'The method ' , className printString , '>>' , methodSelector asString
						, ' is already packaged ... no need to adopt' ].

	theClass rowanPackageName ~= packageName
		ifTrue: [ 
			| theProtocolString |
			theProtocolString := protocolString.
			loadedProject packageConvention ~= 'Rowan'
				ifTrue: [ 
					"must fabricate a new protocolString if it does not match convention"
					(theProtocolString beginsWith: '*')
						ifFalse: [ theProtocolString := '*' , packageName asLowercase ] ].
			registry
				addExtensionCompiledMethod: theCompiledMethod
				for: theBehavior
				protocol: theProtocolString
				toPackageNamed: packageName ]
		ifFalse: [ 
			registry
				adoptCompiledMethod: theCompiledMethod
				classExtension: false
				for: theBehavior
				protocol: protocolString
				toPackageNamed: packageName ]
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptSymbolDictionary: symbolDictionary intoPackageNamed: packageName [

	"create loaded classes in the loaded package <packageName> for the unpackaged classes in <symbolDictionary>"

	symbolDictionary keysAndValuesDo: [:className :object |
		object isBehavior
			ifTrue: [ 
				object rowanPackageName = Rowan unpackagedName
					ifTrue: [ self adoptClassNamed: className asString intoPackageNamed: packageName ] ] ]
.

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptSymbolDictionaryNamed: symDictName intoPackageNamed: packageName [

	"create loaded classes in the loaded package <packageName> for the unpackaged classes in the symbol dictionary named <symDictName>"

	^ self adoptSymbolDictionary: (Rowan image symbolDictNamed: symDictName) intoPackageNamed: packageName
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptSymbolList: symbolList excluding: excludedSymbolDictionaries intoPackagesNamed: packageNameMap [

	"create loaded classes for the unpackaged classes in each of the symbol dictionaries in symbolList, except for those listed in
		<excludedSymbolDictionaries>. The loaded classes should be created in the package associated with the name of the symbol 
		dictionary in <packageNameMap>"

	symbolList do: [:symbolDict |
		(excludedSymbolDictionaries includes: symbolDict)
			ifFalse: [ self adoptSymbolDictionary: symbolDict intoPackageNamed: (packageNameMap at: symbolDict name asString) ] ]

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptSymbolList: symbolList excludingSymbolDictsNamed: excludedSymbolDictionaryNames intoPackagesNamed: packageNameMap [

	"create loaded classes for the unpackaged classes in each of the symbol dictionaries in symbolList, except for those named in
		<excludedSymbolDictionaryNames>. The loaded classes should be created in the package associated with the name of the symbol 
		dictionary in <packageNameMap>"

	symbolList do: [:symbolDict |
		| symDictName |
		symDictName := symbolDict name asString.
		(excludedSymbolDictionaryNames includes: symDictName)
			ifFalse: [ self adoptSymbolDictionary: symbolDict intoPackageNamed: (packageNameMap at: symDictName) ] ]

]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptTrait: theTrait intoPackageNamed: packageName [
	"adopt the trait and all  of its methods for trait  into the package named <packageName>"

	"Ignore packaged instance and class methods"

	| loadedPackage loadedProject packageSymDictName theSymbolDictionary registry traitName loadedTrait |
	loadedPackage := Rowan image loadedPackageNamed: packageName.
	loadedProject := loadedPackage loadedProject.
	traitName := theTrait name asString.

	packageSymDictName := (loadedProject
		gemstoneSymbolDictNameForPackageNamed: packageName) asSymbol.
	theSymbolDictionary := Rowan image symbolDictNamed: packageSymDictName.

	registry := theSymbolDictionary rowanSymbolDictionaryRegistry.

	[ 
	(Rowan image
		validClassCategory: theTrait category
		forLoadedPackage: loadedPackage)
		ifFalse: [ 
			(RwAdoptTraitCategoryPackageConventionViolationErrorNotification
				traitNamed: traitName
				traitCategory: theTrait category
				packageConvention: loadedProject packageConvention
				intoPackageNamed: packageName) signal.	"
			if exception resumed then we'll skip the adopt operation for this class"
			^ self ].
	loadedTrait := registry
		addTraitAssociation: (theSymbolDictionary associationAt: theTrait name)
		forTrait: theTrait
		toPackageNamed: packageName ]
		on: RwExistingAssociationWithSameKeyNotification
		do: [ :ex | ex resume ].	"
	adopt the method source for instance and class sides"
	{{theTrait.
	#'loadedMethodForTrait:source:protocol:'.
	#'addLoadedMethod:'}.
	{(theTrait classTrait).
	#'loadedClassMethodForTrait:source:protocol:'.
	#'addLoadedClassMethod:'}}
		do: [ :ar | 
			| trait sel1 sel2 |
			trait := ar at: 1.
			sel1 := ar at: 2.
			sel2 := ar at: 3.
			trait localSelectors
				do: [ :sel | 
					| src cat loadedMethod |
					src := trait sourceCodeAt: sel.
					cat := (trait categoryOfSelector: sel) asString.
					loadedMethod := RwGsLoadedSymbolDictTraitMethod
						perform: sel1
						withArguments:
							{trait.
							src.
							cat}.
					loadedTrait perform: sel2 with: loadedMethod ] ]
]

{ #category : 'smalltalk api' }
RwPkgAdoptTool >> adoptTraitNamed: traitName intoPackageNamed: packageName [
	"adopt the trait n and it's methods into the package named <packageName>"

	| theTrait loadedPackage loadedProject packageSymDictName theSymbolDictionary |
	loadedPackage := Rowan image loadedPackageNamed: packageName.
	loadedProject := loadedPackage loadedProject.

	packageSymDictName := (loadedProject
		gemstoneSymbolDictNameForPackageNamed: packageName) asSymbol.
	theSymbolDictionary := Rowan image symbolDictNamed: packageSymDictName.

	theTrait := theSymbolDictionary
		at: traitName asSymbol
		ifAbsent: [ 
			((Globals at: #'RwAdoptMissingTraitErrorNotification')
				traitNamed: traitName
				intoPackageNamed: packageName) signal.	"
			if exception resumed then we'll skip the adopt operation for this trait"
			^ self ].
	^ self adoptTrait: theTrait intoPackageNamed: packageName
]
