Class {
	#name : 'RsrProtocolVersionNegotiationClient',
	#superclass : 'RsrProtocolVersionNegotiation',
	#category : 'RemoteServiceReplication',
	#package : 'RemoteServiceReplication'
}

{ #category : 'performing' }
RsrProtocolVersionNegotiationClient >> performFor: aHandshake
over: aStream [
	"Perform the Client's porition of the handshake"

	| answer wireProtocol |
	self codec
		encodeSupportedVersions: self supportedVersions
		onto: aStream.
	aStream flush.
	answer := self codec decode: aStream.
	answer hasSharedVersion
		ifFalse: [^RsrProtocolVersionNegotiationFailed signal: 'The Client and Server could not agree on an RSR protocol version.'].
	wireProtocol := self wireProtocols
		detect: [:each | each version = answer version]
		ifNone: [^RsrProtocolVersionNegotiationFailed signal: 'Server''s chosen protocol version is unsupported.'].
	aHandshake wireProtocol: wireProtocol
]

{ #category : 'accessing' }
RsrProtocolVersionNegotiationClient >> supportedVersions [

	^RsrSupportedVersions versions: (self wireProtocols collect: [:each | each version])
]
