Class {
	#name : 'RsrInMemoryServiceTest',
	#superclass : 'RsrServiceTest',
	#category : 'RemoteServiceReplication-Test',
	#package : 'RemoteServiceReplication-Test'
}

{ #category : 'running' }
RsrInMemoryServiceTest >> setUp [

	super setUp.
	self initializeInMemoryConnections
]

{ #category : 'running' }
RsrInMemoryServiceTest >> testSendClientWithoutAssociatedServer [
	"See RsrSocketServiceTestV2>>testSendClientWithoutAssociatedServer"

	| client server reason |
	client := RsrRemoteActionClient new
		registerWith: connectionA;
		synchronize.
	server := connectionB serviceAt: client _id.
	server action: [:x | x].
	reason := self expectCatch: (client asyncValue: RsrKnownClient new).
	self
		assert: reason class
		equals: RsrRemoteExceptionServer.
	self
		assert: reason exceptionClassName
		equals: #RsrUnknownClass
]
