/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - getservbyname.c
 *
 * Description - Program to verify presence of a given service, i.e.
 *               by the getservbyname(2) call.
 *
 *========================================================================
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <netdb.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>

int main(int argc, char *argv[])
{
  struct servent *thisOne;
  char **thisAlias;
  char s[BUFSIZ];

  if (argc != 2) {
    printf("Usage: %s <service-name>\n", argv[0]);
    exit(1);
  }

  strncpy(s, argv[1], sizeof(s));
  thisOne = getservbyname(s, NULL);
  if (thisOne == NULL) {
    printf("%s:  (no entry, errno = %d)\n", s, errno);
    exit(1);
  }
  printf("s_name=%s s_port = %d s_proto = %s\n", thisOne->s_name,
    ntohs(thisOne->s_port), thisOne->s_proto);
  if (*thisOne->s_aliases != NULL) {
    printf("aliases: ");
    for (thisAlias = thisOne->s_aliases; *thisAlias != NULL; thisAlias ++)
      printf("%s ", *thisAlias);
    printf("\n");
  }

  return 0;
}
