/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - gethostbyname.c
 *
 * Description -
 *
 * Compile with:
 *   cc -o gethostbyname gethostbyname.c
 *   chmod 555 gethostbyname
 *
 *========================================================================
 */

#include "flag.ht"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#if defined(_WIN32)
#include <winsock.h>
#include <io.h>
#else
#include <netdb.h>
#endif
#include <ctype.h>
#include <errno.h>

#if defined(_WIN32)
  /* declaration OK */
#elif defined(x86_64Linux) || defined(__APPLE_CC__) || defined(__APPLE_CPP__)
  /* declared in tnetmac.hf */
#else
extern struct hostent *gethostbyname();
#endif

#if defined(_WIN32)
#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))

static void ShutdownNetwork(void)
{
  WSACleanup();
}

static void InitNetwork(void)
{
  WSADATA wsaData;
  WORD version = MAKEWORD(1,1);
  int err = WSAStartup(version, &wsaData);
  if( err == 0 )
    if( LOBYTE(wsaData.wVersion) != LOBYTE(version) ||
       HIBYTE(wsaData.wVersion) != HIBYTE(version) )
      {
        err = WSAVERNOTSUPPORTED;
        fprintf(stderr,
                "The lowest version supported by the DLL is = %d.%d\n",
                LOBYTE(wsaData.wVersion),
                HIBYTE(wsaData.wVersion) );
        fprintf(stderr,
                "The higest version supported by the DLL is = %d.%d\n",
                LOBYTE(wsaData.wHighVersion),
                HIBYTE(wsaData.wHighVersion) );
        WSACleanup();
        exit(1);
      }
  if( err != 0 )
    {
      switch(err)
        {
        case WSASYSNOTREADY:
          fprintf(stderr, "Windows Socket subsystem not ready.\n");
          break;
        case WSAVERNOTSUPPORTED:
          fprintf(stderr, "Windows Socket API version %d.%d not supported\n",
                  LOBYTE(version), HIBYTE(version) );
          break;
        case WSAEINVAL:
          fprintf(stderr, "Windows Socket version %d.%d not supported\n",
                  LOBYTE(version), HIBYTE(version) );
          break;
        default:
          fprintf(stderr, "Could not find winsock.dll. error=%d\n", err);
          break;
        }
      exit(1);
    }
  atexit(ShutdownNetwork);
  return;
}
#endif

int main(int argc, char *argv[])
{
struct hostent *thisOne;
char **thisAlias;
char s[BUFSIZ];

if (argc != 2) {
  printf("Usage: %s <host-name>\n", argv[0]);
  exit(1);
  }
strncpy(s, argv[1], sizeof(s));

#if defined(_WIN32)
InitNetwork();
#endif


thisOne = gethostbyname(s);

if (thisOne == NULL) {
  fprintf(stderr,
      "%s:  (no entry, errno = %d, h_errno = %d)\n", s, errno, h_errno);
  return 1;
}
printf("h_name=%s h_addrtype = %d h_addr = %d.%d.%d.%d\n",
    thisOne->h_name, thisOne->h_addrtype,
    (unsigned char)thisOne->h_addr[0], (unsigned char)thisOne->h_addr[1],
    (unsigned char)thisOne->h_addr[2], (unsigned char)thisOne->h_addr[3]);
#if defined(h_addr)
{ /* new style address list */
  int i;
  unsigned long *current;

  for (i = 1;; i ++) {
    current = (unsigned long *)thisOne->h_addr_list[i];
    if (current == NULL)
      break;
    printf("    %d.%d.%d.%d\n",
	(unsigned char)thisOne->h_addr[0], (unsigned char)thisOne->h_addr[1],
	(unsigned char)thisOne->h_addr[2], (unsigned char)thisOne->h_addr[3]);
    }
}
#endif

if (*thisOne->h_aliases != NULL) {
  printf("aliases: ");
  for (thisAlias = thisOne->h_aliases; *thisAlias != NULL; thisAlias ++)
    printf("%s ", *thisAlias);
  printf("\n");
  }
return 0;
}
