time
run
| nSess sessions tStart params tLoginsDone tEnd lib |
lib := GciTsLibrary newForVersion:'3.6.0' product: '$GEMSTONE'  .
tStart := DateTime now .
nSess := 1 .
(params := GemStoneParameters new)
    gemService:    GsNetworkResourceString defaultGemNRSFromCurrent printString;
    gemStoneName:  GsNetworkResourceString defaultStoneNRSFromCurrent printString;
    username:    System myUserProfile userId;
    password:    'swordfish' copy .
params loginFlags: (params loginFlags bitXor: 16r10).  "clear quiet bit"
sessions := Array new: nSess .
1 to: nSess do:[:n | | ses |
  ses := (GsTsExternalSession parameters: params library: lib) nbLogin.
  sessions at: n put: ses .
].
1 to: nSess do:[:m | | ses |
  ses := sessions at: m .
  ses waitForReadReady .
  ses nbLoginFinished ifFalse:[ Error signal:'login problem'].
  GsFile gciLogServer:'login ', m asString, ' finished'.
].
GsFile gciLogServer:'tStart      ' , tStart asStringMs .
GsFile gciLogServer:'logins done ' , (tLoginsDone := DateTime now asStringMs) .
10  timesRepeat:[ | nRunning |
  nRunning := 0 .
  1 to: nSess do:[:k |
   nRunning := nRunning + 1 .
   [:idx | | ses status res |
     ses := sessions at: idx .
     ses nbSend: #size to: Globals withArguments: #() .
     ses waitForReadReady .
     res := ses nbResult  .  
     res == Globals size ifFalse:[ Error signal:'bad result'].
     nRunning := nRunning - 1 .
   ] forkWith: { k } .
  ].
  [ nRunning > 0 ] whileTrue:[
    Delay waitForMilliseconds: 1.
  ].
].
GsFile gciLogServer:'end         ' , (tEnd := DateTime now asStringMs) .
^ 'done'
%
time
