time
run
| nSess sessions sockets tStart params tLoginsDone tEnd |
tStart := DateTime now .
nSess := 100 .
(params := GemStoneParameters new)
    gemService:    GsNetworkResourceString defaultGemNRSFromCurrent printString;
    gemStoneName:  GsNetworkResourceString defaultStoneNRSFromCurrent printString;
    username:    System myUserProfile userId;
    password:    'paabb' copy .
params loginFlags: (params loginFlags bitXor: 16r10 "clear quiet bit").
sessions := Array new: nSess .
sockets := Array new: nSess .
1 to: nSess do:[:n | | ses res |
  ses := GciInterface new .
  res := ses login: params flags: params loginFlags .
  res == true ifFalse:[ Error signal:'login failed, ', ses lastErrorString ].
  sessions at: n put: ses .
  sockets at: n put: (GsSocket fromFileHandle: ses notifyHandle).
].
GsFile gciLogServer:'tStart      ' , tStart asStringMs .
GsFile gciLogServer:'logins done ' , (tLoginsDone := DateTime now asStringMs) .
1000  timesRepeat:[ | nRunning |
  nRunning := 0 .
  1 to: nSess do:[:n |
   nRunning := nRunning + 1 .
   [:idx | | ses status res |
     ses := sessions at: idx .
     ses nbRemotePerform: Globals asOop selector: #size args: #() .
     (sockets at: idx)  _waitForReadReady .
     status := ses nbEndOop .
     status == 1 ifFalse:[
       Error signal:'nbEnd status ', status asString,', ', ses lastErrorString .
     ].
     res := ses lastResult .  
     res == Globals size ifFalse:[ Error signal:'bad result'].
     nRunning := nRunning - 1 .
   ] forkWith: { n } .
  ].
  [ nRunning > 0 ] whileTrue:[
    Delay waitForMilliseconds: 1.
  ].
].
GsFile gciLogServer:'end         ' , (tEnd := DateTime now asStringMs) .
^ 'done'
%
time
