"
Wrapper for $GEMSTONE/bin/waitstone
===================================
man page
--------
The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

	0 if the server (netldi or stone) is ready,
	1 if the server is already already servicing the maximum number of sessions,
	2 if the server is rejecting connections during startup or shutdown,
	3 if the server was not found.

help
-----
Usage: waitstone [-h] [gemstoneName | netLdiName] [timeout] [waitForWarming]
  where -h    prints usage information and exits.
        gemstoneName    Verify if Stone repository monitor with this name is 
                        ready to accept logins.  Waits for stone and the 
                        symbolgem to complete any low level repository upgrade.
        netldiName      Verify if NetLDI with this name is ready to accept requests
                        If neither gemStoneName noor netldiName specified, 
                        uses gs64stone.
        timeout         Number of seconds to wait.  If -1, do not wait; 
                        if omitted, wait forever.  Only valid if either gemstoneName
                        or netldiName is explicitly specified.
        waitForWarming  Block until cache warmers finish if > 0.  Do not block for cache
                        warming if 0 or omitted.
"
Class {
	#name : 'GsWaitStone',
	#superclass : 'GsHostProcess',
	#category : 'GsCommands-Commands'
}

{ #category : 'execution' }
GsWaitStone class >> _execute: stoneOrNetldiNameOrNil timeout: numberOfSecondsOrNil waitForWarming: waitForCacheWarmersCountOrNil [
	"
      The exit status of waitstone is one of the following:

           0 if the server (netldi or stone) is ready,
           1 if the server is already already servicing the maximum number of sessions,
           2 if the server is rejecting connections during startup or shutdown,
           3 if the server was not found.
"

	| ar commandLineString |
	commandLineString := '$GEMSTONE/bin/waitstone' asFileReference pathString.
	stoneOrNetldiNameOrNil
		ifNotNil: [ 
			commandLineString := commandLineString , ' ' , stoneOrNetldiNameOrNil.
			numberOfSecondsOrNil
				ifNotNil: [ 
					commandLineString := commandLineString , ' ' , numberOfSecondsOrNil asString.
					waitForCacheWarmersCountOrNil
						ifNotNil: [ 
							commandLineString := commandLineString , ' '
								, waitForCacheWarmersCountOrNil asString ] ] ].
	ar := self _execute: commandLineString input: nil.
	^ ar at: 1	"stdout"
]

{ #category : 'invocation' }
GsWaitStone class >> waitFor [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	self _execute: nil timeout: nil waitForWarming: nil.
	^ 'the server (netldi or stone) gs64stone is ready'
]

{ #category : 'invocation' }
GsWaitStone class >> waitFor: stoneOrNetldiName timeout: numberOfSeconds waitForWarming: waitForCacheWarmersCount [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	"
Usage: waitstone [-h] [gemstoneName | netLdiName] [timeout] [waitForWarming]
  where -h    prints usage information and exits.
        gemstoneName    Verify if Stone repository monitor with this name is 
                        ready to accept logins.  Waits for stone and the 
                        symbolgem to complete any low level repository upgrade.
        netldiName      Verify if NetLDI with this name is ready to accept requests
                        If neither gemStoneName noor netldiName specified, 
                        uses gs64stone.
        timeout         Number of seconds to wait.  If -1, do not wait; 
                        if omitted, wait forever.  Only valid if either gemstoneName
                        or netldiName is explicitly specified.
        waitForWarming  Block until cache warmers finish if > 0.  Do not block for cache
                        warming if 0 or omitted.
"

	^ self
		_execute: stoneOrNetldiName
		timeout: numberOfSeconds
		waitForWarming: waitForCacheWarmersCount
]

{ #category : 'invocation' }
GsWaitStone class >> waitForNetldiName: netldiName [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	^ self _execute: netldiName timeout: nil waitForWarming: nil
]

{ #category : 'invocation' }
GsWaitStone class >> waitForNetldiName: netldiName timeout: numberOfSeconds [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	^ self _execute: netldiName timeout: numberOfSeconds waitForWarming: nil
]

{ #category : 'invocation' }
GsWaitStone class >> waitForNetldiName: netldiName timeout: numberOfSeconds waitForWarming: waitForCacheWarmersCount [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	"
Usage: waitstone [-h] [gemstoneName | netLdiName] [timeout] [waitForWarming]
  where -h    prints usage information and exits.
        gemstoneName    Verify if Stone repository monitor with this name is 
                        ready to accept logins.  Waits for stone and the 
                        symbolgem to complete any low level repository upgrade.
        netldiName      Verify if NetLDI with this name is ready to accept requests
                        If neither gemStoneName noor netldiName specified, 
                        uses gs64stone.
        timeout         Number of seconds to wait.  If -1, do not wait; 
                        if omitted, wait forever.  Only valid if either gemstoneName
                        or netldiName is explicitly specified.
        waitForWarming  Block until cache warmers finish if > 0.  Do not block for cache
                        warming if 0 or omitted.
"

	self
		_execute: netldiName
		timeout: numberOfSeconds
		waitForWarming: waitForCacheWarmersCount.
	^ 'the netldi ' , netldiName , ' is ready'
]

{ #category : 'invocation' }
GsWaitStone class >> waitForStoneName: stoneName [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	^ self _execute: stoneName timeout: nil waitForWarming: nil
]

{ #category : 'invocation' }
GsWaitStone class >> waitForStoneName: stoneName timeout: numberOfSeconds [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	^ self _execute: stoneName timeout: numberOfSeconds waitForWarming: nil
]

{ #category : 'invocation' }
GsWaitStone class >> waitForStoneName: stoneName timeout: numberOfSeconds waitForWarming: waitForCacheWarmersCount [
	"
	The waitstone command reports whether gemStoneName is ready to accept logins or whether netLdiName is ready to accept requests. Waitstone tests every 0.5 seconds to see if the process is ready. 

	When gemStoneName or netLdiName is ready, waitstone issues a message to standard output. If gemStoneName or netLdiName is not ready by the time the specified number of seconds has elapsed, waitstone reports an error to stdout. waitstone returns an exit status: 

		0 if the server (netldi or stone) is ready,
		1 if the server is already already servicing the maximum number of sessions,
		2 if the server is rejecting connections during startup or shutdown,
		3 if the server was not found.
"

	"
Usage: waitstone [-h] [gemstoneName | netLdiName] [timeout] [waitForWarming]
  where -h    prints usage information and exits.
        gemstoneName    Verify if Stone repository monitor with this name is 
                        ready to accept logins.  Waits for stone and the 
                        symbolgem to complete any low level repository upgrade.
        netldiName      Verify if NetLDI with this name is ready to accept requests
                        If neither gemStoneName noor netldiName specified, 
                        uses gs64stone.
        timeout         Number of seconds to wait.  If -1, do not wait; 
                        if omitted, wait forever.  Only valid if either gemstoneName
                        or netldiName is explicitly specified.
        waitForWarming  Block until cache warmers finish if > 0.  Do not block for cache
                        warming if 0 or omitted.
"

	^ self
		_execute: stoneName
		timeout: numberOfSeconds
		waitForWarming: waitForCacheWarmersCount
]
