# Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
#
# GDB commands for GemStone's pstack for Linux and Darwin

# Get a full stack with no user interaction
set confirm off
set pagination off
set backtrace limit 0

handle SIGIO pass nostop noprint
handle SIGPOLL pass nostop noprint
handle SIGPIPE pass nostop noprint
handle SIGWINCH pass nostop noprint
handle SIGFPE pass nostop noprint
handle SIGUSR1 pass nostop noprint
handle SIGUSR2 pass nostop noprint
handle SIGQUIT pass nostop print
handle SIG33 pass nostop noprint
handle SIG34 pass nostop noprint
handle SIG32 pass nostop noprint
handle SIGVTALRM pass nostop noprint
handle SIGSEGV  nopass stop print 
handle SIGBUS  nopass stop print 

info sharedlibrary

# get stacks with one line per frame
thread apply all backtrace

# omit long stacks
# omit smalltalk stacks

# Done, let the process continue
detach
quit
