#set verbose
#=========================================================================
# Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
#
# Name - gemsetup.csh
#
# Purpose - This is a /bin/csh "source" file that explicitly defines your 
#           GemStone environment.
#
#	    a) It adds $GEMSTONE/bin to the end of your PATH.  This is "safe"
#	       in the sense that it will avoids breaking existing user commands
#	       and applications.  It is "unsafe" in the sense that an existing
#	       user command may silently supersede a GemStone-defined command,
#	       such as "topazl".
#
#           b) It adds $GEMSTONE/doc to the end of your MANPATH.  This will
#	       not work with Ultrix and DG/UX man commands, which are not
#	       POSIX compliant.
#
# Note that this script requires that a GEMSTONE environment variable is set
# to a valid GemStone directory.
#
#=========================================================================

set gemsetup_ok = 1

if ( $gemsetup_ok ) then
  # Make this check so that -d doesn't crash
  if ( x$GEMSTONE == x ) then
    echo "gemsetup"'['"Error"']'":    GEMSTONE definition is empty"
    set gemsetup_ok = 0
  endif
endif

if ( $gemsetup_ok ) then
  if ( ! -d $GEMSTONE ) then
    echo "gemsetup"'['"Error"']'":    directory GEMSTONE does not exist"
    echo "    GEMSTONE=$GEMSTONE"
    set gemsetup_ok = 0
  endif
endif

# export, just in case user forgot...
if ( $gemsetup_ok ) then
  setenv GEMSTONE $GEMSTONE
endif

# Set path, manpath, etc.
if ( $gemsetup_ok ) then
  set gs_savepath = ( $path )
  set path = ( $GEMSTONE/bin $path )
  rehash
  set defaultManPath = /usr/man

  # bug 40199 - determine correct location for uname
  if ( -f "/bin/uname" ) then
    set UNAME = /bin/uname
  else if ( -f "/usr/bin/uname" ) then
    set UNAME = /usr/bin/uname
  else
  # Weird case.  Let's just hope it's in the path...
    set UNAME = uname
  endif
  set OS=`$UNAME -s`
  switch ($OS)
    case Linux: # Linux
      set defaultManPath = 
      breaksw
    case Darwin: # Apple Darwin
      set defaultManPath = 
      breaksw
    default:
      # for all other platforms..
      set defaultManPath = /usr/share/man
      breaksw
  endsw
  if ( $?MANPATH == 0 ) then
    setenv MANPATH ${defaultManPath}:$GEMSTONE/doc
  else
    setenv MANPATH ${MANPATH}:$GEMSTONE/doc
  endif
  unset defaultManPath
else
  echo "gemsetup"'['"Warning"']'":  GemStone setup aborted."
  set gemsetup_ok = 1
endif

unset gemsetup_ok
